/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.xml;

import java.security.AccessControlException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.namespace.QName;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.WebDavConst;
import org.exoplatform.services.jcr.webdav.resource.Resource;
import org.exoplatform.services.jcr.webdav.util.PropertyConstants;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropstatGroupedRepresentation {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.webdav.PropstatGroupedRepresentation");
    protected final Map<String, Set<HierarchicalProperty>> propStats;
    protected Set<QName> propNames = null;
    protected final boolean namesOnly;
    protected final Resource resource;
    protected final Session session;

    public PropstatGroupedRepresentation(Resource resource, Set<QName> propNames, boolean namesOnly, Session session) throws RepositoryException {
        this.session = session;
        this.namesOnly = namesOnly;
        this.resource = resource;
        this.propStats = new HashMap<String, Set<HierarchicalProperty>>();
        this.propNames = propNames;
        if (propNames != null) {
            this.propNames = new HashSet<QName>();
            for (QName property : propNames) {
                this.propNames.add(property);
            }
        }
    }

    public PropstatGroupedRepresentation(Resource resource, Set<QName> propNames, boolean namesOnly) throws RepositoryException {
        this(resource, propNames, namesOnly, null);
    }

    public final Map<String, Set<HierarchicalProperty>> getPropStats() throws RepositoryException {
        String statname = WebDavConst.getStatusDescription(200);
        if (this.propNames == null) {
            this.propStats.put(statname, this.resource.getProperties(this.namesOnly));
        } else {
            if (this.propNames.contains(PropertyConstants.DAV_ALLPROP_INCLUDE)) {
                this.propStats.put(statname, this.resource.getProperties(this.namesOnly));
                this.propNames.remove(PropertyConstants.DAV_ALLPROP_INCLUDE);
            }
            for (QName propName : this.propNames) {
                HierarchicalProperty prop = new HierarchicalProperty(propName);
                try {
                    if (propName.equals(PropertyConstants.IS_READ_ONLY) && this.session != null) {
                        if (this.isReadOnly()) {
                            prop.setValue("1");
                        } else {
                            prop.setValue("0");
                        }
                        statname = WebDavConst.getStatusDescription(200);
                    } else {
                        prop = this.resource.getProperty(propName);
                        statname = WebDavConst.getStatusDescription(200);
                    }
                }
                catch (AccessDeniedException exc) {
                    statname = WebDavConst.getStatusDescription(403);
                    log.error((Object)exc.getMessage(), (Throwable)exc);
                }
                catch (ItemNotFoundException exc) {
                    statname = WebDavConst.getStatusDescription(404);
                }
                catch (PathNotFoundException e) {
                    statname = WebDavConst.getStatusDescription(404);
                }
                catch (RepositoryException e) {
                    statname = WebDavConst.getStatusDescription(500);
                }
                if (!this.propStats.containsKey(statname)) {
                    this.propStats.put(statname, new HashSet());
                }
                Set<HierarchicalProperty> propSet = this.propStats.get(statname);
                propSet.add(prop);
            }
        }
        return this.propStats;
    }

    private boolean isReadOnly() {
        String resourcePath = this.resource.getIdentifier().getPath();
        String workspace = this.session.getWorkspace().getName();
        String path = resourcePath.substring(resourcePath.indexOf(workspace) + workspace.length());
        try {
            this.session.checkPermission(path, "read");
        }
        catch (AccessControlException e1) {
            return false;
        }
        catch (RepositoryException e1) {
            return false;
        }
        try {
            this.session.checkPermission(path, "set_property");
            return false;
        }
        catch (AccessControlException e) {
            return true;
        }
        catch (RepositoryException e) {
            return false;
        }
    }
}

