/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotInTrashFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.ecm.webui.viewer.VideoAudioViewer;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.UIExtensionManager;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={PlayMediaActionListener.class})})
public class PlayMediaComponent
extends UIAbstractManagerComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNotInTrashFilter(), new IsNotTrashHomeNodeFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    private boolean accept(Node node) throws Exception {
        if (!node.isNodeType("nt:file")) {
            return false;
        }
        String mimeType = node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("mimeType", mimeType);
        return manager.accept("org.exoplatform.ecm.dms.FileViewer", "VideoAudio", context);
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PlayMediaActionListener
    extends UIWorkingAreaActionListener<PlayMediaComponent> {
        public void processEvent(Event<PlayMediaComponent> event) throws Exception {
            PlayMediaComponent playMedia = (PlayMediaComponent)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)playMedia.getAncestorOfType(UIJCRExplorer.class);
            UIWorkingArea uiWorkingArea = (UIWorkingArea)playMedia.getParent();
            UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
            UIApplication uiApp = (UIApplication)uiWorkingArea.getAncestorOfType(UIApplication.class);
            uiDocumentWorkspace.removeChildById("PlayMedia");
            String srcPath = event.getRequestContext().getRequestParameter("objectId");
            Matcher matcher = null;
            String wsName = null;
            Node tempNode = null;
            if (srcPath.indexOf(";") > -1) {
                String[] paths = srcPath.split(";");
                ArrayList<Node> nodes = new ArrayList<Node>();
                for (String path : paths) {
                    matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(path);
                    if (!matcher.find()) {
                        throw new IllegalArgumentException("The ObjectId is invalid '" + srcPath + "'");
                    }
                    wsName = matcher.group(1);
                    srcPath = matcher.group(2);
                    tempNode = uiExplorer.getNodeByPath(srcPath, uiExplorer.getSessionByWorkspace(wsName));
                    if (playMedia.accept(tempNode)) {
                        nodes.add(tempNode);
                    }
                    if (nodes.size() != 0) continue;
                    uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.unavaiable-supported-media-file", null, 1));
                    return;
                }
                VideoAudioViewer uiViewer = (VideoAudioViewer)uiDocumentWorkspace.addChild(VideoAudioViewer.class, null, "PlayMedia");
                uiViewer.setPresentNodes(nodes);
                uiViewer.setRepository(uiExplorer.getRepositoryName());
                uiDocumentWorkspace.setRenderedChild(VideoAudioViewer.class);
            } else {
                matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(srcPath);
                if (!matcher.find()) {
                    throw new IllegalArgumentException("The ObjectId is invalid '" + srcPath + "'");
                }
                wsName = matcher.group(1);
                srcPath = matcher.group(2);
                try {
                    uiExplorer.setSelectNode(wsName, srcPath);
                }
                catch (PathNotFoundException path) {
                    uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
                    return;
                }
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocumentWorkspace);
        }
    }
}

