/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.sidebar;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.cms.link.NodeLinkAware;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.wcm.core.NodeLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNode {
    private boolean isExpanded_;
    private String path_;
    private NodeLocation node_;
    private NodeLinkAware node;
    private String name_;
    private List<TreeNode> children_ = new ArrayList<TreeNode>();

    public TreeNode(Node node) throws RepositoryException {
        this(node, node.getPath());
    }

    private TreeNode(Node node, String path) {
        if (node instanceof NodeLinkAware) {
            this.node = (NodeLinkAware)node;
        } else {
            this.node_ = NodeLocation.getNodeLocationByNode((Node)node);
        }
        this.name_ = this.getName(node);
        this.isExpanded_ = false;
        this.path_ = path;
    }

    public boolean isExpanded() {
        return this.isExpanded_;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded_ = isExpanded;
    }

    public String getName() throws RepositoryException {
        return this.name_;
    }

    private String getName(Node node) {
        StringBuilder buffer = new StringBuilder(128);
        try {
            buffer.append(node.getName());
            int index = node.getIndex();
            if (index > 1) {
                buffer.append('[');
                buffer.append(index);
                buffer.append(']');
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return buffer.toString();
    }

    public String getPath() {
        return this.path_;
    }

    public String getNodePath() throws RepositoryException {
        return this.node != null ? this.node.getPath() : this.node_.getPath();
    }

    public Node getNode() {
        return this.node != null ? this.node : NodeLocation.getNodeByLocation((NodeLocation)this.node_);
    }

    public void setNode(Node node) {
        if (node instanceof NodeLinkAware) {
            this.node = (NodeLinkAware)node;
        } else {
            this.node_ = NodeLocation.getNodeLocationByNode((Node)node);
        }
    }

    public String getNodePath4ID() {
        String tmp = Text.escape((String)this.path_);
        return tmp.replace('%', '_');
    }

    public List<TreeNode> getChildren() {
        return this.children_;
    }

    public int getChildrenSize() {
        return this.children_.size();
    }

    public TreeNode getChildByName(String name) throws RepositoryException {
        for (TreeNode child : this.children_) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public void setChildren(List<Node> children) throws Exception {
        this.setExpanded(true);
        String prefix = this.path_.equals("/") ? "" : this.path_;
        for (Node child : children) {
            this.children_.add(new TreeNode(child, prefix + "/" + this.getName(child)));
        }
    }
}

