/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy;

import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyManager;
import org.exoplatform.ecm.webui.form.validator.ECMNameValidator;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.categories.CategoriesService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UITaxonomyForm
extends UIForm {
    private static final String FIELD_PARENT = "parentPath";
    private static final String FIELD_NAME = "taxonomyName";

    public UITaxonomyForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormInputInfo(FIELD_PARENT, FIELD_PARENT, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ECMNameValidator.class, new Object[0]));
    }

    public void setParent(String path) throws Exception {
        String rootPath = ((UITaxonomyManager)this.getAncestorOfType(UITaxonomyManager.class)).getRootNode().getPath();
        path = path.replaceFirst(rootPath, "");
        this.getUIFormInputInfo(FIELD_PARENT).setValue((Object)path);
        this.getUIStringInput(FIELD_NAME).setValue(null);
    }

    public void addTaxonomy(String parentPath, String name) throws Exception {
        UITaxonomyManager uiManager = (UITaxonomyManager)this.getAncestorOfType(UITaxonomyManager.class);
        ((CategoriesService)this.getApplicationComponent(CategoriesService.class)).addTaxonomy(parentPath, name, uiManager.getRepository().getConfiguration().getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UITaxonomyForm> {
        public void execute(Event<UITaxonomyForm> event) throws Exception {
            UITaxonomyForm uiForm = (UITaxonomyForm)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiForm.getParent();
            uiPopup.setRendered(false);
            uiPopup.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UITaxonomyForm> {
        public void execute(Event<UITaxonomyForm> event) throws Exception {
            UITaxonomyForm uiForm = (UITaxonomyForm)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            UITaxonomyManager uiManager = (UITaxonomyManager)uiForm.getAncestorOfType(UITaxonomyManager.class);
            String name = (String)uiForm.getUIStringInput(UITaxonomyForm.FIELD_NAME).getValue();
            if (name == null || name.trim().length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UITaxonomyForm.msg.name-null", null, 1));
                return;
            }
            if (!Utils.isNameValid((String)name, (String[])new String[]{"&", "$", "@", ",", ":", "]", "[", "*", "%", "!"})) {
                uiApp.addMessage(new ApplicationMessage("UITaxonomyForm.msg.name-invalid", null, 1));
                return;
            }
            if (name.length() > 30) {
                uiApp.addMessage(new ApplicationMessage("UITaxonomyForm.msg.name-too-long", null, 1));
                return;
            }
            String rootPath = uiManager.getRootNode().getPath();
            String parentPath = rootPath + (String)uiForm.getUIFormInputInfo(UITaxonomyForm.FIELD_PARENT).getValue();
            try {
                uiForm.addTaxonomy(parentPath, name);
                uiManager.update(parentPath);
            }
            catch (Exception e) {
                Object[] arg = new Object[]{name};
                uiApp.addMessage(new ApplicationMessage("UITaxonomyForm.msg.exist", arg, 1));
                return;
            }
            uiForm.reset();
            UIPopupWindow uiPopup = (UIPopupWindow)uiForm.getParent();
            uiPopup.setRendered(false);
            uiPopup.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }
}

