/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.services.organization.UserProfileEventListenerHandler;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.organization.impl.UserProfileData;
import org.exoplatform.services.organization.impl.UserProfileImpl;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserProfileDAOImpl
implements UserProfileHandler,
UserProfileEventListenerHandler {
    private static UserProfile NOT_FOUND = new UserProfileImpl();
    private static final String queryFindUserProfileByName = "from u in class org.exoplatform.services.organization.impl.UserProfileData where u.userName = ?";
    private static final String queryFindUserProfiles = "from u in class org.exoplatform.services.organization.impl.UserProfileData";
    private HibernateService service_;
    private ExoCache cache_;
    private List<UserProfileEventListener> listeners_;

    public UserProfileDAOImpl(HibernateService service, CacheService cservice) throws Exception {
        this.service_ = service;
        this.cache_ = cservice.getCacheInstance(this.getClass().getName());
        this.listeners_ = new ArrayList<UserProfileEventListener>(3);
    }

    public void addUserProfileEventListener(UserProfileEventListener listener) {
        this.listeners_.add(listener);
    }

    public void removeUserProfileEventListener(UserProfileEventListener listener) {
        this.listeners_.remove(listener);
    }

    public final UserProfile createUserProfileInstance() {
        return new UserProfileImpl();
    }

    public UserProfile createUserProfileInstance(String userName) {
        return new UserProfileImpl(userName);
    }

    public void saveUserProfile(UserProfile profile, boolean broadcast) throws Exception {
        Session session = this.service_.openSession();
        UserProfileData upd = (UserProfileData)this.service_.findOne(session, queryFindUserProfileByName, profile.getUserName());
        if (upd == null) {
            upd = new UserProfileData();
            upd.setUserProfile(profile);
            if (broadcast) {
                this.preSave(profile, true);
            }
            session.save(profile.getUserName(), (Object)upd);
            session.flush();
            this.cache_.put((Serializable)((Object)profile.getUserName()), (Object)profile);
            if (broadcast) {
                this.postSave(profile, true);
            }
        } else {
            upd.setUserProfile(profile);
            if (broadcast) {
                this.preSave(profile, false);
            }
            session.update((Object)upd);
            session.flush();
            this.cache_.put((Serializable)((Object)profile.getUserName()), (Object)profile);
            if (broadcast) {
                this.postSave(profile, false);
            }
        }
    }

    public UserProfile removeUserProfile(String userName, boolean broadcast) throws Exception {
        Session session = this.service_.openSession();
        try {
            UserProfileData upd = (UserProfileData)this.service_.findExactOne(session, queryFindUserProfileByName, userName);
            UserProfile profile = upd.getUserProfile();
            if (broadcast) {
                this.preDelete(profile);
            }
            session.delete((Object)upd);
            session.flush();
            this.cache_.remove((Serializable)((Object)userName));
            if (broadcast) {
                this.postDelete(profile);
            }
            return profile;
        }
        catch (Exception exp) {
            return null;
        }
    }

    public UserProfile findUserProfileByName(String userName) throws Exception {
        UserProfile up = (UserProfile)this.cache_.get((Serializable)((Object)userName));
        if (up != null) {
            if (NOT_FOUND == up) {
                return null;
            }
            return up;
        }
        Session session = this.service_.openSession();
        up = this.findUserProfileByName(userName, session);
        if (up != null) {
            this.cache_.put((Serializable)((Object)userName), (Object)up);
        } else {
            this.cache_.put((Serializable)((Object)userName), (Object)NOT_FOUND);
        }
        return up;
    }

    public UserProfile findUserProfileByName(String userName, Session session) throws Exception {
        UserProfileData upd = (UserProfileData)this.service_.findOne(session, queryFindUserProfileByName, userName);
        if (upd != null) {
            return upd.getUserProfile();
        }
        return null;
    }

    void removeUserProfileEntry(String userName, Session session) throws Exception {
        Object user = session.createQuery(queryFindUserProfileByName).setString(0, userName).uniqueResult();
        if (user != null) {
            session.delete(user);
            this.cache_.remove((Serializable)((Object)userName));
        }
    }

    public Collection findUserProfiles() throws Exception {
        Session session = this.service_.openSession();
        return this.service_.findAll(session, queryFindUserProfiles);
    }

    private void preSave(UserProfile profile, boolean isNew) throws Exception {
        for (UserProfileEventListener listener : this.listeners_) {
            listener.preSave(profile, isNew);
        }
    }

    private void postSave(UserProfile profile, boolean isNew) throws Exception {
        for (UserProfileEventListener listener : this.listeners_) {
            listener.postSave(profile, isNew);
        }
    }

    private void preDelete(UserProfile profile) throws Exception {
        for (UserProfileEventListener listener : this.listeners_) {
            listener.preDelete(profile);
        }
    }

    private void postDelete(UserProfile profile) throws Exception {
        for (UserProfileEventListener listener : this.listeners_) {
            listener.postDelete(profile);
        }
    }

    public List<UserProfileEventListener> getUserProfileListeners() {
        return Collections.unmodifiableList(this.listeners_);
    }
}

