/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.common.user;

import org.exoplatform.ks.common.user.CommonContact;
import org.exoplatform.ks.common.user.ContactProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;

public class BusinessProfileContactProvider
implements ContactProvider {
    private static Log log = ExoLogger.getLogger(BusinessProfileContactProvider.class);
    private OrganizationService orgService;

    public BusinessProfileContactProvider(OrganizationService orgService) {
        this.orgService = orgService;
    }

    public CommonContact getCommonContact(String userId) {
        CommonContact contact = new CommonContact();
        try {
            UserProfile profile = this.orgService.getUserProfileHandler().findUserProfileByName(userId);
            contact.setAvatarUrl(profile.getAttribute("user.other-info.avatar.url"));
            contact.setBirthday(profile.getAttribute("user.bdate"));
            contact.setGender(profile.getAttribute("user.gender"));
            contact.setJob(profile.getAttribute("user.jobtitle"));
            contact.setEmailAddress(profile.getAttribute("user.business-info.online.email"));
            contact.setCity(profile.getAttribute("user.business-info.postal.city"));
            contact.setCountry(profile.getAttribute("user.business-info.postal.country"));
            contact.setHomePhone(profile.getAttribute("user.business-info.telecom.mobile.number"));
            contact.setWorkPhone(profile.getAttribute("user.business-info.telecom.telephone.number"));
            contact.setWebSite(profile.getAttribute("user.business-info.online.uri"));
        }
        catch (Exception e) {
            log.error((Object)("Could not retrieve forum user profile for " + userId + ": "), (Throwable)e);
        }
        return contact;
    }
}

