/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.organization.injector;

import java.util.List;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationConfig;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;

public class DataPlugin
extends BaseComponentPlugin {
    private static final Log logger_ = ExoLogger.getLogger(DataPlugin.class);
    private OrganizationService organizationService;
    private OrganizationConfig config;

    public DataPlugin(OrganizationService organizationService, InitParams params) throws Exception {
        this.config = (OrganizationConfig)params.getObjectParamValues(OrganizationConfig.class).get(0);
        this.organizationService = organizationService;
    }

    public OrganizationConfig getConfig() {
        return this.config;
    }

    public void init() throws Exception {
        logger_.info((Object)"=======> Initialize the  organization data");
        this.createGroups();
        this.createMembershipTypes();
        this.createUsers();
        logger_.info((Object)"<=======");
    }

    private void createGroups() throws Exception {
        logger_.info((Object)"  Init Group Data injection");
        List groups = this.config.getGroup();
        if (groups == null || groups.isEmpty()) {
            return;
        }
        for (OrganizationConfig.Group data : groups) {
            String groupId = null;
            String parentId = data.getParentId();
            groupId = parentId == null || parentId.length() == 0 ? "/" + data.getName() : data.getParentId() + "/" + data.getName();
            if (this.organizationService.getGroupHandler().findGroupById(groupId) == null) {
                logger_.info((Object)("    Creating Group " + groupId));
                Group group = this.organizationService.getGroupHandler().createGroupInstance();
                group.setGroupName(data.getName());
                group.setDescription(data.getDescription());
                group.setLabel(data.getLabel());
                if (parentId == null || parentId.length() == 0) {
                    this.organizationService.getGroupHandler().addChild(null, group, false);
                    continue;
                }
                Group parentGroup = this.organizationService.getGroupHandler().findGroupById(parentId);
                this.organizationService.getGroupHandler().addChild(parentGroup, group, false);
                continue;
            }
            logger_.info((Object)("    Ignoring existing Group " + groupId));
        }
    }

    private void createMembershipTypes() throws Exception {
        logger_.info((Object)"  Init  MembershipType  Data ijection");
        List types = this.config.getMembershipType();
        if (types == null || types.isEmpty()) {
            return;
        }
        for (OrganizationConfig.MembershipType data : types) {
            if (this.organizationService.getMembershipTypeHandler().findMembershipType(data.getType()) == null) {
                logger_.info((Object)("    Creating MembershipType " + data.getType()));
                MembershipType type = this.organizationService.getMembershipTypeHandler().createMembershipTypeInstance();
                type.setName(data.getType());
                type.setDescription(data.getDescription());
                this.organizationService.getMembershipTypeHandler().createMembershipType(type, false);
                continue;
            }
            logger_.info((Object)("    Ignoring existing MembershipType " + data.getType()));
        }
    }

    private void createUsers() throws Exception {
        logger_.info((Object)"  Init  User  Data injection");
        List users = this.config.getUser();
        if (users == null || users.isEmpty()) {
            return;
        }
        MembershipHandler mhandler = this.organizationService.getMembershipHandler();
        for (int i = 0; i < users.size(); ++i) {
            OrganizationConfig.User data = (OrganizationConfig.User)users.get(i);
            User user = this.organizationService.getUserHandler().createUserInstance(data.getUserName());
            user.setPassword(data.getPassword());
            user.setFirstName(data.getFirstName());
            user.setLastName(data.getLastName());
            user.setEmail(data.getEmail());
            if (this.organizationService.getUserHandler().findUserByName(data.getUserName()) == null) {
                logger_.info((Object)("    Creating user " + data.getUserName()));
                this.organizationService.getUserHandler().createUser(user, false);
            } else {
                logger_.info((Object)("    Ignoring existing User " + data.getUserName()));
            }
            String groups = data.getGroups();
            if (groups == null || groups.isEmpty()) continue;
            String[] entry = groups.split(",");
            for (int j = 0; j < entry.length; ++j) {
                String[] temp = entry[j].trim().split(":");
                String membership = temp[0];
                String groupId = temp[1];
                if (mhandler.findMembershipByUserGroupAndType(data.getUserName(), groupId, membership) == null) {
                    Group group = this.organizationService.getGroupHandler().findGroupById(groupId);
                    MembershipType mt = this.organizationService.getMembershipTypeHandler().createMembershipTypeInstance();
                    mt.setName(membership);
                    mhandler.linkMembership(user, group, mt, false);
                    logger_.info((Object)("    Creating membership " + data.getUserName() + ", " + groupId + ", " + membership));
                    continue;
                }
                logger_.info((Object)("    Ignoring existing membership " + data.getUserName() + ", " + groupId + ", " + membership));
            }
        }
    }
}

