/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.content.service;

import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.content.model.ContentItem;
import org.exoplatform.content.model.ContentNode;
import org.exoplatform.content.service.ContentPageList;
import org.exoplatform.content.service.ContentPlugin;
import org.exoplatform.services.common.HttpClientImpl;
import org.exoplatform.services.rss.parser.DefaultRSSChannel;
import org.exoplatform.services.rss.parser.DefaultRSSItem;
import org.exoplatform.services.rss.parser.RSSDocument;
import org.exoplatform.services.rss.parser.RSSParser;
import org.w3c.dom.Document;

public class RSSContentPlugin
extends ContentPlugin {
    private RSSParser service_;

    public RSSContentPlugin(RSSParser service) {
        this.type = "rss";
        this.service_ = service;
    }

    public PageList loadContentMeta(ContentNode node) throws Exception {
        URL uri = new URL(node.getUrl());
        GetMethod get = null;
        HttpClientImpl httpClientService = new HttpClientImpl(uri);
        get = httpClientService.getMethod(uri.getFile());
        get.setFollowRedirects(true);
        int statusCode = httpClientService.getHttpClient().executeMethod((HttpMethod)get);
        if (statusCode != 200) {
            throw new Exception("Server response code " + statusCode);
        }
        InputStream input = get.getResponseBodyAsStream();
        DocumentBuilder docbuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = docbuilder.parse(input);
        String encode = doc.getXmlEncoding();
        if (encode == null || encode.trim().length() == 0) {
            encode = "utf-8";
        }
        RSSDocument document = this.service_.createDocument(uri, encode, DefaultRSSChannel.class, RSSItem.class);
        List list = document.getItems();
        return new ContentPageList(list);
    }

    public static class RSSItem
    extends DefaultRSSItem
    implements ContentItem {
        public void setCreator(String creator) {
            super.setCreator(creator);
        }

        public String getCreator() {
            return super.getCreator();
        }
    }
}

