/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.j2ee;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.UsernameCredential;
import org.exoplatform.services.security.j2ee.TomcatLoginModule;

public class DigestAuthenticationTomcatLoginModule
extends TomcatLoginModule {
    public boolean login() throws LoginException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"In login of ExtendedTomcatLoginModule.");
        }
        try {
            if (this.sharedState.containsKey("exo.security.identity")) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Use Identity from previous LoginModule");
                }
                this.identity = (Identity)this.sharedState.get("exo.security.identity");
            } else {
                Authenticator authenticator;
                if (!this.digestAuthenticationIsUsed()) {
                    return super.login();
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Try create identity");
                }
                if ((authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class)) == null) {
                    throw new LoginException("No Authenticator component found, check your configuration");
                }
                String userId = authenticator.validateUser(this.getCredentials());
                this.identity = authenticator.createIdentity(userId);
                this.sharedState.put("javax.security.auth.login.name", userId);
                this.subject.getPrivateCredentials().add(this.getPassword());
                this.subject.getPublicCredentials().add(this.getUsername());
            }
            return true;
        }
        catch (Throwable e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)e.getMessage(), e);
            }
            throw new LoginException(e.getMessage());
        }
    }

    private Credential[] getCredentials() throws IOException {
        String password;
        String username;
        HashMap<String, String> passwordContext;
        block9: {
            block8: {
                passwordContext = new HashMap<String, String>();
                HashSet<String> contextElements = new HashSet<String>();
                Callback[] digestCallback = new Callback[1];
                username = null;
                password = null;
                contextElements.add("cnonce");
                contextElements.add("nc");
                contextElements.add("nonce");
                contextElements.add("qop");
                contextElements.add("realmName");
                contextElements.add("md5a2");
                for (String element : contextElements) {
                    try {
                        digestCallback[0] = new TextInputCallback(element);
                        this.callbackHandler.handle(digestCallback);
                        passwordContext.put(element, ((TextInputCallback)digestCallback[0]).getText());
                    }
                    catch (UnsupportedCallbackException e) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)"Unsupported callback type.", (Throwable)e);
                    }
                }
                try {
                    Callback[] nameCallback = new Callback[]{new NameCallback("Username")};
                    this.callbackHandler.handle(nameCallback);
                    username = ((NameCallback)nameCallback[0]).getName();
                }
                catch (UnsupportedCallbackException e) {
                    if (!this.log.isErrorEnabled()) break block8;
                    this.log.error((Object)"Error on retrieving username from callback handler! ", (Throwable)e);
                }
            }
            try {
                Callback[] passwordCallback = new Callback[]{new PasswordCallback("Password", false)};
                this.callbackHandler.handle(passwordCallback);
                password = new String(((PasswordCallback)passwordCallback[0]).getPassword());
                ((PasswordCallback)passwordCallback[0]).clearPassword();
            }
            catch (UnsupportedCallbackException e) {
                if (!this.log.isErrorEnabled()) break block9;
                this.log.error((Object)"Error on retrieving password from callback handler! ", (Throwable)e);
            }
        }
        if (username == null || password == null) {
            return null;
        }
        return new Credential[]{new UsernameCredential(username), new PasswordCredential(password, passwordContext)};
    }

    private boolean digestAuthenticationIsUsed() throws IOException, UnsupportedCallbackException {
        Callback[] authCallback = new Callback[]{new TextInputCallback("authMethod")};
        this.callbackHandler.handle(authCallback);
        String authMethod = ((TextInputCallback)authCallback[0]).getText();
        return "DIGEST".equalsIgnoreCase(authMethod);
    }

    private UsernameCredential getUsername() throws IOException {
        String username;
        block2: {
            username = null;
            try {
                Callback[] nameCallback = new Callback[]{new NameCallback("Username")};
                this.callbackHandler.handle(nameCallback);
                username = ((NameCallback)nameCallback[0]).getName();
            }
            catch (UnsupportedCallbackException e) {
                if (!this.log.isErrorEnabled()) break block2;
                this.log.error((Object)"Error on retrieving username from callback handler! ", (Throwable)e);
            }
        }
        return new UsernameCredential(username);
    }

    private String getPassword() throws IOException {
        String password;
        block2: {
            password = null;
            try {
                Callback[] passwordCallback = new Callback[]{new PasswordCallback("Password", false)};
                this.callbackHandler.handle(passwordCallback);
                password = new String(((PasswordCallback)passwordCallback[0]).getPassword());
                ((PasswordCallback)passwordCallback[0]).clearPassword();
            }
            catch (UnsupportedCallbackException e) {
                if (!this.log.isErrorEnabled()) break block2;
                this.log.error((Object)"Error on retrieving password from callback handler! ", (Throwable)e);
            }
        }
        return password;
    }
}

