/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.chromattic;

import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.chromattic.spi.jcr.SessionLifeCycle;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

public abstract class AbstractIdeSessionLifeCycle
implements SessionLifeCycle {
    public Session login() throws RepositoryException {
        try {
            return this.getSessionProvider().getSession(this.getDefaultWorkspaceName(), this.getRepository());
        }
        catch (RepositoryConfigurationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Session login(String workspace) throws RepositoryException {
        try {
            return this.getSessionProvider().getSession(workspace, this.getRepository());
        }
        catch (RepositoryConfigurationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Session login(Credentials credentials, String workspace) throws RepositoryException {
        try {
            return this.getRepository().login(credentials, workspace);
        }
        catch (RepositoryConfigurationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Session login(Credentials credentials) throws RepositoryException {
        try {
            return this.getRepository().login(credentials);
        }
        catch (RepositoryConfigurationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void save(Session session) throws RepositoryException {
        session.save();
    }

    public void close(Session session) {
        session.logout();
    }

    private ManageableRepository getRepository() throws RepositoryException, RepositoryConfigurationException {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        return repositoryService.getCurrentRepository() != null ? repositoryService.getCurrentRepository() : repositoryService.getDefaultRepository();
    }

    public abstract String getDefaultWorkspaceName();

    private SessionProvider getSessionProvider() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        ThreadLocalSessionProviderService sessionProviderService = (ThreadLocalSessionProviderService)container.getComponentInstanceOfType(ThreadLocalSessionProviderService.class);
        return sessionProviderService.getSessionProvider(null);
    }
}

