/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.icepdf.core.pobjects.Catalog;
import org.icepdf.core.pobjects.CrossReference;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.PInfo;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.util.Library;

public class PTrailer
extends Dictionary {
    private long position;
    private CrossReference m_CrossReferenceTable;
    private CrossReference m_CrossReferenceStream;

    public PTrailer(Library library, Hashtable dictionary, CrossReference xrefTable, CrossReference xrefStream) {
        super(library, dictionary);
        this.m_CrossReferenceTable = xrefTable;
        this.m_CrossReferenceStream = xrefStream;
        if (this.m_CrossReferenceTable != null) {
            this.m_CrossReferenceTable.setTrailer(this);
        }
        if (this.m_CrossReferenceStream != null) {
            this.m_CrossReferenceStream.setTrailer(this);
        }
    }

    public int getNumberOfObjects() {
        return this.library.getInt(this.entries, "Size");
    }

    public long getPrev() {
        return this.library.getLong(this.entries, "Prev");
    }

    protected CrossReference getPrimaryCrossReference() {
        if (this.m_CrossReferenceTable != null) {
            return this.m_CrossReferenceTable;
        }
        this.loadXRefStmIfApplicable();
        return this.m_CrossReferenceStream;
    }

    protected CrossReference getCrossReferenceTable() {
        return this.m_CrossReferenceTable;
    }

    protected CrossReference getCrossReferenceStream() {
        return this.m_CrossReferenceStream;
    }

    public Reference getRootCatalogReference() {
        return this.library.getObjectReference(this.entries, "Root");
    }

    public Catalog getRootCatalog() {
        Object tmp = this.library.getObject(this.entries, "Root");
        if (tmp instanceof Catalog) {
            return (Catalog)this.library.getObject(this.entries, "Root");
        }
        if (tmp instanceof Hashtable) {
            return new Catalog(this.library, (Hashtable)tmp);
        }
        return null;
    }

    public Hashtable getEncrypt() {
        Object encryptParams = this.library.getObject(this.entries, "Encrypt");
        if (encryptParams instanceof Hashtable) {
            return (Hashtable)encryptParams;
        }
        return null;
    }

    public PInfo getInfo() {
        Object info = this.library.getObject(this.entries, "Info");
        if (info instanceof Hashtable) {
            return new PInfo(this.library.getSecurityManager(), (Hashtable)info);
        }
        return null;
    }

    public Vector getID() {
        return (Vector)this.library.getObject(this.entries, "ID");
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long pos) {
        this.position = pos;
    }

    protected void addNextTrailer(PTrailer nextTrailer) {
        nextTrailer.getPrimaryCrossReference().addToEndOfChainOfPreviousXRefs(this.getPrimaryCrossReference());
        Hashtable nextDictionary = nextTrailer.getDictionary();
        Hashtable currDictionary = this.getDictionary();
        Enumeration currKeys = currDictionary.keys();
        while (currKeys.hasMoreElements()) {
            Object currKey = currKeys.nextElement();
            if (nextDictionary.containsKey(currKey)) continue;
            Object currValue = currDictionary.get(currKey);
            nextDictionary.put(currKey, currValue);
        }
    }

    protected void addPreviousTrailer(PTrailer previousTrailer) {
        this.getPrimaryCrossReference().addToEndOfChainOfPreviousXRefs(previousTrailer.getPrimaryCrossReference());
        Hashtable currDictionary = this.getDictionary();
        Hashtable prevDictionary = previousTrailer.getDictionary();
        Enumeration prevKeys = prevDictionary.keys();
        while (prevKeys.hasMoreElements()) {
            Object prevKey = prevKeys.nextElement();
            if (currDictionary.containsKey(prevKey)) continue;
            Object prevValue = prevDictionary.get(prevKey);
            currDictionary.put(prevKey, prevValue);
        }
    }

    protected void onDemandLoadAndSetupPreviousTrailer() {
        PTrailer prevTrailer;
        long position = this.getPrev();
        if (position > 0L && (prevTrailer = this.library.getTrailerByFilePosition(position)) != null) {
            this.addPreviousTrailer(prevTrailer);
        }
    }

    protected void loadXRefStmIfApplicable() {
        PTrailer trailer;
        long xrefStreamPosition;
        if (this.m_CrossReferenceStream == null && (xrefStreamPosition = this.library.getLong(this.entries, "XRefStm")) > 0L && (trailer = this.library.getTrailerByFilePosition(xrefStreamPosition)) != null) {
            this.m_CrossReferenceStream = trailer.getCrossReferenceStream();
        }
    }

    public Hashtable getDictionary() {
        return this.entries;
    }

    public String toString() {
        return "PTRAILER= " + this.entries.toString() + " xref table=" + this.m_CrossReferenceTable + "  xref stream=" + this.m_CrossReferenceStream;
    }
}

