/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.code;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.box.AbstractBoxMacro;
import org.xwiki.rendering.macro.code.CodeMacroParameters;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.parser.HighlightParser;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.transformation.MacroTransformationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="code")
public class CodeMacro
extends AbstractBoxMacro<CodeMacroParameters> {
    @Requirement
    private ComponentManager componentManager;
    private static final String DESCRIPTION = "Highlights code snippets of various programming languages";
    private static final String LANGUAGE_NONE = "none";
    private static final String CONTENT_DESCRIPTION = "the content to highlight";
    @Requirement(value="plain/1.0")
    private Parser plainTextParser;

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    public CodeMacro() {
        super("Code", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION), CodeMacroParameters.class);
        this.setDefaultCategory("Formatting");
    }

    protected List<Block> parseContent(CodeMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        block3: {
            if (!LANGUAGE_NONE.equalsIgnoreCase(parameters.getLanguage())) {
                try {
                    List<Block> result = this.highlight(parameters, content);
                    return result;
                }
                catch (Exception e) {
                    if (!this.getLogger().isDebugEnabled()) break block3;
                    this.getLogger().debug("Can not highlight code", (Throwable)e);
                }
            }
        }
        return this.parsePlainTextContent(content);
    }

    protected List<Block> highlight(CodeMacroParameters parameters, String content) throws ParseException, ComponentLookupException {
        HighlightParser parser;
        block4: {
            parser = null;
            if (parameters.getLanguage() != null) {
                try {
                    parser = (HighlightParser)this.getComponentManager().lookup(HighlightParser.class, parameters.getLanguage());
                    return parser.highlight(parameters.getLanguage(), (Reader)new StringReader(content));
                }
                catch (ComponentLookupException e) {
                    if (!this.getLogger().isDebugEnabled()) break block4;
                    this.getLogger().debug("Can't find specific highlighting parser for language [" + parameters.getLanguage() + "]", (Throwable)e);
                }
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Trying the default highlighting parser");
        }
        parser = (HighlightParser)this.getComponentManager().lookup(HighlightParser.class, "default");
        return parser.highlight(parameters.getLanguage(), (Reader)new StringReader(content));
    }

    private List<Block> parsePlainTextContent(String content) {
        List result;
        if (StringUtils.isEmpty((String)content)) {
            result = Collections.emptyList();
        } else {
            try {
                result = ((Block)this.plainTextParser.parse((Reader)new StringReader(content)).getChildren().get(0)).getChildren();
            }
            catch (Exception e) {
                result = new ArrayList<Block>();
                content = content.replaceAll("\n", "<br/>");
                result.add(new GroupBlock(Arrays.asList(new WordBlock(content)), new LinkedHashMap()));
            }
        }
        return result;
    }
}

