/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.parser.js.StringLiteral;
import com.google.caja.util.CajaTestCase;
import java.util.Random;

public class StringLiteralTest
extends CajaTestCase {
    public final void testUnquotedValue() {
        StringLiteralTest.assertEquals((String)"", (String)StringLiteral.getUnquotedValueOf(""));
        StringLiteralTest.assertEquals((String)"foo", (String)StringLiteral.getUnquotedValueOf("foo"));
        StringLiteralTest.assertEquals((String)"foo\\bar", (String)StringLiteral.getUnquotedValueOf("foo\\bar"));
        StringLiteralTest.assertEquals((String)"", (String)StringLiteral.getUnquotedValueOf("''"));
        StringLiteralTest.assertEquals((String)"\"\"", (String)StringLiteral.getUnquotedValueOf("'\"\"'"));
        StringLiteralTest.assertEquals((String)"\"\"", (String)StringLiteral.getUnquotedValueOf("'\\\"\\\"'"));
        StringLiteralTest.assertEquals((String)"foo\bar", (String)StringLiteral.getUnquotedValueOf("'foo\\bar'"));
        StringLiteralTest.assertEquals((String)"foo\nbar", (String)StringLiteral.getUnquotedValueOf("'foo\\nbar'"));
        StringLiteralTest.assertEquals((String)"foo\\bar\\baz", (String)StringLiteral.getUnquotedValueOf("'foo\\\\bar\\\\baz'"));
        StringLiteralTest.assertEquals((String)"foo bar", (String)StringLiteral.getUnquotedValueOf("'foo\\u0020bar'"));
        StringLiteralTest.assertEquals((String)"foo bar", (String)StringLiteral.getUnquotedValueOf("'foo\\040bar'"));
        StringLiteralTest.assertEquals((String)"foo bar", (String)StringLiteral.getUnquotedValueOf("'foo\\40bar'"));
        StringLiteralTest.assertEquals((String)"foo\u0000bar", (String)StringLiteral.getUnquotedValueOf("'foo\\0bar'"));
        StringLiteralTest.assertEquals((String)"foo\u0000bar", (String)StringLiteral.getUnquotedValueOf("'foo\\00bar'"));
        StringLiteralTest.assertEquals((String)"foo\u00000bar", (String)StringLiteral.getUnquotedValueOf("'foo\\0000bar'"));
        StringLiteralTest.assertEquals((String)"foo8bar", (String)StringLiteral.getUnquotedValueOf("'foo\\8bar'"));
        StringLiteralTest.assertEquals((String)"\n3", (String)StringLiteral.getUnquotedValueOf("'\\0123'"));
        StringLiteralTest.assertEquals((String)"\u01234", (String)StringLiteral.getUnquotedValueOf("'\\u01234'"));
        StringLiteralTest.assertEquals((String)"\u0123a", (String)StringLiteral.getUnquotedValueOf("'\\u0123a'"));
        StringLiteralTest.assertEquals((String)"\u0123A", (String)StringLiteral.getUnquotedValueOf("'\\u0123A'"));
        StringLiteralTest.assertEquals((String)"\u0123f", (String)StringLiteral.getUnquotedValueOf("'\\u0123f'"));
        StringLiteralTest.assertEquals((String)"\u0123F", (String)StringLiteral.getUnquotedValueOf("'\\u0123F'"));
        StringLiteralTest.assertEquals((String)"'", (String)StringLiteral.getUnquotedValueOf("'\\u0027'"));
        StringLiteralTest.assertEquals((String)"\"", (String)StringLiteral.getUnquotedValueOf("'\\u0022'"));
        StringLiteralTest.assertEquals((String)"'", (String)StringLiteral.getUnquotedValueOf("\"\\u0027\""));
        StringLiteralTest.assertEquals((String)"\"", (String)StringLiteral.getUnquotedValueOf("\"\\u0022\""));
        StringLiteralTest.assertEquals((String)"@", (String)StringLiteral.getUnquotedValueOf("'\\x40'"));
        StringLiteralTest.assertEquals((String)"x4", (String)StringLiteral.getUnquotedValueOf("'\\x4'"));
    }

    public final void testQuoteValue() {
        StringLiteralTest.assertEquals((String)"''", (String)StringLiteral.toQuotedValue(""));
        StringLiteralTest.assertEquals((String)"'foo'", (String)StringLiteral.toQuotedValue("foo"));
        StringLiteralTest.assertEquals((String)"'foo\\bar'", (String)StringLiteral.toQuotedValue("foo\bar"));
        StringLiteralTest.assertEquals((String)"'foo\\nbar'", (String)StringLiteral.toQuotedValue("foo\nbar"));
        StringLiteralTest.assertEquals((String)"'foo\\\\bar\\\\baz'", (String)StringLiteral.toQuotedValue("foo\\bar\\baz"));
        StringLiteralTest.assertEquals((String)"'foo bar'", (String)StringLiteral.toQuotedValue("foo bar"));
        StringLiteralTest.assertEquals((String)"'foo\\x00bar'", (String)StringLiteral.toQuotedValue("foo\u0000bar"));
        StringLiteralTest.assertEquals((String)"'foo\\x7fbar'", (String)StringLiteral.toQuotedValue("foo\u007fbar"));
        StringLiteralTest.assertEquals((String)"'foo\\uabcdbar'", (String)StringLiteral.toQuotedValue("foo\uabcdbar"));
        StringLiteralTest.assertEquals((String)"'\\'foo\\''", (String)StringLiteral.toQuotedValue("'foo'"));
        StringLiteralTest.assertEquals((String)"'\\\"foo\\\"'", (String)StringLiteral.toQuotedValue("\"foo\""));
        StringLiteralTest.assertEquals((String)"'\\\"foo\\\\\\\"'", (String)StringLiteral.toQuotedValue("\"foo\\\""));
    }

    public final void testQuotingAndUnquotingAreComplements() {
        Random rnd = new Random(SEED);
        int i = 2000;
        while (--i >= 0) {
            String s = StringLiteralTest.makeRandomString(rnd);
            StringLiteralTest.assertEquals((String)s, (String)StringLiteral.getUnquotedValueOf(StringLiteral.toQuotedValue(s)));
        }
    }

    public final void testRandomStringsParseable() {
        Random rnd = new Random(SEED);
        int i = 2000;
        while (--i >= 0) {
            String literal = StringLiteralTest.makeRandomQuotedString(rnd);
            String value = StringLiteral.getUnquotedValueOf(literal);
            String requoted = StringLiteral.toQuotedValue(value);
            StringLiteralTest.assertEquals((String)value, (String)StringLiteral.getUnquotedValueOf(requoted));
            char delimiter = requoted.charAt(0);
            StringLiteralTest.assertTrue((requoted.length() >= 2 ? 1 : 0) != 0);
            StringLiteralTest.assertEquals((char)delimiter, (char)requoted.charAt(requoted.length() - 1));
            if ("'\"".indexOf(delimiter) < 0) {
                StringLiteralTest.fail((String)("delimiter 0x" + Integer.toString(delimiter, 16)));
            }
            int end = requoted.length() - 1;
            for (int ci = 1; ci < end; ++ci) {
                char ch = requoted.charAt(ci);
                if (ch == '\\') {
                    StringLiteralTest.assertTrue((String)"close delimiter is escaped", (++ci < end - 1 ? 1 : 0) != 0);
                }
                StringLiteralTest.assertTrue((String)"delimiter appears unescaped", (ch != delimiter ? 1 : 0) != 0);
                if ("\r\n\u2028\u2029".indexOf(ch) < 0) continue;
                StringLiteralTest.fail((String)("newline 0x" + Integer.toString(ch, 16)));
            }
        }
    }

    private static String makeRandomString(Random rnd) {
        int len = (int)Math.min(Math.abs(rnd.nextGaussian() * 128.0), 1024.0);
        StringBuilder sb = new StringBuilder(len);
        while (--len >= 0) {
            sb.appendCodePoint(StringLiteralTest.randomCodePoint(rnd));
        }
        return sb.toString();
    }

    private static String makeRandomQuotedString(Random rnd) {
        int len = (int)Math.min(Math.abs(rnd.nextGaussian() * 128.0), 1024.0);
        char delim = rnd.nextInt(2) == 0 ? (char)'\"' : '\'';
        StringBuilder sb = new StringBuilder(len);
        sb.append((int)delim);
        while (--len >= 0) {
            boolean escape;
            char ch = StringLiteralTest.randomChar(rnd);
            String sequence = null;
            switch (ch) {
                case '\u2028': {
                    escape = true;
                    sequence = "\\u2028";
                    break;
                }
                case '\u2029': {
                    escape = true;
                    sequence = "\\u2029";
                    break;
                }
                case '\r': {
                    escape = true;
                    sequence = "\\r";
                    break;
                }
                case '\n': {
                    escape = true;
                    sequence = "\\n";
                    break;
                }
                default: {
                    boolean bl = escape = ch == '\u0000' || ch == delim;
                }
            }
            if (!escape) {
                int escapeType = rnd.nextInt(16);
                switch (escapeType) {
                    case 0: {
                        if (ch < '\u00ff') {
                            sequence = StringLiteralTest.escapeSequence(ch, 8, rnd.nextInt(3));
                            break;
                        }
                        sequence = "u" + StringLiteralTest.escapeSequence(ch, 16, 4);
                        break;
                    }
                    case 1: {
                        if (ch < '\u0100') {
                            sequence = StringLiteralTest.escapeSequence(ch, 16, 2);
                            break;
                        }
                        sequence = "u" + StringLiteralTest.escapeSequence(ch, 16, 4);
                        break;
                    }
                    case 2: {
                        sequence = "u" + StringLiteralTest.escapeSequence(ch, 16, 4);
                    }
                }
                boolean bl = escape = sequence != null;
            }
            if (escape) {
                sb.append('\\');
            }
            if (sequence == null) {
                sb.append(ch);
                continue;
            }
            sb.append(sequence);
        }
        sb.append((int)delim);
        return sb.toString();
    }

    private static int randomCodePoint(Random rnd) {
        int mag;
        switch (rnd.nextInt(4)) {
            default: {
                mag = 256;
                break;
            }
            case 2: {
                mag = 65536;
                break;
            }
            case 3: {
                mag = 0x10FFFF;
            }
        }
        int codePoint = rnd.nextInt(mag);
        if (55296 <= codePoint && codePoint <= 57343) {
            codePoint &= 0xFF;
        }
        return codePoint;
    }

    private static char randomChar(Random rnd) {
        char ch = (char)rnd.nextInt(65536);
        if ('\ud800' <= ch && ch <= '\udfff') {
            ch = (char)(ch & 0xFF);
        }
        return ch;
    }

    private static String escapeSequence(char ch, int radix, int nDigits) {
        StringBuilder sb = new StringBuilder(nDigits);
        sb.append(Integer.toString(ch, radix));
        while (sb.length() < nDigits) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }
}

