/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.conversationstate;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.exoplatform.ide.conversationstate.IdeUser;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

@Path(value="/ide/conversation-state")
public class RestConversationState {
    private final Log log = ExoLogger.getLogger((String)"ide.RestConversationState");

    @POST
    @Path(value="/whoami")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public IdeUser whoami() {
        ConversationState curentState = ConversationState.getCurrent();
        if (curentState != null) {
            Identity identity = curentState.getIdentity();
            IdeUser user = new IdeUser(identity.getUserId(), identity.getGroups(), identity.getRoles());
            if (this.log.isDebugEnabled()) {
                this.log.info((Object)("Getting user identity: " + identity.getUserId()));
            }
            return user;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
    }
}

