/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.gwt.wysiwyg.client.syntax;

import org.xwiki.gwt.user.client.ui.rta.RichTextArea;

/**
 * A syntax validator ensures that the XHTML code generated by the editor can be converted without loss of information
 * to the underlying syntax. it does this by restricting the user actions (UI features) when they can generate XHTML
 * constructs that don't have a correspondent in the underlying syntax.
 * 
 * @version $Id: SyntaxValidator.java 26786 2010-02-07 16:46:17Z mflorea $
 */
public interface SyntaxValidator
{
    /**
     * Adds a new validation rule to the list of rules this syntax validator obeys.
     * 
     * @param rule The validation rule to be added.
     */
    void addValidationRule(ValidationRule rule);

    /**
     * Verifies if a specific feature of the editor should be enabled, considering the current list of validation rules
     * and the current state of the given text area.
     * 
     * @param feature The feature to be tested.
     * @param textArea The text area whose current state should be considered.
     * @return true if there's no rule that disables the specified feature.
     */
    boolean isValid(String feature, RichTextArea textArea);

    /**
     * Removes the specified rule from the list of validation rules this syntax validator obeys.
     * 
     * @param rule The validation rule to be removed.
     */
    void removeValidationRule(ValidationRule rule);

    /**
     * @return A string identifier for the syntax characterized by the underlying validation rules.
     */
    String getSyntax();
}
