/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.xcmis.sp;

import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.ecms.xcmis.sp.BaseObjectData;
import org.exoplatform.ecms.xcmis.sp.DocumentDataImpl;
import org.exoplatform.ecms.xcmis.sp.JcrNodeEntry;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.DocumentData;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.NameConstraintViolationException;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.PolicyData;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.model.AccessControlEntry;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.PropertyDefinition;
import org.xcmis.spi.model.Updatability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PWC
extends DocumentDataImpl {
    private DocumentDataImpl document;

    public PWC(JcrNodeEntry jcrNodeEntry) {
        super(jcrNodeEntry);
    }

    public PWC(JcrNodeEntry jcrEntry, DocumentDataImpl document) {
        super(jcrEntry);
        this.document = document;
    }

    @Override
    public void cancelCheckout() throws StorageException {
        DocumentDataImpl latestVersion = this.getLatestVersion();
        JcrNodeEntry latestEntry = latestVersion.getNodeEntry();
        latestEntry.setValue("cmis:isLatestVersion", true);
        latestEntry.setValue("cmis:isVersionSeriesCheckedOut", false);
        latestEntry.setValue("cmis:versionSeriesCheckedOutId", (Value)null);
        latestEntry.setValue("cmis:versionSeriesCheckedOutBy", (Value)null);
        try {
            Node node = this.entry.getNode();
            Session session = node.getSession();
            node.getParent().remove();
            session.save();
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable cancel checkout of ocument. " + re.getMessage(), (Throwable)re);
        }
    }

    @Override
    public DocumentData checkin(boolean major, String checkinComment, Map<String, Property<?>> properties, ContentStream content, List<AccessControlEntry> acl, Collection<PolicyData> policies) throws NameConstraintViolationException, StorageException {
        try {
            DocumentDataImpl latestVersion = this.getLatestVersion();
            JcrNodeEntry latestEntry = latestVersion.getNodeEntry();
            Node latestNode = latestEntry.getNode();
            Session session = latestNode.getSession();
            latestNode.checkin();
            latestNode.checkout();
            latestEntry.setValue("cmis:isLatestVersion", true);
            latestEntry.setValue("cmis:isVersionSeriesCheckedOut", false);
            latestEntry.setValue("cmis:versionSeriesCheckedOutId", (Value)null);
            latestEntry.setValue("cmis:versionSeriesCheckedOutBy", (Value)null);
            String[] split = latestEntry.getString("cmis:objectId").split("_");
            String newId = split[0] + "_" + (Integer.parseInt(split[1]) + 1);
            latestEntry.setValue("cmis:objectId", newId);
            String userId = session.getUserID();
            latestEntry.setValue("cmis:createdBy", userId);
            latestEntry.setValue("cmis:lastModifiedBy", userId);
            Calendar cal = Calendar.getInstance();
            latestEntry.setValue("cmis:creationDate", cal);
            latestEntry.setValue("cmis:lastModificationDate", cal);
            latestEntry.setValue("cmis:isMajorVersion", major);
            if (checkinComment != null) {
                latestEntry.setValue("cmis:checkinComment", checkinComment);
            }
            for (PropertyDefinition propertyDefinition : this.getTypeDefinition().getPropertyDefinitions()) {
                Updatability updatability = propertyDefinition.getUpdatability();
                String propertyId = propertyDefinition.getId();
                if (updatability == Updatability.READWRITE) {
                    if (properties != null && properties.containsKey(propertyId)) {
                        latestEntry.setProperty(properties.get(propertyId));
                        continue;
                    }
                    latestEntry.setProperty(this.getProperty(propertyId));
                    continue;
                }
                if (updatability != Updatability.WHENCHECKEDOUT || properties == null || !properties.containsKey(propertyId)) continue;
                latestEntry.setProperty(properties.get(propertyId));
            }
            try {
                if (content != null) {
                    latestEntry.setContentStream(content);
                } else if (this.getContentStream() != null) {
                    latestEntry.setContentStream(this.getContentStream());
                }
            }
            catch (IOException ioe) {
                throw new CmisRuntimeException("Unable copy content for new document. " + ioe.getMessage(), (Throwable)ioe);
            }
            if (acl != null && acl.size() > 0) {
                latestEntry.setACL(acl);
            }
            if (policies != null && policies.size() > 0) {
                for (PolicyData policy : policies) {
                    latestEntry.applyPolicy(((BaseObjectData)policy).getNodeEntry());
                }
            }
            Node node = this.entry.getNode();
            node.getParent().remove();
            session.save();
            try {
                JcrNodeEntry fromNode = this.entry.storage.fromNode(latestVersion.entry.node);
                latestVersion = new DocumentDataImpl(fromNode);
            }
            catch (ObjectNotFoundException e) {
                throw new StorageException("Can't recreate the latest document object from node", (Throwable)e);
            }
            return latestVersion;
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable checkin Document. " + re.getMessage(), (Throwable)re);
        }
    }

    @Override
    public void delete() throws StorageException {
        this.cancelCheckout();
    }

    @Override
    public FolderData getParent() throws ConstraintException {
        return this.getLatestVersion().getParent();
    }

    @Override
    public Collection<FolderData> getParents() {
        return this.getLatestVersion().getParents();
    }

    @Override
    public boolean isPWC() {
        return true;
    }

    private DocumentDataImpl getLatestVersion() {
        if (this.document == null) {
            try {
                String latestVersion = this.entry.getString("xcmis:latestVersionId");
                this.document = new DocumentDataImpl(this.entry.storage.getEntry(latestVersion));
            }
            catch (ObjectNotFoundException e) {
                throw new CmisRuntimeException("Unable get latest version of document. " + e.getMessage(), (Throwable)e);
            }
        }
        return this.document;
    }
}

