/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.model.EntityType;

public class EntityReference
implements Serializable,
Cloneable,
Comparable<EntityReference> {
    private static final long serialVersionUID = 2L;
    private String name;
    private EntityReference parent;
    private EntityType type;
    private Map<String, Serializable> parameters;

    public EntityReference(EntityReference reference) {
        this(reference, reference.parent);
    }

    public EntityReference(EntityReference reference, EntityReference parent) {
        this(reference.name, reference.type, parent, reference.parameters);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected EntityReference(EntityReference reference, EntityReference oldReference, EntityReference newReference) {
        if (reference == null) {
            throw new IllegalArgumentException("Cloned reference must not be null");
        }
        this.setName(reference.name);
        this.setType(reference.type);
        this.setParameters(reference.parameters);
        if (reference.parent == null) {
            if (oldReference != null) throw new IllegalArgumentException("The old reference [" + oldReference + "] does not belong to the parents chain of the reference [" + reference + "]");
            this.setParent(newReference);
            return;
        } else if (reference.parent.equals(oldReference)) {
            this.setParent(newReference);
            return;
        } else {
            this.setParent(new EntityReference(reference.parent, oldReference, newReference));
        }
    }

    public EntityReference(String name, EntityType type) {
        this(name, type, null, null);
    }

    public EntityReference(String name, EntityType type, EntityReference parent) {
        this.setName(name);
        this.setType(type);
        this.setParent(parent);
    }

    protected EntityReference(String name, EntityType type, EntityReference parent, Map<String, Serializable> parameters) {
        this.setName(name);
        this.setType(type);
        this.setParent(parent);
        this.setParameters(parameters);
    }

    protected void setName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("An Entity Reference name cannot be null or empty");
        }
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    protected void setParent(EntityReference parent) {
        this.parent = parent;
    }

    public final EntityReference getParent() {
        return this.parent;
    }

    protected void setType(EntityType type) {
        if (type == null) {
            throw new IllegalArgumentException("An Entity Reference type cannot be null");
        }
        this.type = type;
    }

    public final EntityType getType() {
        return this.type;
    }

    protected void setParameters(Map<String, Serializable> parameters) {
        if (parameters != null) {
            for (Map.Entry<String, Serializable> entry : parameters.entrySet()) {
                this.setParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void setParameter(String name, Serializable value) {
        if (value != null) {
            if (this.parameters == null) {
                this.parameters = new TreeMap<String, Serializable>();
            }
            this.parameters.put(name, value);
        } else if (this.parameters != null) {
            this.parameters.remove(name);
            if (this.parameters.size() == 0) {
                this.parameters = null;
            }
        }
    }

    protected final <T> T getParameter(String name) {
        return (T)(this.parameters == null ? null : this.parameters.get(name));
    }

    public EntityReference getRoot() {
        EntityReference reference = this;
        while (reference.getParent() != null) {
            reference = reference.getParent();
        }
        return reference;
    }

    public List<EntityReference> getReversedReferenceChain() {
        LinkedList<EntityReference> referenceList = new LinkedList<EntityReference>();
        EntityReference reference = this;
        do {
            referenceList.push(reference);
        } while ((reference = reference.getParent()) != null);
        return referenceList;
    }

    public EntityReference extractReference(EntityType type) {
        EntityReference reference;
        for (reference = this; reference != null && reference.getType() != type; reference = reference.getParent()) {
        }
        return reference;
    }

    public EntityReference replaceParent(EntityReference oldParent, EntityReference newParent) {
        return new EntityReference(this, oldParent, newParent);
    }

    public EntityReference appendParent(EntityReference newParent) {
        return this.replaceParent(null, newParent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("name = [").append(this.getName()).append("], type = [").append((Object)this.getType()).append("], parent = [").append(this.getParent()).append(']');
        if (this.parameters != null) {
            sb.append(" parameters = {");
            boolean first = true;
            for (Map.Entry<String, Serializable> entry : this.parameters.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(entry.getKey()).append(" = [").append(entry.getValue().toString()).append(']');
            }
            sb.append('}');
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntityReference)) {
            return false;
        }
        EntityReference ref = (EntityReference)obj;
        return this.name.equals(ref.name) && this.type.equals((Object)ref.type) && (this.parent == null ? ref.parent == null : this.parent.equals(ref.parent)) && (this.parameters == null ? ref.parameters == null : ((Object)this.parameters).equals(ref.parameters));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(EntityReference reference) {
        if (reference == null) {
            throw new NullPointerException("Provided reference should not be null");
        }
        if (reference == this) {
            return 0;
        }
        int cmp = this.compareParent(reference);
        if (cmp != 0) {
            return cmp;
        }
        if (!this.type.equals((Object)reference.type)) {
            return this.type.compareTo(reference.type);
        }
        if (!this.name.equals(reference.name)) {
            return this.name.compareTo(reference.name);
        }
        return this.compareParameters(reference);
    }

    private int compareParent(EntityReference reference) {
        if (this.parent != null) {
            if (reference.parent == null) {
                return 1;
            }
            return this.parent.compareTo(reference.parent);
        }
        return reference.parent == null ? 0 : -1;
    }

    private int compareParameters(EntityReference reference) {
        if (this.parameters != null && reference.parameters == null) {
            return 1;
        }
        if (this.parameters != null) {
            for (Map.Entry<String, Serializable> entry : this.parameters.entrySet()) {
                Serializable obj = reference.parameters.get(entry.getKey());
                Serializable myobj = entry.getValue();
                if (myobj == null || !(myobj instanceof Comparable)) continue;
                if (obj == null) {
                    return 1;
                }
                return ((Comparable)((Object)myobj)).compareTo(obj);
            }
        }
        return reference.parameters == null ? 0 : -1;
    }
}

