/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import org.hsqldb.jdbc.JDBCDriver;
import org.hsqldb.jdbc.Util;

public class JDBCDataSource
implements Serializable,
Referenceable,
DataSource,
CommonDataSource,
Wrapper {
    private int loginTimeout = 0;
    private transient PrintWriter logWriter;
    private String password = "";
    private String user = "";
    private String database = "";

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        Properties properties = new Properties();
        if (string != null) {
            properties.put("user", string);
        }
        if (string2 != null) {
            properties.put("password", string2);
        }
        return JDBCDriver.getConnection(this.database, properties);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw Util.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    public String getDatabase() {
        return this.database;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public Reference getReference() throws NamingException {
        String string = "org.hsqldb.jdbc.JDBCDataSourceFactory";
        Reference reference = new Reference(this.getClass().getName(), string, null);
        reference.add(new StringRefAddr("database", this.getDatabase()));
        reference.add(new StringRefAddr("user", this.getUser()));
        reference.add(new StringRefAddr("password", this.password));
        return reference;
    }

    public String getUser() {
        return this.user;
    }

    public void setDatabase(String string) {
        this.database = string;
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this.loginTimeout = 0;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.logWriter = printWriter;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setUser(String string) {
        this.user = string;
    }
}

