/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.deployment;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.services.deployment.DeploymentPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.javascript.XJavascriptService;
import org.exoplatform.services.wcm.skin.XSkinService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

public class WCMContentInitializerService
implements Startable {
    private List<DeploymentPlugin> listDeploymentPlugin = new ArrayList<DeploymentPlugin>();
    private RepositoryService repositoryService;
    private Log log = ExoLogger.getLogger(this.getClass());

    public WCMContentInitializerService(UserPortalConfigService userPortalConfigService) {
        this.repositoryService = WCMCoreUtils.getService(RepositoryService.class);
    }

    public void addPlugin(DeploymentPlugin deploymentPlugin) {
        this.listDeploymentPlugin.add(deploymentPlugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        SessionProvider sessionProvider = null;
        try {
            sessionProvider = SessionProvider.createSystemProvider();
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            Session session = sessionProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
            Node serviceFolder = session.getRootNode().getNode("exo:services");
            Node contentInitializerService = null;
            contentInitializerService = serviceFolder.hasNode("WCMContentInitializerService") ? serviceFolder.getNode("WCMContentInitializerService") : serviceFolder.addNode("WCMContentInitializerService", "nt:unstructured");
            if (!contentInitializerService.hasNode("WCMContentInitializerServiceLog")) {
                Date date = new Date();
                StringBuffer logData = new StringBuffer();
                for (DeploymentPlugin deploymentPlugin : this.listDeploymentPlugin) {
                    try {
                        deploymentPlugin.deploy(sessionProvider);
                        logData.append("deploy " + deploymentPlugin.getName() + " deployment plugin succesfully at " + date.toString() + "\n");
                    }
                    catch (Exception e) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)("deploy " + deploymentPlugin.getName() + " deployment plugin failure at " + date.toString() + " by " + e + "\n"));
                        }
                        logData.append("deploy " + deploymentPlugin.getName() + " deployment plugin failure at " + date.toString() + " by " + e + "\n");
                    }
                }
                Node contentInitializerServiceLog = contentInitializerService.addNode("WCMContentInitializerServiceLog", "nt:file");
                Node contentInitializerServiceLogContent = contentInitializerServiceLog.addNode("jcr:content", "nt:resource");
                contentInitializerServiceLogContent.setProperty("jcr:encoding", "UTF-8");
                contentInitializerServiceLogContent.setProperty("jcr:mimeType", "text/plain");
                contentInitializerServiceLogContent.setProperty("jcr:data", logData.toString());
                contentInitializerServiceLogContent.setProperty("jcr:lastModified", date.getTime());
                session.save();
                XJavascriptService jsService = WCMCoreUtils.getService(XJavascriptService.class);
                XSkinService xSkinService = WCMCoreUtils.getService(XSkinService.class);
                xSkinService.start();
                jsService.start();
            }
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Error when start WCMContentInitializerService: ", (Throwable)e);
            }
        }
        finally {
            sessionProvider.close();
        }
    }

    public void stop() {
    }
}

