/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.core;

import org.reflext.api.AccessScope;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.FieldInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.annotation.AnnotationType;
import org.reflext.core.AnnotatedDelegate;
import org.reflext.core.ReflectedObject;
import org.reflext.core.TypeResolverImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldInfoImpl<T, M, A, P, F>
extends ReflectedObject<T, M, A, P, F>
implements FieldInfo {
    private final ClassTypeInfo owner;
    private final F field;
    private TypeInfo type;
    private final String name;
    private final AccessScope access;
    private final boolean _final;
    private final boolean _static;
    private AnnotatedDelegate<T, M, A, P, F, F> annotatedDelegate;

    public FieldInfoImpl(ClassTypeInfo owner, TypeResolverImpl<T, M, A, P, F> domain, F field) {
        super(domain);
        this.owner = owner;
        this.field = field;
        this.type = null;
        this.name = domain.fieldModel.getName(field);
        this.access = domain.fieldModel.getAccess(field);
        this._final = domain.fieldModel.isFinal(field);
        this._static = domain.fieldModel.isStatic(field);
        this.annotatedDelegate = null;
    }

    public ClassTypeInfo getOwner() {
        return this.owner;
    }

    public TypeInfo getType() {
        if (this.type == null) {
            Object ft = this.domain.fieldModel.getType(this.field);
            this.type = this.domain.resolve(ft);
        }
        return this.type;
    }

    public <AT> AT getDeclaredAnnotation(AnnotationType<AT, ?> annotationType) {
        if (this.annotatedDelegate == null) {
            this.annotatedDelegate = new AnnotatedDelegate(this.domain, this.domain.fieldAnnotationModel, this.field);
        }
        return this.annotatedDelegate.getDeclaredAnnotation(this.field, annotationType);
    }

    public String getName() {
        return this.name;
    }

    public AccessScope getAccess() {
        return this.access;
    }

    public boolean isStatic() {
        return this._static;
    }

    public boolean isFinal() {
        return this._final;
    }
}

