/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.groovy.codeassistant.extractors;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.exoplatform.ide.groovy.codeassistant.bean.ShortTypeInfo;
import org.exoplatform.ide.groovy.codeassistant.bean.TypeInfo;
import org.exoplatform.ide.groovy.codeassistant.extractors.TypeInfoExtractor;
import org.exoplatform.ide.groovy.util.DependentResources;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.resource.UnifiedNodeReference;
import org.exoplatform.services.jcr.ext.script.groovy.JcrGroovyClassLoaderProvider;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.rest.ext.groovy.ExtendedGroovyClassLoader;
import org.exoplatform.services.rest.ext.groovy.GroovyClassLoaderProvider;
import org.exoplatform.services.rest.ext.groovy.SourceFile;
import org.exoplatform.services.rest.ext.groovy.SourceFolder;

public class GroovyClassNamesExtractor {
    private final RepositoryService repositoryService;
    private final ThreadLocalSessionProviderService sessionProviderService;
    private GroovyClassLoaderProvider classLoaderProvider;
    private ExtendedGroovyClassLoader classLoader;

    public GroovyClassNamesExtractor(RepositoryService repositoryService, ThreadLocalSessionProviderService sessionProviderService) {
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
        this.classLoaderProvider = new JcrGroovyClassLoaderProvider();
    }

    public List<ShortTypeInfo> getClassNames(String prefix, DependentResources resources) throws MalformedURLException, URISyntaxException, RepositoryException, RepositoryConfigurationException {
        Class[] classes;
        SourceFolder[] src = this.createSourceFolder(resources.getFolderSources());
        SourceFile[] srcFiles = this.createSourceFiles(resources.getFileSources());
        ArrayList<SourceFile> nodeFiles = new ArrayList<SourceFile>();
        for (SourceFolder f : src) {
            UnifiedNodeReference ref = new UnifiedNodeReference(f.getPath());
            Session session = GroovyClassNamesExtractor.getSession(this.repositoryService, (SessionProviderService)this.sessionProviderService, ref.getRepository(), ref.getWorkspace());
            String p = ref.getPath();
            String sql = "SELECT * FROM nt:file WHERE jcr:path LIKE '" + p + "%'";
            Query q = session.getWorkspace().getQueryManager().createQuery(sql, "sql");
            QueryResult result = q.execute();
            NodeIterator iterator = result.getNodes();
            while (iterator.hasNext()) {
                NodeImpl nod = (NodeImpl)iterator.nextNode();
                if (!nod.getName().endsWith(".groovy") && !nod.getName().endsWith(".grs") || !nod.getName().startsWith(prefix)) continue;
                String path = "jcr://" + ref.getRepository() + "/" + ref.getWorkspace() + "#" + nod.getPath();
                URL url = new URL(null, path, UnifiedNodeReference.getURLStreamHandler());
                nodeFiles.add(new SourceFile(url));
            }
        }
        if (srcFiles != null) {
            nodeFiles.addAll(Arrays.asList(srcFiles));
        }
        this.classLoader = src != null ? this.classLoaderProvider.getGroovyClassLoader(src) : this.classLoaderProvider.getGroovyClassLoader();
        ArrayList<ShortTypeInfo> types = new ArrayList<ShortTypeInfo>();
        this.classLoader.parseClasses(nodeFiles.toArray(new SourceFile[0]));
        for (Class clazz : classes = this.classLoader.getLoadedClasses()) {
            if (!clazz.getSimpleName().startsWith(prefix)) continue;
            types.add(TypeInfoExtractor.extract(clazz));
        }
        return types;
    }

    private SourceFolder[] createSourceFolder(List<String> sources) {
        SourceFolder[] src = null;
        if (sources.size() > 0) {
            src = new SourceFolder[sources.size()];
            for (int i = 0; i < sources.size(); ++i) {
                try {
                    String str = sources.get(i);
                    URL url = null;
                    url = str.startsWith("jcr://") ? new URL(null, str, UnifiedNodeReference.getURLStreamHandler()) : new URL(str);
                    src[i] = new SourceFolder(url);
                    continue;
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
        return src;
    }

    private SourceFile[] createSourceFiles(List<String> fileSrc) throws MalformedURLException {
        SourceFile[] srcFiles = null;
        if (!fileSrc.isEmpty()) {
            srcFiles = new SourceFile[fileSrc.size()];
            for (int i = 0; i < fileSrc.size(); ++i) {
                String str = fileSrc.get(i);
                URL url = null;
                url = str.startsWith("jcr://") ? new URL(null, str, UnifiedNodeReference.getURLStreamHandler()) : new URL(str);
                srcFiles[i] = new SourceFile(url);
            }
        }
        return srcFiles;
    }

    public TypeInfo getClassInfo(String fqn, DependentResources resources) throws MalformedURLException, URISyntaxException, RepositoryException, RepositoryConfigurationException {
        Class[] classes;
        SourceFolder[] src = this.createSourceFolder(resources.getFolderSources());
        SourceFile[] srcFiles = this.createSourceFiles(resources.getFileSources());
        ArrayList<SourceFile> nodeFiles = new ArrayList<SourceFile>();
        for (SourceFolder f : src) {
            UnifiedNodeReference ref = new UnifiedNodeReference(f.getPath());
            Session session = GroovyClassNamesExtractor.getSession(this.repositoryService, (SessionProviderService)this.sessionProviderService, ref.getRepository(), ref.getWorkspace());
            String p = ref.getPath();
            String sql = "SELECT * FROM nt:file WHERE jcr:path LIKE '" + p + "%'";
            Query q = session.getWorkspace().getQueryManager().createQuery(sql, "sql");
            QueryResult result = q.execute();
            NodeIterator iterator = result.getNodes();
            while (iterator.hasNext()) {
                NodeImpl nod = (NodeImpl)iterator.nextNode();
                if (!nod.getName().endsWith(".groovy") && !nod.getName().endsWith(".grs")) continue;
                String path = "jcr://" + ref.getRepository() + "/" + ref.getWorkspace() + "#" + nod.getPath();
                URL url = new URL(null, path, UnifiedNodeReference.getURLStreamHandler());
                nodeFiles.add(new SourceFile(url));
            }
        }
        if (srcFiles != null) {
            nodeFiles.addAll(Arrays.asList(srcFiles));
        }
        this.classLoader = src != null ? this.classLoaderProvider.getGroovyClassLoader(src) : this.classLoaderProvider.getGroovyClassLoader();
        this.classLoader.parseClasses(nodeFiles.toArray(new SourceFile[0]));
        for (Class clazz : classes = this.classLoader.getLoadedClasses()) {
            if (!clazz.getName().equals(fqn)) continue;
            return TypeInfoExtractor.extract(clazz);
        }
        return null;
    }

    protected static Session getSession(RepositoryService repositoryService, SessionProviderService sessionProviderService, String repoName, String workspace) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository repo = repositoryService.getRepository(repoName);
        SessionProvider sp = sessionProviderService.getSessionProvider(null);
        if (sp == null) {
            throw new RepositoryException("SessionProvider is not properly set. Make the application callsSessionProviderService.setSessionProvider(..) somewhere before (for instance in Servlet Filter for WEB application)");
        }
        return sp.getSession(workspace, repo);
    }
}

