/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.migration;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.ecm.ProductVersions;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class SCVPortletPreferenceMigrationService
implements Startable {
    private static final String BASE_PATH_NAME = "basePath";
    private static final String BASE_PATH_VALUE = "detail";
    private static final String SHOW_SCV_WITH_NAME = "showScvWith";
    private static final String SHOW_SCV_WITH_VALUE = "content-id";
    private static final String MOP_PORTLET_PREFERENCE = "mop:portletpreference";
    private RepositoryService repoService_;
    private Log log = ExoLogger.getLogger(this.getClass());

    public SCVPortletPreferenceMigrationService(RepositoryService repoService) {
        this.repoService_ = repoService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (ProductVersions.getCurrentVersionAsInt() == 213) {
            SessionProvider sessionProvider = SessionProvider.createSystemProvider();
            try {
                ManageableRepository repository = this.repoService_.getCurrentRepository();
                Session session = sessionProvider.getSession("portal-system", repository);
                QueryManager manager = session.getWorkspace().getQueryManager();
                String statement = "SELECT * from mop:workspaceclone WHERE mop:contentid='presentation/SingleContentViewer' and fn:name() = 'mop:customization'";
                Query query = manager.createQuery(statement.toString(), "sql");
                NodeIterator nodes = query.execute().getNodes();
                while (nodes.hasNext()) {
                    Node stateNode;
                    Node node = (Node)nodes.next();
                    if (!node.hasNode("mop:state") || !(stateNode = node.getNode("mop:state")).isNodeType("mop:portletpreferences")) continue;
                    this.addNode(stateNode, "mop:basePath", BASE_PATH_VALUE);
                    this.addNode(stateNode, "mop:showScvWith", SHOW_SCV_WITH_VALUE);
                    stateNode.save();
                }
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"An unexpected problem occurs when adding new preferences for old SCV portlets", (Throwable)e);
                }
            }
            finally {
                sessionProvider.close();
            }
        }
    }

    private void addNode(Node stateNode, String nodeName, String value) {
        block4: {
            try {
                if (!stateNode.hasNode(nodeName)) {
                    Node prefNode = stateNode.addNode(nodeName, MOP_PORTLET_PREFERENCE);
                    prefNode.setProperty("mop:value", new String[]{value});
                    prefNode.setProperty("mop:readonly", false);
                    stateNode.save();
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("Add :: mop:portletpreference :: " + nodeName + " :-: " + value + " ::" + stateNode.getPath()));
                    }
                }
            }
            catch (Exception e) {
                if (!this.log.isWarnEnabled()) break block4;
                this.log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void stop() {
    }
}

