/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PropertyConfigurator;
import org.exoplatform.container.SessionContainer;
import org.exoplatform.container.SessionManager;
import org.exoplatform.container.SessionManagerContainer;
import org.exoplatform.container.SessionManagerImpl;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.configuration.ConfigurationManagerImpl;
import org.exoplatform.container.jmx.MX4JComponentAdapterFactory;
import org.exoplatform.container.monitor.jvm.J2EEServerInfo;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NamingContext;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Managed
@NamingContext(value={@Property(key="container", value="standalone")})
@RESTEndpoint(path="scontainer")
public class StandaloneContainer
extends ExoContainer
implements SessionManagerContainer {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.StandaloneContainer");
    private static final long serialVersionUID = 12L;
    private static StandaloneContainer container;
    private static URL configurationURL;
    private static boolean useDefault;
    private SessionManager smanager_;
    private ConfigurationManagerImpl configurationManager;

    private StandaloneContainer(ClassLoader configClassLoader) {
        super(new MX4JComponentAdapterFactory(), null);
        this.configurationManager = new ConfigurationManagerImpl(configClassLoader, ExoContainer.getProfiles());
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                StandaloneContainer.this.registerComponentInstance(ConfigurationManager.class, StandaloneContainer.this.configurationManager);
                StandaloneContainer.this.registerComponentImplementation(SessionManagerImpl.class);
                new PropertyConfigurator(StandaloneContainer.this.configurationManager);
                return null;
            }
        });
    }

    public static StandaloneContainer getInstance() throws Exception {
        return StandaloneContainer.getInstance(null, null);
    }

    public static StandaloneContainer getInstance(ClassLoader configClassLoader) throws Exception {
        return StandaloneContainer.getInstance(configClassLoader, null);
    }

    public static StandaloneContainer getInstance(Object[][] components) throws Exception {
        return StandaloneContainer.getInstance(null, components);
    }

    public static StandaloneContainer getInstance(ClassLoader configClassLoader, Object[][] components) throws Exception {
        if (container == null) {
            container = new StandaloneContainer(configClassLoader);
            SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ExoContainerContext.setTopContainer(container);
                    return null;
                }
            });
            if (useDefault) {
                container.initDefaultConf();
            }
            StandaloneContainer.initConfigurationURL(configClassLoader);
            container.populate(configurationURL);
            if (components != null) {
                container.registerArray(components);
            }
            SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    container.start();
                    return null;
                }
            });
            PrivilegedSystemHelper.setProperty((String)"exo.standalone-container", (String)StandaloneContainer.class.getName());
            LOG.info((Object)("StandaloneContainer initialized using:  " + configurationURL));
        }
        return container;
    }

    protected void registerArray(Object[][] components) {
        for (Object[] comp : components) {
            if (comp.length != 2 || comp[0] == null || comp[1] == null || comp[0].getClass().getName() != String.class.getName()) continue;
            String n = (String)comp[0];
            Object o = comp[1];
            container.registerComponentInstance(n, o);
            LOG.info((Object)("StandaloneContainer: injecting \"" + n + "\""));
        }
    }

    public static void addConfigurationURL(String url) throws MalformedURLException {
        if (url == null || url.length() == 0) {
            return;
        }
        URL confURL = new URL(url);
        configurationURL = StandaloneContainer.fileExists(confURL) ? confURL : null;
    }

    public static void setConfigurationURL(String url) throws MalformedURLException {
        useDefault = false;
        StandaloneContainer.addConfigurationURL(url);
    }

    public static void addConfigurationPath(final String path) throws MalformedURLException {
        if (path == null || path.length() == 0) {
            return;
        }
        URL confURL = (URL)SecurityHelper.doPrivilegedMalformedURLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<URL>(){

            @Override
            public URL run() throws Exception {
                return new File(path).toURI().toURL();
            }
        });
        configurationURL = StandaloneContainer.fileExists(confURL) ? confURL : null;
    }

    public static void setConfigurationPath(String path) throws MalformedURLException {
        useDefault = false;
        StandaloneContainer.addConfigurationPath(path);
    }

    public SessionContainer createSessionContainer(String id) {
        SessionContainer scontainer = this.getSessionManager().getSessionContainer(id);
        if (scontainer != null) {
            this.getSessionManager().removeSessionContainer(id);
        }
        scontainer = new SessionContainer(id, null);
        this.getSessionManager().addSessionContainer(scontainer);
        SessionContainer.setInstance(scontainer);
        return scontainer;
    }

    @Override
    public SessionContainer createSessionContainer(String id, String owner) {
        return this.createSessionContainer(id);
    }

    @Override
    public List<SessionContainer> getLiveSessions() {
        return this.getSessionManager().getLiveSessions();
    }

    @Override
    public void removeSessionContainer(String sessionID) {
        this.getSessionManager().removeSessionContainer(sessionID);
    }

    public URL getConfigurationURL() {
        return configurationURL;
    }

    @Managed
    @ManagedDescription(value="The configuration of the container in XML format.")
    public String getConfigurationXML() {
        Configuration config = this.getConfiguration();
        if (config == null) {
            LOG.warn((Object)"The configuration of the StandaloneContainer could not be found");
            return null;
        }
        return config.toXML();
    }

    @Override
    public void stop() {
        super.stop();
        ExoContainerContext.setTopContainer(null);
        container = null;
    }

    @Override
    public SessionManager getSessionManager() {
        if (this.smanager_ == null) {
            this.smanager_ = (SessionManager)this.getComponentInstanceOfType(SessionManager.class);
        }
        return this.smanager_;
    }

    private static boolean fileExists(final URL url) {
        try {
            SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    url.openStream().close();
                    return null;
                }
            });
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static void initConfigurationURL(ClassLoader configClassLoader) throws MalformedURLException, ConfigurationException {
        if (configurationURL == null) {
            final J2EEServerInfo env = new J2EEServerInfo();
            configurationURL = (URL)SecurityHelper.doPrivilegedMalformedURLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws Exception {
                    return new File(env.getServerHome() + "/exo-configuration.xml").toURI().toURL();
                }
            });
            if (!StandaloneContainer.fileExists(configurationURL)) {
                configurationURL = (URL)SecurityHelper.doPrivilegedMalformedURLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<URL>(){

                    @Override
                    public URL run() throws Exception {
                        return new File(env.getExoConfigurationDirectory() + "/exo-configuration.xml").toURI().toURL();
                    }
                });
            }
            if (!StandaloneContainer.fileExists(configurationURL) && configClassLoader != null) {
                configurationURL = configClassLoader.getResource("conf/exo-configuration.xml");
            }
        }
    }

    private void initDefaultConf() throws Exception {
        block2: {
            this.configurationManager.addConfiguration(ContainerUtil.getConfigurationURL("conf/configuration.xml"));
            this.configurationManager.addConfiguration(ContainerUtil.getConfigurationURL("conf/portal/configuration.xml"));
            try {
                this.configurationManager.addConfiguration("war:/conf/configuration.xml");
            }
            catch (Exception ex) {
                if (!LOG.isTraceEnabled()) break block2;
                LOG.trace((Object)("An exception occurred: " + ex.getMessage()));
            }
        }
    }

    private void populate(URL conf) throws Exception {
        this.configurationManager.addConfiguration(conf);
        this.configurationManager.processRemoveConfiguration();
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ContainerUtil.addComponents(StandaloneContainer.this, StandaloneContainer.this.configurationManager);
                return null;
            }
        });
    }

    static {
        configurationURL = null;
        useDefault = true;
    }
}

