/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.plugins;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.cms.views.ViewConfig;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UserViewUpgradePlugin
extends UpgradeProductPlugin {
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());
    private ManageViewService manageViewService_;

    public UserViewUpgradePlugin(ManageViewService manageViewService, InitParams initParams) {
        super(initParams);
        this.manageViewService_ = manageViewService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        String unchangedViews = PrivilegedSystemHelper.getProperty((String)"unchanged-site-explorer-views");
        SessionProvider sessionProvider = null;
        if (StringUtils.isEmpty((String)unchangedViews)) {
            unchangedViews = "";
        }
        try {
            HashSet<String> unchangedViewSet = new HashSet<String>();
            Set configuredViews = this.manageViewService_.getConfiguredViews();
            ArrayList<Node> removedNodes = new ArrayList<Node>();
            for (String unchangedView : unchangedViews.split(",")) {
                unchangedViewSet.add(unchangedView.trim());
            }
            sessionProvider = SessionProvider.createSystemProvider();
            Node parentNode = null;
            for (ViewConfig viewConfig : this.manageViewService_.getAllViews()) {
                String viewName = viewConfig.getName();
                if (unchangedViewSet.contains(viewName) || !configuredViews.contains(viewName)) continue;
                removedNodes.add(this.manageViewService_.getViewByName(viewName, sessionProvider));
                parentNode = this.manageViewService_.getViewByName(viewName, sessionProvider).getParent();
            }
            for (Node removedNode : removedNodes) {
                try {
                    removedNode.remove();
                    parentNode.save();
                }
                catch (Exception e) {
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.error((Object)("Error in " + this.getName() + ": Can not remove old query node: " + removedNode.getPath()));
                }
            }
            this.manageViewService_.init();
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"An unexpected error occurs when migrating Site Explorer views:", (Throwable)e);
            }
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
        return true;
    }
}

