/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp.command;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.services.ftp.FtpTextUtils;
import org.exoplatform.services.ftp.command.FtpCommandImpl;
import org.exoplatform.services.ftp.config.FtpConfig;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CmdStor
extends FtpCommandImpl {
    private static final Log LOG = ExoLogger.getLogger("exo.jcr.component.ftp.CmdStor");

    public CmdStor() {
        this.commandName = "STOR";
    }

    public void run(String[] params) throws IOException {
        if (this.clientSession().getDataTransiver() == null) {
            this.reply("425 Unable to build data connection");
            return;
        }
        try {
            while (!this.clientSession().getDataTransiver().isConnected()) {
                Thread.sleep(100L);
            }
        }
        catch (Exception exc) {
            LOG.info((Object)("Unhandled exception. " + exc.getMessage()), exc);
        }
        if (params.length < 2) {
            this.reply(String.format("500 %s: command requires a parameter", "STOR"));
            return;
        }
        String fileName = params[1];
        try {
            ArrayList<String> newPath = this.clientSession().getFullPath(fileName);
            FtpConfig ftpConfig = this.clientSession().getFtpServer().getConfiguration();
            if (ftpConfig.isReplaceForbiddenChars()) {
                String fName = newPath.get(newPath.size() - 1);
                String newfName = FtpTextUtils.replaceForbiddenChars(fName, ftpConfig.getForbiddenChars(), ftpConfig.getReplaceChar());
                fileName = fileName.substring(0, fileName.indexOf(fName)) + newfName;
            }
            Session curSession = this.clientSession().getSession(newPath.get(0));
            Node resourceNode = this.getExistedFileNode(curSession, fileName);
            boolean isNeedCheckIn = false;
            if (resourceNode == null) {
                if ("REST".equals(this.clientSession().getPrevCommand())) {
                    this.reply(String.format("550 %s: Permission denied", "Requested file not exist"));
                    return;
                }
                resourceNode = this.createNewFileNode(curSession, fileName);
            } else {
                int restOffset;
                if ("REST".equals(this.clientSession().getPrevCommand()) && (long)(restOffset = new Integer(this.clientSession().getPrevParams()).intValue()) > resourceNode.getProperty("jcr:data").getLength() + 1L) {
                    this.reply(String.format("550 %s: Permission denied", "Restore value invalid"));
                    return;
                }
                if (resourceNode.getParent().isNodeType("mix:versionable")) {
                    resourceNode.getParent().checkout();
                    isNeedCheckIn = true;
                }
            }
            InputStream inputStream = null;
            String cacheFileName = null;
            if ("REST".equals(this.clientSession().getPrevCommand())) {
                int readed;
                int readed2;
                String cacheFolderName = this.clientSession().getFtpServer().getConfiguration().getCacheFolderName();
                cacheFileName = cacheFolderName + "/" + IdGenerator.generate() + ".ftpcache";
                File cacheFile = new File(cacheFileName);
                boolean created = cacheFile.createNewFile();
                if (!created) {
                    this.reply(String.format("550 %s: Permission denied", "STOR"));
                    return;
                }
                FileOutputStream cacheOutStream = new FileOutputStream(cacheFile);
                InputStream nodeInputStream = resourceNode.getProperty("jcr:data").getStream();
                if (nodeInputStream == null) {
                    this.reply(String.format("550 %s: Permission denied", "STOR"));
                    return;
                }
                byte[] buffer = new byte[32768];
                while ((readed2 = nodeInputStream.read(buffer)) >= 0) {
                    cacheOutStream.write(buffer, 0, readed2);
                }
                cacheOutStream.close();
                RandomAccessFile cacheFilePoint = new RandomAccessFile(cacheFile, "rw");
                int restOffset = new Integer(this.clientSession().getPrevParams());
                cacheFilePoint.seek(restOffset);
                InputStream socketInputStream = this.clientSession().getDataTransiver().getInputStream();
                this.reply("125 Data connection already open; Transfer starting");
                while ((readed = socketInputStream.read(buffer)) >= 0) {
                    cacheFilePoint.write(buffer, 0, readed);
                }
                cacheFilePoint.close();
                inputStream = new FileInputStream(cacheFile);
            } else {
                inputStream = this.clientSession().getDataTransiver().getInputStream();
                this.reply("125 Data connection already open; Transfer starting");
            }
            resourceNode.setProperty("jcr:lastModified", Calendar.getInstance());
            resourceNode.setProperty("jcr:data", inputStream);
            curSession.save();
            this.clientSession().closeDataTransiver();
            try {
                inputStream.close();
            }
            catch (IOException exc) {
                LOG.info("Failurinc closing input stream");
            }
            if (cacheFileName != null) {
                File cacheFile = new File(cacheFileName);
                cacheFile.delete();
            }
            if (isNeedCheckIn) {
                resourceNode.getParent().checkin();
            }
            this.reply("226 Transfer complete");
            return;
        }
        catch (RepositoryException rexc) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("An exception occurred: " + rexc.getMessage());
            }
        }
        catch (Exception exc) {
            LOG.info((Object)("Unhandled exception. " + exc.getMessage()), exc);
        }
        this.clientSession().closeDataTransiver();
        this.reply(String.format("550 %s: Permission denied", fileName));
    }

    protected Node getExistedFileNode(Session curSession, String resName) {
        try {
            ArrayList<String> newPath = this.clientSession().getFullPath(resName);
            String repoPath = this.clientSession().getRepoPath(newPath);
            Node fileNode = (Node)curSession.getItem(repoPath);
            return fileNode.getNode("jcr:content");
        }
        catch (RepositoryException rexc) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("An exception occurred: " + rexc.getMessage());
            }
        }
        catch (Exception exc) {
            LOG.info((Object)("Unhandled exception. " + exc.getMessage()), exc);
        }
        return null;
    }

    protected Node createNewFileNode(Session curSession, String resName) {
        try {
            ArrayList<String> newPath = this.clientSession().getFullPath(resName);
            String repoPath = this.clientSession().getRepoPath(newPath);
            String onlyName = repoPath.substring(repoPath.lastIndexOf("/") + 1);
            String onlyPath = repoPath.substring(0, repoPath.length() - onlyName.length());
            if (onlyPath.length() > 1 && onlyPath.endsWith("/")) {
                onlyPath = onlyPath.substring(0, onlyPath.length() - 1);
            }
            Node parentNode = (Node)curSession.getItem(onlyPath);
            FtpConfig configuration = this.clientSession().getFtpServer().getConfiguration();
            String fileNodeType = configuration.getDefFileNodeType();
            Node fileNode = parentNode.addNode(onlyName, fileNodeType);
            Node dataNode = fileNode.addNode("jcr:content", "nt:resource");
            MimeTypeResolver mimeTypeResolver = new MimeTypeResolver();
            mimeTypeResolver.setDefaultMimeType(configuration.getDefFileMimeType());
            String mimeType = mimeTypeResolver.getMimeType(onlyName);
            dataNode.setProperty("jcr:mimeType", mimeType);
            dataNode.setProperty("jcr:lastModified", Calendar.getInstance());
            return dataNode;
        }
        catch (PathNotFoundException pexc) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("An exception occurred: " + pexc.getMessage());
            }
        }
        catch (Exception exc) {
            LOG.info((Object)("Unhandled exception. " + exc.getMessage()), exc);
        }
        return null;
    }
}

