/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.migration;

import java.util.Collection;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.space.SpaceUtils;

public class TemplateTool {
    private final PortalContainer container = PortalContainer.getInstance();
    private final OrganizationService service = (OrganizationService)this.container.getComponentInstanceOfType(OrganizationService.class);
    private final NavigationService navigationService = (NavigationService)this.container.getComponentInstanceOfType(NavigationService.class);
    private final String UI_SPACE_NEW_TEMPLATE = "system:/groovy/portal/webui/container/UIContainer.gtmpl";
    private static final Log LOG = ExoLogger.getLogger(TemplateTool.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            GroupHandler groupHandler = this.service.getGroupHandler();
            Group spaces = groupHandler.findGroupById("/spaces");
            Collection groups = groupHandler.findGroups(spaces);
            for (Group group : groups) {
                Query query = new Query("group", group.getId(), null, null, Page.class);
                DataStorage dataStorage = SpaceUtils.getDataStorage();
                List pages = dataStorage.find(query).getAll();
                for (Page page : pages) {
                    ModelObject modelObject;
                    if (page.getChildren().size() <= 0 || !((modelObject = (ModelObject)page.getChildren().get(0)) instanceof Container)) continue;
                    Container container = (Container)modelObject;
                    if (!"system:/groovy/portal/webui/container/UIContainer.gtmpl".equals(container.getTemplate())) {
                        container.setTemplate("system:/groovy/portal/webui/container/UIContainer.gtmpl");
                        dataStorage.save(page);
                        LOG.info((Object)("Update template for " + group.getId() + " : " + page.getTitle()));
                        continue;
                    }
                    LOG.info((Object)("Skip template for " + group.getId() + " : " + page.getTitle() + " (already done)"));
                }
                NavigationContext pageNavCtx = this.navigationService.loadNavigation(SiteKey.group((String)group.getId()));
                NodeContext nodeCtx = (NodeContext)this.navigationService.loadNode(NodeModel.SELF_MODEL, pageNavCtx, Scope.GRANDCHILDREN, null).getNode();
                LOG.info((Object)("Check navigations for : " + group.getId()));
                for (NodeContext ctx : nodeCtx.getNodes()) {
                    for (NodeContext ctxPage : ctx.getNodes()) {
                        if (!"SpaceSettingPortlet".equals(ctxPage.getName()) && !"Space_Settings".equals(ctxPage.getName()) && !"Space_settings".equals(ctxPage.getName())) continue;
                        ctxPage.setName("settings");
                        this.navigationService.saveNode(ctxPage, null);
                        LOG.info((Object)("Update setting page name : " + ctxPage.getName()));
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.info((Object)("Error during template migration : " + e.getMessage()), (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }
}

