/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.i18n.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.impl.core.value.DateValue;
import org.exoplatform.services.jcr.impl.core.value.StringValue;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiLanguageServiceImpl
implements MultiLanguageService {
    public static final String JCRCONTENT = "jcr:content";
    public static final String JCRDATA = "jcr:data";
    public static final String JCR_MIMETYPE = "jcr:mimeType";
    public static final String NTUNSTRUCTURED = "nt:unstructured";
    public static final String NTFOLDER = "nt:folder";
    public static final String NTFILE = "nt:file";
    public static final String JCR_LASTMODIFIED = "jcr:lastModified";
    static final String VOTER_PROP = "exo:voter";
    static final String VOTING_RATE_PROP = "exo:votingRate";
    static final String VOTE_TOTAL_PROP = "exo:voteTotal";
    static final String VOTE_TOTAL_LANG_PROP = "exo:voteTotalOfLang";
    static final String NODE = "/node/";
    static final String NODE_LANGUAGE = "/node/languages/";
    static final String CONTENT_PATH = "/node/jcr:content/";
    static final String TEMP_NODE = "temp";
    private static final String MIX_REFERENCEABLE = "mix:referenceable";
    private static final String MIX_COMMENTABLE = "mix:commentable";
    private static final String COUNTRY_VARIANT = "_";
    private static final Log LOG = ExoLogger.getLogger((String)MultiLanguageServiceImpl.class.getName());
    private CmsService cmsService_;

    public MultiLanguageServiceImpl(CmsService cmsService) throws Exception {
        this.cmsService_ = cmsService;
    }

    private void setPropertyValue(String propertyName, Node node, int requiredtype, Object value, boolean isMultiple) throws Exception {
        switch (requiredtype) {
            case 1: {
                if (value == null) {
                    node.setProperty(propertyName, "");
                    break;
                }
                if (isMultiple) {
                    if (value instanceof String) {
                        node.setProperty(propertyName, new String[]{value.toString()});
                        break;
                    }
                    if (!(value instanceof String[])) break;
                    node.setProperty(propertyName, (String[])value);
                    break;
                }
                if (value instanceof StringValue) {
                    StringValue strValue = (StringValue)value;
                    node.setProperty(propertyName, strValue.getString());
                    break;
                }
                node.setProperty(propertyName, value.toString());
                break;
            }
            case 2: {
                if (value == null) {
                    node.setProperty(propertyName, "");
                    break;
                }
                if (value instanceof byte[]) {
                    node.setProperty(propertyName, (InputStream)new ByteArrayInputStream((byte[])value));
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, (InputStream)new ByteArrayInputStream(value.toString().getBytes()));
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (InputStream)new ByteArrayInputStream(((String[])value).toString().getBytes()));
                break;
            }
            case 6: {
                if (value == null) {
                    node.setProperty(propertyName, false);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, new Boolean(value.toString()).booleanValue());
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (String[])value);
                break;
            }
            case 3: {
                if (value == null || "".equals(value)) {
                    node.setProperty(propertyName, 0L);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, new Long(value.toString()).longValue());
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (String[])value);
                break;
            }
            case 4: {
                if (value == null || "".equals(value)) {
                    node.setProperty(propertyName, 0L);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, new Double(value.toString()).doubleValue());
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (String[])value);
                break;
            }
            case 5: {
                if (value == null) {
                    node.setProperty(propertyName, (Calendar)new GregorianCalendar());
                    break;
                }
                if (isMultiple) {
                    Session session = node.getSession();
                    if (value instanceof String) {
                        Value value2add = session.getValueFactory().createValue(ISO8601.parse((String)((String)value)));
                        node.setProperty(propertyName, new Value[]{value2add});
                        break;
                    }
                    if (!(value instanceof String[])) break;
                    String[] values = (String[])value;
                    Value[] convertedCalendarValues = new Value[values.length];
                    int i = 0;
                    for (String stringValue : values) {
                        Value value2add;
                        convertedCalendarValues[i] = value2add = session.getValueFactory().createValue(ISO8601.parse((String)stringValue));
                        ++i;
                    }
                    node.setProperty(propertyName, convertedCalendarValues);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, ISO8601.parse((String)value.toString()));
                    break;
                }
                if (value instanceof GregorianCalendar) {
                    node.setProperty(propertyName, (Calendar)((GregorianCalendar)value));
                    break;
                }
                if (!(value instanceof DateValue)) break;
                DateValue dateValue = (DateValue)value;
                node.setProperty(propertyName, dateValue.getDate());
                break;
            }
            case 9: {
                if (value == null) {
                    node.setProperty(propertyName, "");
                    break;
                }
                if (value instanceof Value) {
                    node.setProperty(propertyName, (Value)value);
                    break;
                }
                if (value instanceof Value[]) {
                    node.setProperty(propertyName, (Value[])value);
                    break;
                }
                if (!(value instanceof String)) break;
                Session session = node.getSession();
                Node catNode = null;
                String itemPath = value.toString();
                if (itemPath == null || itemPath.length() <= 0) break;
                if (value.toString().indexOf(":/") > -1 && value.toString().split(":/").length > 0) {
                    itemPath = "/" + value.toString().split(":/")[1];
                }
                try {
                    catNode = (Node)session.getItem(itemPath);
                }
                catch (PathNotFoundException e) {
                    catNode = session.getRootNode().getNode(itemPath);
                }
                if (catNode != null) {
                    if (!catNode.isNodeType(MIX_REFERENCEABLE)) {
                        catNode.addMixin(MIX_REFERENCEABLE);
                        catNode.save();
                    }
                    Value value2add = session.getValueFactory().createValue(catNode);
                    if (isMultiple) {
                        node.setProperty(propertyName, new Value[]{value2add});
                        break;
                    }
                    node.setProperty(propertyName, value2add);
                    break;
                }
                node.setProperty(propertyName, value.toString());
            }
        }
    }

    private void setMixin(Node node, Node newLang, boolean setValuesOnyIfCanAddMixin) throws Exception {
        NodeType[] mixins;
        for (NodeType mixin : mixins = node.getMixinNodeTypes()) {
            if (!this.canCopy(mixin)) continue;
            boolean mixinAdded = false;
            if (newLang.canAddMixin(mixin.getName())) {
                newLang.addMixin(mixin.getName());
                mixinAdded = true;
            }
            if (setValuesOnyIfCanAddMixin && !mixinAdded) continue;
            for (PropertyDefinition def : mixin.getPropertyDefinitions()) {
                if (def.isProtected()) continue;
                String propName = def.getName();
                if (!def.isMandatory() || def.isAutoCreated()) continue;
                if (def.isMultiple()) {
                    newLang.setProperty(propName, node.getProperty(propName).getValues());
                    continue;
                }
                newLang.setProperty(propName, node.getProperty(propName).getValue());
            }
        }
    }

    private void setMixin(Node node, Node newLang) throws Exception {
        this.setMixin(node, newLang, true);
    }

    private Node addNewFileNode(String fileName, Node newLanguageNode, Value value, Object lastModified, String mimeType, String repositoryName) throws Exception {
        HashMap<String, JcrInputProperty> inputProperties = new HashMap<String, JcrInputProperty>();
        JcrInputProperty nodeInput = new JcrInputProperty();
        nodeInput.setJcrPath("/node");
        nodeInput.setValue(fileName);
        nodeInput.setMixintype("mix:i18n,mix:votable,mix:commentable");
        nodeInput.setType(1);
        inputProperties.put("/node", nodeInput);
        JcrInputProperty jcrContent = new JcrInputProperty();
        jcrContent.setJcrPath("/node/jcr:content");
        jcrContent.setValue("");
        jcrContent.setMixintype("dc:elementSet");
        jcrContent.setNodetype("nt:resource");
        jcrContent.setType(1);
        inputProperties.put("/node/jcr:content", jcrContent);
        JcrInputProperty jcrData = new JcrInputProperty();
        jcrData.setJcrPath("/node/jcr:content/jcr:data");
        jcrData.setValue(value.getStream());
        inputProperties.put("/node/jcr:content/jcr:data", jcrData);
        JcrInputProperty jcrMimeType = new JcrInputProperty();
        jcrMimeType.setJcrPath("/node/jcr:content/jcr:mimeType");
        jcrMimeType.setValue(mimeType);
        inputProperties.put("/node/jcr:content/jcr:mimeType", jcrMimeType);
        JcrInputProperty jcrLastModified = new JcrInputProperty();
        jcrLastModified.setJcrPath("/node/jcr:content/jcr:lastModified");
        jcrLastModified.setValue(lastModified);
        inputProperties.put("/node/jcr:content/jcr:lastModified", jcrLastModified);
        JcrInputProperty jcrEncoding = new JcrInputProperty();
        jcrEncoding.setJcrPath("/node/jcr:content/jcr:encoding");
        jcrEncoding.setValue("UTF-8");
        inputProperties.put("/node/jcr:content/jcr:encoding", jcrEncoding);
        this.cmsService_.storeNode(NTFILE, newLanguageNode, inputProperties, true);
        return newLanguageNode.getNode(fileName);
    }

    private Node getFileLangNode(Node languageNode) throws Exception {
        if (languageNode.getNodes().getSize() > 0L) {
            NodeIterator nodeIter = languageNode.getNodes();
            while (nodeIter.hasNext()) {
                Node ntFile = nodeIter.nextNode();
                if (!ntFile.getPrimaryNodeType().getName().equals(NTFILE)) continue;
                return ntFile;
            }
            return languageNode;
        }
        return languageNode;
    }

    @Override
    public void addLanguage(Node node, Map inputs, String language, boolean isDefault) throws Exception {
        Node newLanguageNode = null;
        Node languagesNode = null;
        String defaultLanguage = this.getDefault(node);
        String primaryNodeTypeName = node.getPrimaryNodeType().getName();
        if (node.hasNode("languages")) {
            languagesNode = node.getNode("languages");
        } else {
            languagesNode = node.addNode("languages", NTUNSTRUCTURED);
            if (languagesNode.canAddMixin("exo:hiddenable")) {
                languagesNode.addMixin("exo:hiddenable");
            }
        }
        if (!defaultLanguage.equals(language)) {
            if (isDefault) {
                if (languagesNode.hasNode(defaultLanguage)) {
                    newLanguageNode = languagesNode.getNode(defaultLanguage);
                } else {
                    newLanguageNode = languagesNode.addNode(defaultLanguage, primaryNodeTypeName);
                    this.setMixin(node, newLanguageNode, false);
                }
            } else if (languagesNode.hasNode(language)) {
                newLanguageNode = languagesNode.getNode(language);
            } else {
                newLanguageNode = languagesNode.addNode(language, primaryNodeTypeName);
                this.setMixin(node, newLanguageNode, false);
                newLanguageNode.setProperty("exo:language", language);
            }
        }
        this.setPropertyLanguage(node, newLanguageNode, inputs, isDefault, defaultLanguage, language);
        if (isDefault && languagesNode.hasNode(language)) {
            languagesNode.getNode(language).remove();
        }
    }

    @Override
    public void addLinkedLanguage(Node node, Node translationNode) throws Exception {
        String lang;
        Node languagesNode;
        if (node.hasNode("languages")) {
            languagesNode = node.getNode("languages");
        } else {
            languagesNode = node.addNode("languages", NTUNSTRUCTURED);
            if (languagesNode.canAddMixin("exo:hiddenable")) {
                languagesNode.addMixin("exo:hiddenable");
            }
        }
        if (!translationNode.isNodeType("mix:i18n")) {
            translationNode.addMixin("mix:i18n");
            translationNode.save();
        }
        if (!node.isNodeType("mix:i18n")) {
            node.addMixin("mix:i18n");
            node.save();
        }
        if (languagesNode.hasNode(lang = translationNode.getProperty("exo:language").getString())) {
            throw new ItemExistsException();
        }
        LinkManager linkManager = (LinkManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(LinkManager.class);
        Node linkNode = linkManager.createLink(languagesNode, "exo:symlink", translationNode, lang);
        ((ExtendedNode)linkNode).setPermission(IdentityConstants.ANY, new String[]{"read"});
        linkNode.getSession().save();
    }

    @Override
    public void addSynchronizedLinkedLanguage(Node selectedNode, Node newTranslationNode) throws Exception {
        block12: {
            String newLang;
            if (newTranslationNode != null && newTranslationNode.isNodeType("exo:symlink")) {
                newTranslationNode = WCMCoreUtils.getService(LinkManager.class).getTarget(newTranslationNode);
            }
            if (!newTranslationNode.isNodeType("mix:i18n")) {
                newTranslationNode.addMixin("mix:i18n");
                newTranslationNode.save();
            }
            if (this.getLanguage(selectedNode, newLang = newTranslationNode.getProperty("exo:language").getString()) == null) {
                List<Node> realTranslationNodes = this.getRealTranslationNodes(selectedNode);
                for (Node node : realTranslationNodes) {
                    block11: {
                        try {
                            this.addLinkedLanguage(node, newTranslationNode);
                        }
                        catch (ItemExistsException ex) {
                            if (!LOG.isInfoEnabled()) break block11;
                            LOG.info((Object)String.format("Language %s already existed for %s", newLang, node.getPath()));
                        }
                    }
                    try {
                        this.addLinkedLanguage(newTranslationNode, node);
                    }
                    catch (ItemExistsException ex) {
                        if (!LOG.isInfoEnabled()) continue;
                        LOG.info((Object)String.format("Language %s already existed for %s", node.getProperty("exo:language").getString(), newTranslationNode.getPath()));
                    }
                }
                try {
                    this.addLinkedLanguage(newTranslationNode, selectedNode);
                    break block12;
                }
                catch (ItemExistsException ex) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)String.format("Language %s already existed for %s", selectedNode.getProperty("exo:language").getString(), newTranslationNode.getPath()));
                    }
                    break block12;
                }
            }
            throw new ItemExistsException();
        }
        this.addLinkedLanguage(selectedNode, newTranslationNode);
    }

    @Override
    public void addLanguage(Node node, Map inputs, String language, boolean isDefault, String nodeType) throws Exception {
        Node newLanguageNode = null;
        Node languagesNode = null;
        String primaryNodeTypeName = node.getPrimaryNodeType().getName();
        String defaultLanguage = this.getDefault(node);
        Workspace ws = node.getSession().getWorkspace();
        if (node.hasNode("languages")) {
            languagesNode = node.getNode("languages");
        } else {
            languagesNode = node.addNode("languages", NTUNSTRUCTURED);
            if (languagesNode.canAddMixin("exo:hiddenable")) {
                languagesNode.addMixin("exo:hiddenable");
            }
        }
        if (!defaultLanguage.equals(language)) {
            if (isDefault) {
                if (languagesNode.hasNode(defaultLanguage)) {
                    newLanguageNode = languagesNode.getNode(defaultLanguage);
                } else {
                    newLanguageNode = languagesNode.addNode(defaultLanguage, primaryNodeTypeName);
                    this.setMixin(node, newLanguageNode, false);
                }
            } else if (languagesNode.hasNode(language)) {
                newLanguageNode = languagesNode.getNode(language);
            } else {
                newLanguageNode = languagesNode.addNode(language, primaryNodeTypeName);
                this.setMixin(node, newLanguageNode, false);
                newLanguageNode.setProperty("exo:language", language);
            }
            Node jcrContent = node.getNode(nodeType);
            node.save();
            if (!newLanguageNode.hasNode(nodeType)) {
                ws.copy(jcrContent.getPath(), newLanguageNode.getPath() + "/" + jcrContent.getName());
            }
            Node newContentNode = newLanguageNode.getNode(nodeType);
            PropertyIterator props = newContentNode.getProperties();
            while (props.hasNext()) {
                Property prop = props.nextProperty();
                if (!inputs.containsKey(NODE + nodeType + "/" + prop.getName())) continue;
                JcrInputProperty inputVariable = (JcrInputProperty)inputs.get(NODE + nodeType + "/" + prop.getName());
                boolean isMultiple = prop.getDefinition().isMultiple();
                this.setPropertyValue(prop.getName(), newContentNode, prop.getType(), inputVariable.getValue(), isMultiple);
            }
            if (isDefault) {
                Node tempNode = node.addNode(TEMP_NODE, NTUNSTRUCTURED);
                node.getSession().move(node.getNode(nodeType).getPath(), tempNode.getPath() + "/" + nodeType);
                node.getSession().move(newLanguageNode.getNode(nodeType).getPath(), node.getPath() + "/" + nodeType);
                node.getSession().move(tempNode.getNode(nodeType).getPath(), languagesNode.getPath() + "/" + defaultLanguage + "/" + nodeType);
                tempNode.remove();
            }
        } else {
            JcrInputProperty inputVariable = (JcrInputProperty)inputs.get(NODE + nodeType + "/" + JCRDATA);
            this.setPropertyValue(JCRDATA, node.getNode(nodeType), inputVariable.getType(), inputVariable.getValue(), false);
        }
        this.setPropertyLanguage(node, newLanguageNode, inputs, isDefault, defaultLanguage, language);
        if (isDefault && languagesNode.hasNode(language)) {
            languagesNode.getNode(language).remove();
        }
    }

    @Override
    public void addFileLanguage(Node node, String fileName, Value value, String mimeType, String language, String repositoryName, boolean isDefault) throws Exception {
        GregorianCalendar oldLastModified;
        String oldMimeType;
        Value oldValue;
        String olfFileName;
        Node oldJcrContent;
        Node ntFileLangNode;
        String defaultLanguage;
        Node languagesNode;
        Node newLanguageNode;
        block16: {
            newLanguageNode = null;
            languagesNode = null;
            defaultLanguage = this.getDefault(node);
            ntFileLangNode = null;
            oldJcrContent = node.getNode(JCRCONTENT);
            olfFileName = node.getName();
            oldValue = oldJcrContent.getProperty(JCRDATA).getValue();
            oldMimeType = oldJcrContent.getProperty(JCR_MIMETYPE).getString();
            oldLastModified = new GregorianCalendar();
            oldLastModified.setTime(oldJcrContent.getProperty(JCR_LASTMODIFIED).getDate().getTime());
            try {
                languagesNode = node.getNode("languages");
            }
            catch (PathNotFoundException pe) {
                languagesNode = node.addNode("languages", NTUNSTRUCTURED);
                if (!languagesNode.canAddMixin("exo:hiddenable")) break block16;
                languagesNode.addMixin("exo:hiddenable");
            }
        }
        if (!defaultLanguage.equals(language)) {
            block18: {
                if (isDefault) {
                    block17: {
                        try {
                            newLanguageNode = languagesNode.getNode(defaultLanguage);
                        }
                        catch (PathNotFoundException pe) {
                            newLanguageNode = languagesNode.addNode(defaultLanguage);
                            if (!newLanguageNode.canAddMixin(MIX_COMMENTABLE)) break block17;
                            newLanguageNode.addMixin(MIX_COMMENTABLE);
                        }
                    }
                    oldJcrContent.setProperty(JCR_MIMETYPE, mimeType);
                    oldJcrContent.setProperty(JCRDATA, value);
                    oldJcrContent.setProperty(JCR_LASTMODIFIED, (Calendar)new GregorianCalendar());
                    oldJcrContent.save();
                } else {
                    try {
                        newLanguageNode = languagesNode.getNode(language);
                    }
                    catch (PathNotFoundException pe) {
                        newLanguageNode = languagesNode.addNode(language);
                        if (newLanguageNode.canAddMixin(MIX_COMMENTABLE)) {
                            newLanguageNode.addMixin(MIX_COMMENTABLE);
                        }
                        if (!languagesNode.canAddMixin("exo:hiddenable")) break block18;
                        languagesNode.addMixin("exo:hiddenable");
                    }
                }
            }
            try {
                ntFileLangNode = newLanguageNode.getNode(fileName);
            }
            catch (PathNotFoundException pe) {
                ntFileLangNode = isDefault ? this.addNewFileNode(olfFileName, newLanguageNode, oldValue, oldLastModified, oldMimeType, repositoryName) : this.addNewFileNode(fileName, newLanguageNode, value, new GregorianCalendar(), mimeType, repositoryName);
            }
            Node newJcrContent = ntFileLangNode.getNode(JCRCONTENT);
            newJcrContent.setProperty(JCR_LASTMODIFIED, (Calendar)new GregorianCalendar());
            this.setMixin(node, ntFileLangNode);
        } else {
            node.getNode(JCRCONTENT).setProperty(JCRDATA, value);
        }
        if (!defaultLanguage.equals(language) && isDefault) {
            Node selectedFileLangeNode = null;
            if (languagesNode.hasNode(language)) {
                Node selectedLangNode = languagesNode.getNode(language);
                selectedFileLangeNode = selectedLangNode.getNode(node.getName());
            }
            this.setVoteProperty(ntFileLangNode, node, selectedFileLangeNode);
            this.setCommentNode(node, ntFileLangNode, selectedFileLangeNode);
        }
        if (isDefault) {
            node.setProperty("exo:language", language);
        }
        node.getSession().save();
    }

    @Override
    public void addFileLanguage(Node node, String language, Map mappings, boolean isDefault) throws Exception {
        Node newLanguageNode = null;
        Node languagesNode = null;
        String primaryNodeTypeName = node.getPrimaryNodeType().getName();
        String defaultLanguage = this.getDefault(node);
        if (node.hasNode("languages")) {
            languagesNode = node.getNode("languages");
        } else {
            languagesNode = node.addNode("languages", NTUNSTRUCTURED);
            if (languagesNode.canAddMixin("exo:hiddenable")) {
                languagesNode.addMixin("exo:hiddenable");
            }
        }
        if (!defaultLanguage.equals(language)) {
            newLanguageNode = isDefault ? (languagesNode.hasNode(defaultLanguage) ? languagesNode.getNode(defaultLanguage) : languagesNode.addNode(defaultLanguage, primaryNodeTypeName)) : (languagesNode.hasNode(language) ? languagesNode.getNode(language) : languagesNode.addNode(language, primaryNodeTypeName));
            Node jcrContent = node.getNode(JCRCONTENT);
            if (!newLanguageNode.hasNode(JCRCONTENT)) {
                Node newJcrContent = newLanguageNode.addNode(JCRCONTENT, "nt:resource");
                newJcrContent.setProperty(JCR_MIMETYPE, jcrContent.getProperty(JCR_MIMETYPE).getValue());
                newJcrContent.setProperty(JCRDATA, jcrContent.getProperty(JCRDATA).getValue());
                newJcrContent.setProperty(JCR_LASTMODIFIED, (Calendar)new GregorianCalendar());
            }
            node.save();
            Node newContentNode = newLanguageNode.getNode(JCRCONTENT);
            PropertyIterator props = newContentNode.getProperties();
            while (props.hasNext()) {
                Property prop = props.nextProperty();
                if (!mappings.containsKey(CONTENT_PATH + prop.getName())) continue;
                JcrInputProperty inputVariable = (JcrInputProperty)mappings.get(CONTENT_PATH + prop.getName());
                boolean isMultiple = prop.getDefinition().isMultiple();
                this.setPropertyValue(prop.getName(), newContentNode, prop.getType(), inputVariable.getValue(), isMultiple);
            }
            if (isDefault) {
                Node tempNode = node.addNode(TEMP_NODE, NTUNSTRUCTURED);
                node.getSession().move(node.getNode(JCRCONTENT).getPath(), tempNode.getPath() + "/" + JCRCONTENT);
                node.getSession().move(newLanguageNode.getNode(JCRCONTENT).getPath(), node.getPath() + "/" + JCRCONTENT);
                node.getSession().move(tempNode.getNode(JCRCONTENT).getPath(), languagesNode.getPath() + "/" + defaultLanguage + "/" + JCRCONTENT);
                tempNode.remove();
            }
            this.setMixin(node, newLanguageNode);
        } else {
            JcrInputProperty inputVariable = (JcrInputProperty)mappings.get("/node/jcr:content/jcr:data");
            this.setPropertyValue(JCRDATA, node.getNode(JCRCONTENT), inputVariable.getType(), inputVariable.getValue(), false);
        }
        this.setPropertyLanguage(node, newLanguageNode, mappings, isDefault, defaultLanguage, language);
    }

    @Override
    public String getDefault(Node node) throws Exception {
        if (node.hasProperty("exo:language")) {
            return node.getProperty("exo:language").getString();
        }
        return null;
    }

    @Override
    public List<String> getSupportedLanguages(Node node) throws Exception {
        ArrayList<String> languages = new ArrayList<String>();
        String defaultLang = this.getDefault(node);
        if (defaultLang != null) {
            languages.add(defaultLang);
        }
        if (node.hasNode("languages")) {
            Node languageNode = node.getNode("languages");
            NodeIterator iter = languageNode.getNodes();
            while (iter.hasNext()) {
                languages.add(iter.nextNode().getName());
            }
        }
        return languages;
    }

    private List<Node> getRealTranslationNodes(Node node) throws Exception {
        LinkManager linkManager = (LinkManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(LinkManager.class);
        ArrayList<Node> translationNodes = new ArrayList<Node>();
        if (node.hasNode("languages")) {
            Node languageNode = node.getNode("languages");
            NodeIterator iter = languageNode.getNodes();
            while (iter.hasNext()) {
                Node currNode = iter.nextNode();
                if (!currNode.isNodeType("exo:symlink")) continue;
                translationNodes.add(linkManager.getTarget(currNode));
            }
        }
        return translationNodes;
    }

    private void setVoteProperty(Node newLang, Node node, Node selectedLangNode) throws Exception {
        if (this.hasMixin(newLang, "mix:votable")) {
            newLang.setProperty(VOTE_TOTAL_PROP, this.getVoteTotal(node));
            newLang.setProperty(VOTE_TOTAL_LANG_PROP, node.getProperty(VOTE_TOTAL_LANG_PROP).getLong());
            newLang.setProperty(VOTING_RATE_PROP, node.getProperty(VOTING_RATE_PROP).getLong());
            if (node.hasProperty(VOTER_PROP)) {
                newLang.setProperty(VOTER_PROP, node.getProperty(VOTER_PROP).getValues());
            }
            if (selectedLangNode != null) {
                node.setProperty(VOTE_TOTAL_PROP, this.getVoteTotal(node));
                if (selectedLangNode.hasProperty(VOTE_TOTAL_LANG_PROP)) {
                    node.setProperty(VOTE_TOTAL_LANG_PROP, selectedLangNode.getProperty(VOTE_TOTAL_LANG_PROP).getLong());
                } else {
                    node.setProperty(VOTE_TOTAL_LANG_PROP, 0L);
                }
                if (selectedLangNode.hasProperty(VOTING_RATE_PROP)) {
                    node.setProperty(VOTING_RATE_PROP, selectedLangNode.getProperty(VOTING_RATE_PROP).getLong());
                } else {
                    node.setProperty(VOTING_RATE_PROP, 0L);
                }
                if (selectedLangNode.hasProperty(VOTER_PROP)) {
                    node.setProperty(VOTER_PROP, selectedLangNode.getProperty(VOTER_PROP).getValues());
                }
            } else {
                node.setProperty(VOTE_TOTAL_PROP, this.getVoteTotal(node));
                node.setProperty(VOTE_TOTAL_LANG_PROP, 0L);
                node.setProperty(VOTING_RATE_PROP, 0L);
            }
        }
    }

    private void setCommentNode(Node node, Node newLang, Node selectedLangNode) throws Exception {
        if (node.hasNode("comments")) {
            node.getSession().move(node.getPath() + "/" + "comments", newLang.getPath() + "/" + "comments");
        }
        if (selectedLangNode != null && selectedLangNode.hasNode("comments")) {
            node.getSession().move(selectedLangNode.getPath() + "/" + "comments", node.getPath() + "/" + "comments");
        }
    }

    private long getVoteTotal(Node node) throws Exception {
        long voteTotal = 0L;
        if (!node.hasNode("languages") && node.hasProperty(VOTE_TOTAL_PROP)) {
            return node.getProperty(VOTE_TOTAL_LANG_PROP).getLong();
        }
        Node multiLanguages = node.getNode("languages");
        if (node.hasProperty(VOTE_TOTAL_LANG_PROP)) {
            voteTotal = node.getProperty(VOTE_TOTAL_LANG_PROP).getLong();
        }
        NodeIterator nodeIter = multiLanguages.getNodes();
        String defaultLang = this.getDefault(node);
        while (nodeIter.hasNext()) {
            Node jcrContentNode;
            Node languageNode = nodeIter.nextNode();
            if (node.getPrimaryNodeType().getName().equals(NTFILE) && !(jcrContentNode = node.getNode(JCRCONTENT)).getProperty(JCR_MIMETYPE).getString().startsWith("text")) {
                languageNode = this.getFileLangNode(languageNode);
            }
            if (languageNode.getName().equals(defaultLang) || !languageNode.hasProperty(VOTE_TOTAL_LANG_PROP)) continue;
            voteTotal += languageNode.getProperty(VOTE_TOTAL_LANG_PROP).getLong();
        }
        return voteTotal;
    }

    private boolean hasMixin(Node node, String nodeTypeName) throws Exception {
        NodeType[] mixinTypes;
        for (NodeType nodeType : mixinTypes = node.getMixinNodeTypes()) {
            if (!nodeType.getName().equals(nodeTypeName)) continue;
            return true;
        }
        return false;
    }

    private boolean canCopy(NodeType mixin) {
        String name = mixin.getName();
        return !name.equals("exo:actionable") && !name.equals("mix:versionable");
    }

    private void setPropertyLanguage(Node node, Node newLanguageNode, Map mappings, boolean isDefault, String defaultLanguage, String language) throws Exception {
        PropertyDefinition[] properties;
        for (PropertyDefinition pro : properties = node.getPrimaryNodeType().getPropertyDefinitions()) {
            if (pro.isProtected()) continue;
            String propertyName = pro.getName();
            JcrInputProperty property = (JcrInputProperty)mappings.get(NODE + propertyName);
            if (defaultLanguage.equals(language) && property != null) {
                this.setPropertyValue(propertyName, node, pro.getRequiredType(), property.getValue(), pro.isMultiple());
                continue;
            }
            if (isDefault) {
                if (node.hasProperty(propertyName)) {
                    Value value = null;
                    int requiredType = node.getProperty(propertyName).getDefinition().getRequiredType();
                    boolean isMultiple = node.getProperty(propertyName).getDefinition().isMultiple();
                    value = isMultiple ? node.getProperty(propertyName).getValues() : node.getProperty(propertyName).getValue();
                    this.setPropertyValue(propertyName, newLanguageNode, requiredType, value, isMultiple);
                }
                if (property == null) continue;
                this.setPropertyValue(propertyName, node, pro.getRequiredType(), property.getValue(), pro.isMultiple());
                continue;
            }
            if (property == null) continue;
            this.setPropertyValue(propertyName, newLanguageNode, pro.getRequiredType(), property.getValue(), pro.isMultiple());
        }
        if (!defaultLanguage.equals(language) && isDefault) {
            Node selectedLangNode = null;
            Node languagesNode = node.getNode("languages");
            if (languagesNode.hasNode(language)) {
                selectedLangNode = languagesNode.getNode(language);
            }
            this.setVoteProperty(newLanguageNode, node, selectedLangNode);
            this.setCommentNode(node, newLanguageNode, selectedLangNode);
        }
        if (isDefault) {
            node.setProperty("exo:language", language);
        }
        node.save();
        node.getSession().save();
    }

    @Override
    public void setDefault(Node node, String language, String repositoryName) throws Exception {
        String defaultLanguage = this.getDefault(node);
        String nodeTypeName = node.getPrimaryNodeType().getName();
        if (!defaultLanguage.equals(language)) {
            PropertyDefinition[] properties;
            Node languagesNode;
            block22: {
                languagesNode = null;
                try {
                    languagesNode = node.getNode("languages");
                }
                catch (PathNotFoundException pe) {
                    languagesNode = node.addNode("languages", NTUNSTRUCTURED);
                    if (!languagesNode.canAddMixin("exo:hiddenable")) break block22;
                    languagesNode.addMixin("exo:hiddenable");
                }
            }
            Node selectedLangNode = languagesNode.getNode(language);
            Node newLang = null;
            if (nodeTypeName.equals(NTFILE)) {
                Node jcrContentNode = node.getNode(JCRCONTENT);
                if (!jcrContentNode.getProperty(JCR_MIMETYPE).getString().startsWith("text")) {
                    newLang = languagesNode.addNode(defaultLanguage);
                    selectedLangNode = this.getFileLangNode(selectedLangNode);
                    newLang = this.addNewFileNode(node.getName(), newLang, jcrContentNode.getProperty(JCRDATA).getValue(), new GregorianCalendar(), jcrContentNode.getProperty(JCR_MIMETYPE).getString(), repositoryName);
                    Node newJcrContent = newLang.getNode(JCRCONTENT);
                    newJcrContent.setProperty(JCRDATA, jcrContentNode.getProperty(JCRDATA).getValue());
                    newJcrContent.setProperty(JCR_MIMETYPE, jcrContentNode.getProperty(JCR_MIMETYPE).getString());
                } else {
                    newLang = languagesNode.addNode(defaultLanguage, nodeTypeName);
                }
            } else if (node.isNodeType(NTUNSTRUCTURED) || node.isNodeType(NTFOLDER)) {
                newLang = languagesNode.addNode(defaultLanguage);
                selectedLangNode = selectedLangNode.getNode(node.getName());
                newLang = newLang.addNode(node.getName(), nodeTypeName);
            } else {
                newLang = languagesNode.addNode(defaultLanguage, nodeTypeName);
            }
            for (PropertyDefinition pro : properties = node.getPrimaryNodeType().getPropertyDefinitions()) {
                Value[] values;
                if (pro.isProtected()) continue;
                String propertyName = pro.getName();
                if (node.hasProperty(propertyName)) {
                    if (node.getProperty(propertyName).getDefinition().isMultiple()) {
                        values = node.getProperty(propertyName).getValues();
                        newLang.setProperty(propertyName, values);
                    } else {
                        newLang.setProperty(propertyName, node.getProperty(propertyName).getValue());
                    }
                }
                if (!selectedLangNode.hasProperty(propertyName)) continue;
                if (selectedLangNode.getProperty(propertyName).getDefinition().isMultiple()) {
                    values = selectedLangNode.getProperty(propertyName).getValues();
                    node.setProperty(propertyName, values);
                    continue;
                }
                node.setProperty(propertyName, selectedLangNode.getProperty(propertyName).getValue());
            }
            this.setMixin(node, newLang);
            if (nodeTypeName.equals(NTFILE)) {
                Node tempNode = node.addNode(TEMP_NODE, NTUNSTRUCTURED);
                node.getSession().move(node.getNode(JCRCONTENT).getPath(), tempNode.getPath() + "/" + JCRCONTENT);
                node.getSession().move(selectedLangNode.getNode(JCRCONTENT).getPath(), node.getPath() + "/" + JCRCONTENT);
                if (node.getNode(JCRCONTENT).getProperty(JCR_MIMETYPE).getString().startsWith("text")) {
                    node.getSession().move(tempNode.getPath() + "/" + JCRCONTENT, newLang.getPath() + "/" + JCRCONTENT);
                }
                tempNode.remove();
            } else if (node.isNodeType(NTUNSTRUCTURED) || node.isNodeType(NTFOLDER)) {
                this.processFolderNode(node, selectedLangNode, newLang);
            } else if (this.hasNodeTypeNTResource(node)) {
                this.processWithDataChildNode(node, selectedLangNode, languagesNode, defaultLanguage, this.getChildNodeType(node));
            }
            this.setVoteProperty(newLang, node, selectedLangNode);
            node.setProperty("exo:language", language);
            this.setCommentNode(node, newLang, selectedLangNode);
            if (nodeTypeName.equals(NTFILE) || node.isNodeType(NTUNSTRUCTURED) || node.isNodeType(NTFOLDER)) {
                languagesNode.getNode(language).remove();
            } else {
                selectedLangNode.remove();
            }
            node.save();
            node.getSession().save();
        }
    }

    private void processFolderNode(Node node, Node selectedLangNode, Node newLang) throws RepositoryException {
        NodeIterator nodeIter = node.getNodes();
        while (nodeIter.hasNext()) {
            Node child = nodeIter.nextNode();
            if (child.getName().equals("languages") || node.getSession().itemExists(newLang.getPath() + "/" + child.getName())) continue;
            node.getSession().move(child.getPath(), newLang.getPath() + "/" + child.getName());
        }
        NodeIterator selectedIter = selectedLangNode.getNodes();
        while (selectedIter.hasNext()) {
            Node child = selectedIter.nextNode();
            if (node.getSession().itemExists(node.getPath() + "/" + child.getName())) continue;
            node.getSession().move(child.getPath(), node.getPath() + "/" + child.getName());
        }
    }

    private void processFolderNode(Node node, Node newLang) throws RepositoryException {
        NodeIterator nodeIter = node.getNodes();
        Node tempNode = newLang.addNode(TEMP_NODE, NTUNSTRUCTURED);
        Node selectedLangNode = newLang.getNode(node.getName());
        while (nodeIter.hasNext()) {
            Node child = nodeIter.nextNode();
            if (child.getName().equals("languages") || node.getSession().itemExists(tempNode.getPath() + "/" + child.getName())) continue;
            node.getSession().move(child.getPath(), tempNode.getPath() + "/" + child.getName());
        }
        NodeIterator selectedIter = selectedLangNode.getNodes();
        while (selectedIter.hasNext()) {
            Node child = selectedIter.nextNode();
            node.getSession().move(child.getPath(), node.getPath() + "/" + child.getName());
        }
        NodeIterator tempIter = tempNode.getNodes();
        while (tempIter.hasNext()) {
            Node child = tempIter.nextNode();
            if (node.getSession().itemExists(selectedLangNode.getPath() + "/" + child.getName())) continue;
            node.getSession().move(child.getPath(), selectedLangNode.getPath() + "/" + child.getName());
        }
        tempNode.remove();
    }

    private void processWithDataChildNode(Node node, Node selectedLangNode, Node languagesNode, String defaultLanguage, String nodeType) throws Exception {
        Node tempNode = node.addNode(TEMP_NODE, NTUNSTRUCTURED);
        if (!node.getSession().itemExists(tempNode.getPath() + "/" + nodeType)) {
            node.getSession().move(node.getNode(nodeType).getPath(), tempNode.getPath() + "/" + nodeType);
        }
        if (!node.getSession().itemExists(node.getPath() + "/" + nodeType)) {
            node.getSession().move(selectedLangNode.getNode(nodeType).getPath(), node.getPath() + "/" + nodeType);
        }
        if (!node.getSession().itemExists(languagesNode.getPath() + "/" + defaultLanguage + "/" + nodeType)) {
            node.getSession().move(tempNode.getNode(nodeType).getPath(), languagesNode.getPath() + "/" + defaultLanguage + "/" + nodeType);
        }
        tempNode.remove();
    }

    private boolean hasNodeTypeNTResource(Node node) throws Exception {
        if (node.hasNodes()) {
            NodeIterator nodeIter = node.getNodes();
            while (nodeIter.hasNext()) {
                Node childNode = nodeIter.nextNode();
                if (!childNode.getPrimaryNodeType().getName().equals("nt:resource")) continue;
                return true;
            }
        }
        return false;
    }

    private String getChildNodeType(Node node) throws Exception {
        if (node.hasNodes()) {
            NodeIterator nodeIter = node.getNodes();
            while (nodeIter.hasNext()) {
                Node childNode = nodeIter.nextNode();
                if (!childNode.getPrimaryNodeType().getName().equals("nt:resource")) continue;
                return childNode.getName();
            }
        }
        return null;
    }

    @Override
    public Node getLanguage(Node node, String language) throws Exception {
        if (node.hasNode("languages/" + language)) {
            Node target = node.getNode("languages/" + language);
            if (target.isNodeType("exo:symlink")) {
                LinkManager linkManager = (LinkManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(LinkManager.class);
                target = linkManager.getTarget(target);
            }
            return target;
        }
        if (language.contains(COUNTRY_VARIANT)) {
            String pureLanguage = language.substring(0, language.indexOf(COUNTRY_VARIANT));
            if (node.hasNode("languages/" + pureLanguage)) {
                Node target = node.getNode("languages/" + pureLanguage);
                if (target.isNodeType("exo:symlink")) {
                    LinkManager linkManager = (LinkManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(LinkManager.class);
                    target = linkManager.getTarget(target);
                }
                return target;
            }
        }
        return null;
    }

    @Override
    public void addFolderLanguage(Node node, Map inputs, String language, boolean isDefault, String nodeType, String repositoryName) throws Exception {
        Node newLanguageNode = null;
        Node languagesNode = null;
        String defaultLanguage = this.getDefault(node);
        boolean isAddNew = false;
        if (node.hasNode("languages")) {
            languagesNode = node.getNode("languages");
        } else {
            languagesNode = node.addNode("languages", NTUNSTRUCTURED);
            if (languagesNode.canAddMixin("exo:hiddenable")) {
                languagesNode.addMixin("exo:hiddenable");
            }
        }
        if (!defaultLanguage.equals(language)) {
            String addedLange = language;
            if (isDefault) {
                addedLange = defaultLanguage;
            }
            try {
                isAddNew = false;
                newLanguageNode = languagesNode.getNode(addedLange);
            }
            catch (PathNotFoundException e) {
                isAddNew = true;
                newLanguageNode = languagesNode.addNode(addedLange);
            }
        }
        String nodePath = this.cmsService_.storeNode(nodeType, newLanguageNode, inputs, isAddNew);
        Node selectedNode = (Node)node.getSession().getItem(nodePath);
        if (isAddNew) {
            this.setMixin(node, selectedNode, false);
            selectedNode.setProperty("exo:language", language);
        }
        this.setPropertyLanguage(node, selectedNode, inputs, isDefault, defaultLanguage, language);
        if (isDefault) {
            this.processFolderNode(node, newLanguageNode);
        }
        node.getSession().save();
        if (isDefault && languagesNode.hasNode(language)) {
            languagesNode.getNode(language).remove();
        }
        languagesNode.save();
    }
}

