/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.workflow.webui.component.validator;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

public class PositiveNumberValidator
implements Validator {
    public void validate(UIFormInput uiInput) throws Exception {
        String inputValue = (String)uiInput.getValue();
        if (StringUtils.isNotBlank((String)inputValue)) {
            boolean isValid = true;
            Double inputNumber = 0.0;
            try {
                inputNumber = Double.parseDouble(inputValue);
                if (inputNumber <= 0.0) {
                    isValid = false;
                }
            }
            catch (NumberFormatException e) {
                isValid = false;
            }
            if (!isValid) {
                Object[] args = new Object[]{uiInput.getName(), inputValue};
                throw new MessageException(new ApplicationMessage("PositiveNumberValidator.msg.invalid-input", args, 1));
            }
        }
    }
}

