/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import org.hsqldb.jdbc.Util;

public abstract class BaseConnectionWrapper
implements Connection {
    protected boolean isClosed = false;

    protected abstract Connection getConnection();

    protected void validate() throws SQLException {
        if (this.isClosed) {
            throw Util.connectionClosedException();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.validate();
        return this.getConnection().getHoldability();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.validate();
        return this.getConnection().getTransactionIsolation();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.validate();
        this.getConnection().clearWarnings();
    }

    @Override
    public void commit() throws SQLException {
        this.validate();
        this.getConnection().commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.validate();
        this.getConnection().rollback();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.getConnection().getAutoCommit();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.validate();
        return this.getConnection().isReadOnly();
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        this.validate();
        this.getConnection().setHoldability(n);
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        this.validate();
        this.getConnection().setTransactionIsolation(n);
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.validate();
        this.getConnection().setAutoCommit(bl);
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        this.validate();
        this.getConnection().setReadOnly(bl);
    }

    @Override
    public String getCatalog() throws SQLException {
        this.validate();
        return this.getConnection().getCatalog();
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        this.validate();
        this.getConnection().setCatalog(string);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.validate();
        return this.getConnection().getMetaData();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.validate();
        return this.getConnection().getWarnings();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.validate();
        return this.getConnection().setSavepoint();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.validate();
        this.getConnection().releaseSavepoint(savepoint);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.validate();
        this.getConnection().rollback(savepoint);
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.validate();
        return this.getConnection().createStatement();
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        this.validate();
        return this.getConnection().createStatement(n, n2);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.validate();
        return this.getConnection().createStatement(n, n2, n3);
    }

    public Map getTypeMap() throws SQLException {
        this.validate();
        return this.getConnection().getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.validate();
        this.getConnection().setTypeMap(map);
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        this.validate();
        return this.getConnection().nativeSQL(string);
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        this.validate();
        return this.getConnection().prepareCall(string);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.validate();
        return this.getConnection().prepareCall(string, n, n2);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.validate();
        return this.getConnection().prepareCall(string, n, n2, n3);
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.validate();
        return this.getConnection().prepareStatement(string);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.validate();
        return this.getConnection().prepareStatement(string, n);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.validate();
        return this.getConnection().prepareStatement(string, n, n2);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.validate();
        return this.getConnection().prepareStatement(string, n, n2, n3);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.validate();
        return this.getConnection().prepareStatement(string, nArray);
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        this.validate();
        return this.getConnection().setSavepoint(string);
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.validate();
        return this.getConnection().prepareStatement(string, stringArray);
    }

    @Override
    public Clob createClob() throws SQLException {
        this.validate();
        return this.getConnection().createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.validate();
        return this.getConnection().createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.validate();
        return this.getConnection().createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.validate();
        return this.getConnection().createSQLXML();
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        this.validate();
        return this.getConnection().isValid(n);
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        try {
            this.validate();
        }
        catch (SQLException sQLException) {
            throw new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), null, sQLException);
        }
        this.getConnection().setClientInfo(string, string2);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.validate();
        }
        catch (SQLException sQLException) {
            throw new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), null, sQLException);
        }
        this.getConnection().setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        this.validate();
        return this.getConnection().getClientInfo(string);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.validate();
        return this.getConnection().getClientInfo();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        this.validate();
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw Util.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        this.validate();
        return this.getConnection().createArrayOf(string, objectArray);
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        this.validate();
        return this.getConnection().createStruct(string, objectArray);
    }
}

