/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.registry;

import com.install4j.api.actions.AbstractInstallAction;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.registry.PreferenceWriteType;
import com.install4j.runtime.beans.actions.registry.PreferencesAction;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class SetPreferenceKeyAction
extends PreferencesAction {
    private String value = "";
    private PreferenceWriteType preferenceWriteType = PreferenceWriteType.USER;

    public String getValue() {
        return SetPreferenceKeyAction.replaceVariables(this.value);
    }

    public void setValue(String string) {
        this.value = string;
    }

    public PreferenceWriteType getPreferenceWriteType() {
        return this.preferenceWriteType;
    }

    public void setPreferenceWriteType(PreferenceWriteType preferenceWriteType) {
        this.preferenceWriteType = preferenceWriteType;
    }

    protected boolean execute(Context context) throws UserCanceledException {
        if (this.getKey().trim().length() == 0) {
            return false;
        }
        Preferences preferences = this.getPackageNode(this.preferenceWriteType == PreferenceWriteType.USER);
        try {
            this.writeValue(preferences);
        }
        catch (BackingStoreException backingStoreException) {
            if (this.preferenceWriteType == PreferenceWriteType.SYSTEM_FALLBACK) {
                preferences = this.getPackageNode(true);
                try {
                    this.writeValue(preferences);
                }
                catch (BackingStoreException backingStoreException2) {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    private void writeValue(Preferences preferences) throws BackingStoreException {
        String string = preferences.get(this.getKey(), null);
        preferences.put(this.getKey(), this.getValue());
        preferences.flush();
        this.addRollbackAction(new PerformedAction(preferences, string));
    }

    private class PerformedAction
    extends AbstractInstallAction {
        private Preferences packageNode;
        private String key;
        private String oldValue;

        public PerformedAction(Preferences preferences, String string) {
            this.packageNode = preferences;
            this.oldValue = string;
            this.key = SetPreferenceKeyAction.this.getKey();
        }

        public void rollback(InstallerContext installerContext) {
            Preferences preferences = PreferencesAction.getPackageNode(this.packageNode.isUserNode(), this.packageNode.absolutePath());
            if (this.oldValue == null) {
                preferences.remove(this.key);
            } else {
                preferences.put(this.key, this.oldValue);
            }
            try {
                preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {
                backingStoreException.printStackTrace();
            }
        }

        public boolean install(InstallerContext installerContext) throws UserCanceledException {
            throw new UnsupportedOperationException();
        }
    }
}

