/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.spring.remoting;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.mgt.SecurityManager;
import org.jsecurity.session.Session;
import org.jsecurity.spring.remoting.SecureRemoteInvocationFactory;
import org.jsecurity.subject.DelegatingSubject;
import org.jsecurity.subject.PrincipalCollection;
import org.jsecurity.util.ThreadContext;
import org.jsecurity.web.DefaultWebSecurityManager;
import org.springframework.remoting.support.DefaultRemoteInvocationExecutor;
import org.springframework.remoting.support.RemoteInvocation;

public class SecureRemoteInvocationExecutor
extends DefaultRemoteInvocationExecutor {
    private static final Log log = LogFactory.getLog(SecureRemoteInvocationExecutor.class);
    private SecurityManager securityManager;

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    protected InetAddress getInetAddress(RemoteInvocation invocation, Object targetObject) {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    protected PrincipalCollection getPrincipals(RemoteInvocation invocation, Object targetObject, Session session) {
        return (PrincipalCollection)session.getAttribute(DefaultWebSecurityManager.PRINCIPALS_SESSION_KEY);
    }

    protected boolean isAuthenticated(RemoteInvocation invocation, Object targetObject, Session session, PrincipalCollection principals) {
        if (principals != null) {
            Boolean authc = (Boolean)session.getAttribute(DefaultWebSecurityManager.AUTHENTICATED_SESSION_KEY);
            return authc != null && authc != false;
        }
        return false;
    }

    public Object invoke(RemoteInvocation invocation, Object targetObject) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        try {
            PrincipalCollection principals = null;
            boolean authenticated = false;
            InetAddress inetAddress = this.getInetAddress(invocation, targetObject);
            Session session = null;
            Serializable sessionId = invocation.getAttribute(SecureRemoteInvocationFactory.SESSION_ID_KEY);
            if (sessionId != null) {
                session = this.securityManager.getSession(sessionId);
                principals = this.getPrincipals(invocation, targetObject, session);
                authenticated = this.isAuthenticated(invocation, targetObject, session, principals);
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("RemoteInvocation object did not contain a JSecurity Session id under attribute name [" + SecureRemoteInvocationFactory.SESSION_ID_KEY + "].  A Session will not " + "be available to the method.  Ensure that clients are using a " + "SecureRemoteInvocationFactory to prevent this problem."));
            }
            DelegatingSubject subject = new DelegatingSubject(principals, authenticated, inetAddress, session, this.securityManager);
            ThreadContext.bind(this.securityManager);
            ThreadContext.bind(subject);
            Object object = super.invoke(invocation, targetObject);
            return object;
        }
        catch (NoSuchMethodException nsme) {
            throw nsme;
        }
        catch (IllegalAccessException iae) {
            throw iae;
        }
        catch (InvocationTargetException ite) {
            throw ite;
        }
        catch (Throwable t) {
            throw new InvocationTargetException(t);
        }
        finally {
            ThreadContext.clear();
        }
    }
}

