/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.IdentitySearchCriteriaImpl;
import org.picketlink.idm.impl.api.session.managers.RoleManagerImpl;
import org.picketlink.idm.impl.repository.AbstractIdentityStoreRepository;
import org.picketlink.idm.impl.repository.RepositoryIdentityStoreSessionImpl;
import org.picketlink.idm.impl.store.SimpleIdentityStoreInvocationContext;
import org.picketlink.idm.impl.types.SimpleIdentityObject;
import org.picketlink.idm.spi.configuration.IdentityRepositoryConfigurationContext;
import org.picketlink.idm.spi.configuration.IdentityStoreConfigurationContext;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectAttributeMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityRepositoryConfigurationMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityStoreMappingMetaData;
import org.picketlink.idm.spi.exception.OperationNotSupportedException;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectAttribute;
import org.picketlink.idm.spi.model.IdentityObjectCredential;
import org.picketlink.idm.spi.model.IdentityObjectCredentialType;
import org.picketlink.idm.spi.model.IdentityObjectRelationship;
import org.picketlink.idm.spi.model.IdentityObjectRelationshipType;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.search.IdentityObjectSearchCriteria;
import org.picketlink.idm.spi.store.AttributeStore;
import org.picketlink.idm.spi.store.FeaturesMetaData;
import org.picketlink.idm.spi.store.IdentityObjectSearchCriteriaType;
import org.picketlink.idm.spi.store.IdentityStore;
import org.picketlink.idm.spi.store.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.store.IdentityStoreSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FallbackIdentityStoreRepository
extends AbstractIdentityStoreRepository {
    private static Logger log = Logger.getLogger(FallbackIdentityStoreRepository.class.getName());
    public static final String OPTION_READ_ONLY = "readOnly";
    private final String id;
    private IdentityRepositoryConfigurationMetaData configurationMD;
    public static final String ALLOW_NOT_DEFINED_ATTRIBUTES = "allowNotDefinedAttributes";
    private FeaturesMetaData featuresMetaData;
    private boolean allowNotDefinedAttributes = false;
    private final Set<IdentityStore> configuredIdentityStores = new HashSet<IdentityStore>();

    public FallbackIdentityStoreRepository(String id) {
        this.id = id;
    }

    @Override
    public void bootstrap(IdentityRepositoryConfigurationContext configurationContext, Map<String, IdentityStore> bootstrappedIdentityStores, Map<String, AttributeStore> bootstrappedAttributeStores) throws IdentityException {
        String allowNotDefineAttributes;
        super.bootstrap(configurationContext, bootstrappedIdentityStores, bootstrappedAttributeStores);
        if (this.getIdentityStoreMappings().size() > 0) {
            this.configuredIdentityStores.addAll(this.getIdentityStoreMappings().values());
        }
        this.configurationMD = configurationContext.getRepositoryConfigurationMetaData();
        String isId = this.configurationMD.getDefaultIdentityStoreId();
        if (isId != null && bootstrappedIdentityStores.keySet().contains(isId) && !this.getIdentityStoreMappings().keySet().contains(this.defaultIdentityStore.getId())) {
            this.configuredIdentityStores.add(this.defaultIdentityStore);
        }
        if ((allowNotDefineAttributes = this.configurationMD.getOptionSingleValue(ALLOW_NOT_DEFINED_ATTRIBUTES)) != null && allowNotDefineAttributes.equalsIgnoreCase("true")) {
            this.allowNotDefinedAttributes = true;
        }
        this.featuresMetaData = new FeaturesMetaData(){

            public boolean isNamedRelationshipsSupported() {
                for (IdentityStore identityStore : FallbackIdentityStoreRepository.this.getIdentityStoreMappings().values()) {
                    if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported()) continue;
                    return true;
                }
                return FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().isNamedRelationshipsSupported();
            }

            public boolean isRelationshipPropertiesSupported() {
                for (IdentityStore identityStore : FallbackIdentityStoreRepository.this.getIdentityStoreMappings().values()) {
                    if (!identityStore.getSupportedFeatures().isRelationshipPropertiesSupported()) continue;
                    return true;
                }
                return FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().isRelationshipPropertiesSupported();
            }

            public boolean isSearchCriteriaTypeSupported(IdentityObjectType identityObjectType, IdentityObjectSearchCriteriaType storeSearchConstraint) {
                return FallbackIdentityStoreRepository.this.resolveIdentityStore(identityObjectType).getSupportedFeatures().isSearchCriteriaTypeSupported(identityObjectType, storeSearchConstraint);
            }

            public Set<String> getSupportedIdentityObjectTypes() {
                HashSet<String> supportedIOTs = new HashSet<String>();
                for (IdentityStore identityStore : FallbackIdentityStoreRepository.this.getIdentityStoreMappings().values()) {
                    supportedIOTs.addAll(identityStore.getSupportedFeatures().getSupportedIdentityObjectTypes());
                }
                supportedIOTs.addAll(FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().getSupportedRelationshipTypes());
                return supportedIOTs;
            }

            public boolean isIdentityObjectTypeSupported(IdentityObjectType identityObjectType) {
                return FallbackIdentityStoreRepository.this.resolveIdentityStore(identityObjectType).getSupportedFeatures().isIdentityObjectTypeSupported(identityObjectType);
            }

            public boolean isRelationshipTypeSupported(IdentityObjectType fromType, IdentityObjectType toType, IdentityObjectRelationshipType relationshipType) throws IdentityException {
                IdentityStore toStore;
                IdentityStore fromStore = FallbackIdentityStoreRepository.this.resolveIdentityStore(fromType);
                if (fromStore == (toStore = FallbackIdentityStoreRepository.this.resolveIdentityStore(toType))) {
                    return fromStore.getSupportedFeatures().isRelationshipTypeSupported(fromType, toType, relationshipType);
                }
                return FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().isRelationshipTypeSupported(fromType, toType, relationshipType);
            }

            public Set<String> getSupportedRelationshipTypes() {
                HashSet<String> supportedRelTypes = new HashSet<String>();
                for (IdentityStore identityStore : FallbackIdentityStoreRepository.this.getIdentityStoreMappings().values()) {
                    supportedRelTypes.addAll(identityStore.getSupportedFeatures().getSupportedRelationshipTypes());
                }
                supportedRelTypes.addAll(FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().getSupportedRelationshipTypes());
                return supportedRelTypes;
            }

            public boolean isCredentialSupported(IdentityObjectType identityObjectType, IdentityObjectCredentialType credentialType) {
                return FallbackIdentityStoreRepository.this.resolveIdentityStore(identityObjectType).getSupportedFeatures().isCredentialSupported(identityObjectType, credentialType);
            }

            public boolean isIdentityObjectAddRemoveSupported(IdentityObjectType objectType) {
                return FallbackIdentityStoreRepository.this.resolveIdentityStore(objectType).getSupportedFeatures().isIdentityObjectAddRemoveSupported(objectType);
            }

            public boolean isRelationshipNameAddRemoveSupported() {
                for (IdentityStore identityStore : FallbackIdentityStoreRepository.this.getIdentityStoreMappings().values()) {
                    if (!identityStore.getSupportedFeatures().isRelationshipNameAddRemoveSupported()) continue;
                    return true;
                }
                return FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().isRelationshipNameAddRemoveSupported();
            }

            public boolean isRoleNameSearchCriteriaTypeSupported(IdentityObjectSearchCriteriaType constraint) {
                for (IdentityStore identityStore : FallbackIdentityStoreRepository.this.getIdentityStoreMappings().values()) {
                    if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported() || !identityStore.getSupportedFeatures().isRoleNameSearchCriteriaTypeSupported(constraint)) continue;
                    return true;
                }
                return FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().isNamedRelationshipsSupported() && FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().isRoleNameSearchCriteriaTypeSupported(constraint);
            }
        };
    }

    public void bootstrap(IdentityStoreConfigurationContext configurationContext) throws IdentityException {
    }

    public IdentityStoreSession createIdentityStoreSession() throws IdentityException {
        HashMap<String, IdentityStoreSession> sessions = new HashMap<String, IdentityStoreSession>();
        for (IdentityStore identityStore : this.configuredIdentityStores) {
            sessions.put(identityStore.getId(), identityStore.createIdentityStoreSession());
        }
        for (IdentityStore attributeStore : this.configuredIdentityStores) {
            if (sessions.containsKey(attributeStore.getId())) continue;
            sessions.put(attributeStore.getId(), attributeStore.createIdentityStoreSession());
        }
        if (!sessions.containsKey(this.defaultAttributeStore.getId())) {
            sessions.put(this.defaultAttributeStore.getId(), this.defaultAttributeStore.createIdentityStoreSession());
        }
        if (!sessions.containsKey(this.defaultIdentityStore.getId())) {
            sessions.put(this.defaultIdentityStore.getId(), this.defaultIdentityStore.createIdentityStoreSession());
        }
        return new RepositoryIdentityStoreSessionImpl(sessions);
    }

    public IdentityStoreSession createIdentityStoreSession(Map<String, Object> sessionOptions) throws IdentityException {
        HashMap<String, IdentityStoreSession> sessions = new HashMap<String, IdentityStoreSession>();
        for (IdentityStore identityStore : this.configuredIdentityStores) {
            sessions.put(identityStore.getId(), identityStore.createIdentityStoreSession(sessionOptions));
        }
        for (IdentityStore attributeStore : this.configuredIdentityStores) {
            if (sessions.containsKey(attributeStore.getId())) continue;
            sessions.put(attributeStore.getId(), attributeStore.createIdentityStoreSession(sessionOptions));
        }
        if (!sessions.containsKey(this.defaultAttributeStore.getId())) {
            sessions.put(this.defaultAttributeStore.getId(), this.defaultAttributeStore.createIdentityStoreSession(sessionOptions));
        }
        if (!sessions.containsKey(this.defaultIdentityStore.getId())) {
            sessions.put(this.defaultIdentityStore.getId(), this.defaultIdentityStore.createIdentityStoreSession(sessionOptions));
        }
        return new RepositoryIdentityStoreSessionImpl(sessions);
    }

    public String getId() {
        return this.id;
    }

    public FeaturesMetaData getSupportedFeatures() {
        return this.featuresMetaData;
    }

    IdentityStore resolveIdentityStore(IdentityObject io) throws IdentityException {
        return this.resolveIdentityStore(io.getIdentityType());
    }

    IdentityStore resolveFirstIdentityStoreWithIO(IdentityObject io, IdentityStoreInvocationContext ic) throws IdentityException {
        List<IdentityStore> mappedStores = this.resolveIdentityStores(io.getIdentityType());
        for (IdentityStore mappedStore : mappedStores) {
            IdentityStoreInvocationContext mappedContext = this.resolveInvocationContext(mappedStore, ic);
            if (!this.hasIdentityObject(mappedContext, mappedStore, io)) continue;
            return mappedStore;
        }
        return null;
    }

    IdentityStore resolveIdentityStore(IdentityObjectType iot) {
        IdentityStore ids = null;
        try {
            ids = this.getIdentityStore(iot);
        }
        catch (IdentityException e) {
            if (this.isAllowNotDefinedAttributes()) {
                return this.defaultIdentityStore;
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IllegalStateException("Used IdentityObjectType not mapped. Consider using allowNotDefinedIdentityObjectTypes repository option switch: " + iot);
        }
        if (ids == null) {
            ids = this.defaultIdentityStore;
        }
        return ids;
    }

    List<IdentityStore> resolveIdentityStores(IdentityObjectType iot) {
        List<IdentityStore> ids = null;
        try {
            ids = this.getIdentityStores(iot);
        }
        catch (IdentityException e) {
            if (this.isAllowNotDefinedAttributes()) {
                ids = new LinkedList<IdentityStore>();
                ids.add(this.defaultIdentityStore);
                return ids;
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IllegalStateException("Used IdentityObjectType not mapped. Consider using allowNotDefinedIdentityObjectTypes repository option switch: " + iot);
        }
        if (ids == null || ids.size() == 0) {
            ids = new LinkedList<IdentityStore>();
            ids.add(this.defaultIdentityStore);
        }
        return ids;
    }

    AttributeStore resolveAttributeStore(IdentityObjectType iot) {
        AttributeStore ads = null;
        try {
            ads = this.getAttributeStore(iot);
        }
        catch (IdentityException e) {
            if (this.isAllowNotDefinedAttributes()) {
                return this.defaultAttributeStore;
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IllegalStateException("Used IdentityObjectType not mapped. Consider using allowNotDefinedIdentityObjectTypes repository option switch: " + iot);
        }
        if (ads == null) {
            ads = this.defaultAttributeStore;
        }
        return ads;
    }

    IdentityStoreInvocationContext resolveInvocationContext(IdentityStore targetStore, IdentityStoreInvocationContext invocationCtx) {
        return this.resolveInvocationContext(targetStore.getId(), invocationCtx);
    }

    IdentityStoreInvocationContext resolveInvocationContext(AttributeStore targetStore, IdentityStoreInvocationContext invocationCtx) {
        return this.resolveInvocationContext(targetStore.getId(), invocationCtx);
    }

    IdentityStoreInvocationContext resolveInvocationContext(String id, IdentityStoreInvocationContext invocationCtx) {
        RepositoryIdentityStoreSessionImpl repoSession = (RepositoryIdentityStoreSessionImpl)invocationCtx.getIdentityStoreSession();
        IdentityStoreSession targetSession = repoSession.getIdentityStoreSession(id);
        return new SimpleIdentityStoreInvocationContext(targetSession, invocationCtx.getRealmId(), String.valueOf(this.hashCode()));
    }

    public IdentityObject createIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType identityObjectType) throws IdentityException {
        IdentityStore targetStore = this.resolveIdentityStore(identityObjectType);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(targetStore, invocationCtx);
        IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCtx);
        SimpleIdentityObject mock = new SimpleIdentityObject(name, identityObjectType);
        if (targetStore != this.defaultIdentityStore && this.hasIdentityObject(defaultCtx, this.defaultIdentityStore, mock)) {
            return mock;
        }
        if (this.isIdentityStoreReadOnly(targetStore)) {
            targetStore = this.defaultIdentityStore;
            targetCtx = defaultCtx;
        }
        IdentityObject result = null;
        try {
            result = targetStore.createIdentityObject(targetCtx, name, identityObjectType);
        }
        catch (IdentityException e) {
            log.log(Level.SEVERE, "Failed to create IdentityObject: ", e);
        }
        return result;
    }

    public IdentityObject createIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType identityObjectType, Map<String, String[]> attributes) throws IdentityException {
        IdentityStore targetStore = this.resolveIdentityStore(identityObjectType);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(targetStore, invocationCtx);
        IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCtx);
        SimpleIdentityObject mock = new SimpleIdentityObject(name, identityObjectType);
        if (targetStore != this.defaultIdentityStore && this.hasIdentityObject(defaultCtx, this.defaultIdentityStore, mock)) {
            return mock;
        }
        if (this.isIdentityStoreReadOnly(targetStore)) {
            targetStore = this.defaultIdentityStore;
            targetCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCtx);
        }
        IdentityObject result = null;
        try {
            result = targetStore.createIdentityObject(targetCtx, name, identityObjectType, attributes);
        }
        catch (IdentityException e) {
            log.log(Level.SEVERE, "Failed to create IdentityObject: ", e);
        }
        return result;
    }

    public void removeIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObject identity) throws IdentityException {
        List<IdentityStore> targetStores = this.resolveIdentityStores(identity.getIdentityType());
        IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCtx);
        for (IdentityStore targetStore : targetStores) {
            IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(targetStore, invocationCtx);
            if (this.isIdentityStoreReadOnly(targetStore)) {
                targetStore = this.defaultIdentityStore;
                targetCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCtx);
            }
            try {
                if (!this.hasIdentityObject(targetCtx, targetStore, identity)) continue;
                targetStore.removeIdentityObject(targetCtx, identity);
            }
            catch (IdentityException e) {
                log.log(Level.SEVERE, "Failed to remove IdentityObject from target store: ", e);
            }
        }
        if (!targetStores.contains(this.defaultIdentityStore) && this.hasIdentityObject(defaultCtx, this.defaultIdentityStore, identity)) {
            try {
                this.defaultIdentityStore.removeIdentityObject(defaultCtx, identity);
            }
            catch (IdentityException e) {
                log.log(Level.SEVERE, "Failed to remove IdentityObject from default store: ", e);
            }
        }
    }

    public int getIdentityObjectsCount(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityType) throws IdentityException {
        List<IdentityStore> targetStores = this.resolveIdentityStores(identityType);
        int result = 0;
        if (!targetStores.contains(this.defaultIdentityStore)) {
            targetStores.add(this.defaultIdentityStore);
        }
        for (IdentityStore targetStore : targetStores) {
            IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(targetStore, invocationCtx);
            try {
                result += targetStore.getIdentityObjectsCount(targetCtx, identityType);
            }
            catch (IdentityException e) {
                log.log(Level.SEVERE, "Failed to obtain IdentityObject count from store " + targetStore.getId() + " : ", e);
            }
        }
        return result;
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext invocationContext, String name, IdentityObjectType identityObjectType) throws IdentityException {
        List<IdentityStore> targetStores = this.resolveIdentityStores(identityObjectType);
        IdentityObject io = null;
        for (IdentityStore targetStore : targetStores) {
            IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(targetStore, invocationContext);
            try {
                io = targetStore.findIdentityObject(targetCtx, name, identityObjectType);
            }
            catch (IdentityException e) {
                log.log(Level.SEVERE, "Failed to find IdentityObject in target store: ", e);
            }
            if (io == null) continue;
            return io;
        }
        try {
            io = this.defaultIdentityStore.findIdentityObject(this.resolveInvocationContext(this.defaultIdentityStore, invocationContext), name, identityObjectType);
        }
        catch (IdentityException e) {
            log.log(Level.SEVERE, "Failed to find IdentityObject in default store: ", e);
        }
        return io;
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext invocationContext, String id) throws IdentityException {
        for (IdentityStore identityStore : this.getIdentityStoreMappings().values()) {
            IdentityStoreInvocationContext targetCtx;
            IdentityObject io = identityStore.findIdentityObject(targetCtx = this.resolveInvocationContext(identityStore, invocationContext), id);
            if (io == null) continue;
            return io;
        }
        return this.defaultIdentityStore.findIdentityObject(invocationContext, id);
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityType, IdentityObjectSearchCriteria criteria) throws IdentityException {
        List<IdentityStore> targetStores = this.resolveIdentityStores(identityType);
        Collection<Object> results = new LinkedList();
        Collection defaultIOs = new LinkedList();
        if (targetStores.size() == 1 && targetStores.contains(this.defaultIdentityStore)) {
            Collection<Object> resx = new LinkedList<IdentityObject>();
            try {
                IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCtx);
                resx = this.defaultIdentityStore.findIdentityObject(targetCtx, identityType, criteria);
            }
            catch (IdentityException e) {
                log.log(Level.SEVERE, "Exception occurred: ", e);
            }
            return resx;
        }
        IdentitySearchCriteriaImpl c = null;
        if (criteria != null) {
            c = new IdentitySearchCriteriaImpl(criteria);
            c.setPaged(false);
        }
        if ((defaultIOs = this.defaultIdentityStore.findIdentityObject(this.resolveInvocationContext(this.defaultIdentityStore, invocationCtx), identityType, (IdentityObjectSearchCriteria)c)).size() == 0 && targetStores.size() == 1) {
            Collection<Object> resx = new LinkedList<IdentityObject>();
            try {
                IdentityStore targetStore = targetStores.get(0);
                IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(targetStore, invocationCtx);
                resx = targetStore.findIdentityObject(targetCtx, identityType, criteria);
            }
            catch (IdentityException e) {
                log.log(Level.SEVERE, "Exception occurred: ", e);
            }
            return resx;
        }
        for (IdentityStore targetStore : targetStores) {
            try {
                IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(targetStore, invocationCtx);
                results.addAll(targetStore.findIdentityObject(targetCtx, identityType, (IdentityObjectSearchCriteria)c));
            }
            catch (IdentityException e) {
                log.log(Level.SEVERE, "Exception occurred: ", e);
            }
        }
        HashSet merged = new HashSet();
        merged.addAll(results);
        merged.addAll(defaultIOs);
        if (criteria != null) {
            LinkedList<IdentityObject> processed = new LinkedList<IdentityObject>(merged);
            if (criteria.isSorted()) {
                this.sortByName(processed, criteria.isAscending());
            }
            results = processed;
            if (criteria.isPaged()) {
                results = this.cutPageFromResults(processed, criteria);
            }
        } else {
            results = merged;
        }
        return results;
    }

    public int getIdentityObjectCount(IdentityStoreInvocationContext invocationCxt, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        int count = 0;
        Set<IdentityStore> mappedStores = this.getConfiguredIdentityStores();
        if (!mappedStores.contains(this.defaultIdentityStore)) {
            mappedStores.add(this.defaultIdentityStore);
        }
        for (IdentityStore mappedStore : mappedStores) {
            IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(mappedStore, invocationCxt);
            count += mappedStore.getIdentityObjectCount(targetCtx, identity, relationshipType, parent, criteria);
        }
        return count;
    }

    public int getIdentityObjectCount(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, Collection<IdentityObjectType> excludes, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        int count = 0;
        Set<IdentityStore> mappedStores = this.getConfiguredIdentityStores();
        if (!mappedStores.contains(this.defaultIdentityStore)) {
            mappedStores.add(this.defaultIdentityStore);
        }
        for (IdentityStore mappedStore : mappedStores) {
            IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(mappedStore, ctx);
            count += mappedStore.getIdentityObjectCount(targetCtx, identity, relationshipType, excludes, parent, criteria);
        }
        return count;
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCxt, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        return this.findIdentityObject(invocationCxt, identity, relationshipType, null, parent, criteria);
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCxt, IdentityObject identity, IdentityObjectRelationshipType relationshipType, Collection<IdentityObjectType> excludes, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        try {
            List<IdentityStore> mappedStores = this.resolveIdentityStores(identity.getIdentityType());
            IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCxt);
            if (mappedStores.size() == 1 && mappedStores.contains(this.defaultIdentityStore)) {
                return this.defaultIdentityStore.findIdentityObject(defaultCtx, identity, relationshipType, parent, criteria);
            }
            IdentitySearchCriteriaImpl c = null;
            if (criteria != null) {
                c = new IdentitySearchCriteriaImpl(criteria);
                c.setPaged(false);
            }
            Collection<Object> results = new LinkedList<IdentityObject>();
            HashSet<IdentityObject> merged = new HashSet<IdentityObject>();
            for (IdentityStore mappedStore : mappedStores) {
                IdentityStoreInvocationContext mappedCtx = this.resolveInvocationContext(mappedStore, invocationCxt);
                if (!this.hasIdentityObject(mappedCtx, mappedStore, identity) || relationshipType != null && RoleManagerImpl.ROLE.getName().equals(relationshipType.getName()) && !mappedStore.getSupportedFeatures().isNamedRelationshipsSupported()) continue;
                if (this.hasIdentityObject(defaultCtx, this.defaultIdentityStore, identity)) {
                    results = mappedStore.findIdentityObject(mappedCtx, identity, relationshipType, parent, (IdentityObjectSearchCriteria)c);
                    merged.addAll(results);
                    continue;
                }
                if (mappedStores.size() != 1) continue;
                return mappedStore.findIdentityObject(mappedCtx, identity, relationshipType, parent, criteria);
            }
            Collection objects = this.defaultIdentityStore.findIdentityObject(defaultCtx, identity, relationshipType, parent, (IdentityObjectSearchCriteria)c);
            if (objects != null && objects.size() != 0) {
                merged.addAll(objects);
                if (criteria != null) {
                    LinkedList<IdentityObject> processed = new LinkedList<IdentityObject>(merged);
                    if (criteria.isSorted()) {
                        this.sortByName(processed, criteria.isAscending());
                    }
                    results = processed;
                    if (criteria.isPaged()) {
                        results = this.cutPageFromResults(processed, criteria);
                    }
                } else {
                    results = merged;
                }
            }
            return results;
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public IdentityObjectRelationship createRelationship(IdentityStoreInvocationContext invocationCxt, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String relationshipName, boolean createNames) throws IdentityException {
        try {
            IdentityStore fromStore = this.resolveFirstIdentityStoreWithIO(fromIdentity, invocationCxt);
            IdentityStore toStore = this.resolveFirstIdentityStoreWithIO(toIdentity, invocationCxt);
            IdentityStoreInvocationContext toTargetCtx = toStore != null ? this.resolveInvocationContext(toStore, invocationCxt) : null;
            IdentityStoreInvocationContext defaultTargetCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCxt);
            if (fromStore != null && toStore != null && fromStore == toStore && !this.isIdentityStoreReadOnly(fromStore) && (relationshipName == null || relationshipName != null && fromStore.getSupportedFeatures().isNamedRelationshipsSupported())) {
                return fromStore.createRelationship(toTargetCtx, fromIdentity, toIdentity, relationshipType, relationshipName, createNames);
            }
            if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, fromIdentity)) {
                this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, fromIdentity.getName(), fromIdentity.getIdentityType());
            }
            if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, toIdentity)) {
                this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, toIdentity.getName(), toIdentity.getIdentityType());
            }
            return this.defaultIdentityStore.createRelationship(defaultTargetCtx, fromIdentity, toIdentity, relationshipType, relationshipName, createNames);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public void removeRelationship(IdentityStoreInvocationContext invocationCxt, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String relationshipName) throws IdentityException {
        try {
            IdentityStore fromStore = this.resolveFirstIdentityStoreWithIO(fromIdentity, invocationCxt);
            IdentityStore toStore = this.resolveFirstIdentityStoreWithIO(toIdentity, invocationCxt);
            IdentityStoreInvocationContext toTargetCtx = toStore != null ? this.resolveInvocationContext(toStore, invocationCxt) : null;
            IdentityStoreInvocationContext defaultTargetCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCxt);
            if (fromStore != null && toStore != null && fromStore == toStore && !this.isIdentityStoreReadOnly(fromStore) && (relationshipName == null || relationshipName != null && fromStore.getSupportedFeatures().isNamedRelationshipsSupported())) {
                fromStore.removeRelationship(toTargetCtx, fromIdentity, toIdentity, relationshipType, relationshipName);
                return;
            }
            if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, fromIdentity)) {
                this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, fromIdentity.getName(), fromIdentity.getIdentityType());
            }
            if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, toIdentity)) {
                this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, toIdentity.getName(), toIdentity.getIdentityType());
            }
            Set rels = this.defaultIdentityStore.resolveRelationships(defaultTargetCtx, fromIdentity, toIdentity, relationshipType);
            for (IdentityObjectRelationship rel : rels) {
                if (rel.getName() != null && !rel.getName().equals(relationshipName)) continue;
                this.defaultIdentityStore.removeRelationship(defaultTargetCtx, fromIdentity, toIdentity, relationshipType, relationshipName);
            }
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public void removeRelationships(IdentityStoreInvocationContext invocationCtx, IdentityObject identity1, IdentityObject identity2, boolean named) throws IdentityException {
        try {
            IdentityStore fromStore = this.resolveFirstIdentityStoreWithIO(identity1, invocationCtx);
            IdentityStore toStore = this.resolveFirstIdentityStoreWithIO(identity2, invocationCtx);
            IdentityStoreInvocationContext toTargetCtx = toStore != null ? this.resolveInvocationContext(toStore, invocationCtx) : null;
            IdentityStoreInvocationContext defaultTargetCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCtx);
            if (fromStore != null && toStore != null && fromStore == toStore && !this.isIdentityStoreReadOnly(fromStore)) {
                fromStore.removeRelationships(toTargetCtx, identity1, identity2, named);
                return;
            }
            if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, identity1)) {
                this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, identity1.getName(), identity1.getIdentityType());
            }
            if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, identity2)) {
                this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, identity2.getName(), identity2.getIdentityType());
            }
            this.defaultIdentityStore.removeRelationships(defaultTargetCtx, identity1, identity2, named);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext invocationCxt, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType) throws IdentityException {
        try {
            IdentityStore fromStore = this.resolveFirstIdentityStoreWithIO(fromIdentity, invocationCxt);
            IdentityStore toStore = this.resolveFirstIdentityStoreWithIO(toIdentity, invocationCxt);
            IdentityStoreInvocationContext toTargetCtx = toStore != null ? this.resolveInvocationContext(toStore, invocationCxt) : null;
            IdentityStoreInvocationContext defaultTargetCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCxt);
            if (fromStore != null && toStore != null && fromStore == toStore && (!RoleManagerImpl.ROLE.getName().equals(relationshipType.getName()) || fromStore.getSupportedFeatures().isNamedRelationshipsSupported())) {
                return fromStore.resolveRelationships(toTargetCtx, fromIdentity, toIdentity, relationshipType);
            }
            if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, fromIdentity)) {
                this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, fromIdentity.getName(), fromIdentity.getIdentityType());
            }
            if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, toIdentity)) {
                this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, toIdentity.getName(), toIdentity.getIdentityType());
            }
            return this.defaultIdentityStore.resolveRelationships(defaultTargetCtx, fromIdentity, toIdentity, relationshipType);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public int getRelationshipsCount(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType type, boolean parent, boolean named, String name, IdentityObjectSearchCriteria searchCriteria) throws IdentityException {
        int count = 0;
        Set<IdentityStore> mappedStores = this.getConfiguredIdentityStores();
        for (IdentityStore mappedStore : mappedStores) {
            IdentityStoreInvocationContext storeCtx = this.resolveInvocationContext(mappedStore, ctx);
            if (!this.hasIdentityObject(storeCtx, mappedStore, identity)) continue;
            count += mappedStore.getRelationshipsCount(storeCtx, identity, type, parent, named, name, searchCriteria);
        }
        return count;
    }

    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, boolean named, String name, IdentityObjectSearchCriteria criteria) throws IdentityException {
        try {
            HashSet<IdentityObjectRelationship> relationships = new HashSet<IdentityObjectRelationship>();
            for (IdentityStore identityStore : this.configuredIdentityStores) {
                IdentityStoreInvocationContext storeCtx = this.resolveInvocationContext(identityStore, ctx);
                if (!this.hasIdentityObject(storeCtx, identityStore, identity)) continue;
                relationships.addAll(identityStore.resolveRelationships(storeCtx, identity, relationshipType, parent, named, name, criteria));
            }
            return relationships;
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public String createRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        try {
            for (IdentityStore identityStore : this.configuredIdentityStores) {
                if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported() || this.isIdentityStoreReadOnly(identityStore)) continue;
                IdentityStoreInvocationContext storeCtx = this.resolveInvocationContext(identityStore, ctx);
                identityStore.createRelationshipName(storeCtx, name);
            }
            return name;
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public String removeRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        try {
            for (IdentityStore identityStore : this.configuredIdentityStores) {
                if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported() || this.isIdentityStoreReadOnly(identityStore)) continue;
                IdentityStoreInvocationContext storeCtx = this.resolveInvocationContext(identityStore, ctx);
                identityStore.removeRelationshipName(storeCtx, name);
            }
            return name;
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObjectSearchCriteria criteria) throws IdentityException, OperationNotSupportedException {
        try {
            HashSet<String> results = new HashSet<String>();
            for (IdentityStore identityStore : this.configuredIdentityStores) {
                if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported()) continue;
                IdentityStoreInvocationContext storeCtx = this.resolveInvocationContext(identityStore, ctx);
                results.addAll(identityStore.getRelationshipNames(storeCtx, criteria));
            }
            return results;
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectSearchCriteria criteria) throws IdentityException, OperationNotSupportedException {
        try {
            IdentityStore toStore = this.resolveIdentityStore(identity);
            IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, ctx);
            if (toStore.getSupportedFeatures().isNamedRelationshipsSupported()) {
                return toStore.getRelationshipNames(targetCtx, identity, criteria);
            }
            IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultIdentityStore, ctx);
            return this.defaultIdentityStore.getRelationshipNames(defaultCtx, identity, criteria);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public Map<String, String> getRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        try {
            HashMap<String, String> results = new HashMap<String, String>();
            for (IdentityStore identityStore : this.configuredIdentityStores) {
                IdentityStoreInvocationContext storeCtx;
                Map props;
                if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported() || (props = identityStore.getRelationshipNameProperties(storeCtx = this.resolveInvocationContext(identityStore, ctx), name)) == null || props.keySet().size() <= 0) continue;
                results.putAll(props);
            }
            return results;
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public void setRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        try {
            for (IdentityStore identityStore : this.configuredIdentityStores) {
                if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported() || this.isIdentityStoreReadOnly(identityStore)) continue;
                IdentityStoreInvocationContext storeCtx = this.resolveInvocationContext(identityStore, ctx);
                identityStore.setRelationshipNameProperties(storeCtx, name, properties);
            }
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public void removeRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        try {
            for (IdentityStore identityStore : this.configuredIdentityStores) {
                if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported() || this.isIdentityStoreReadOnly(identityStore)) continue;
                IdentityStoreInvocationContext storeCtx = this.resolveInvocationContext(identityStore, ctx);
                identityStore.removeRelationshipNameProperties(storeCtx, name, properties);
            }
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public Map<String, String> getRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship) throws IdentityException, OperationNotSupportedException {
        try {
            IdentityStore fromStore = this.resolveIdentityStore(relationship.getFromIdentityObject());
            IdentityStore toStore = this.resolveIdentityStore(relationship.getToIdentityObject());
            if (fromStore == toStore && toStore.getSupportedFeatures().isNamedRelationshipsSupported()) {
                return fromStore.getRelationshipProperties(this.resolveInvocationContext(fromStore, ctx), relationship);
            }
            return this.defaultIdentityStore.getRelationshipProperties(this.resolveInvocationContext(this.defaultIdentityStore, ctx), relationship);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public void setRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        try {
            IdentityStore fromStore = this.resolveFirstIdentityStoreWithIO(relationship.getFromIdentityObject(), ctx);
            IdentityStore toStore = this.resolveFirstIdentityStoreWithIO(relationship.getToIdentityObject(), ctx);
            if (fromStore != null && toStore != null && fromStore == toStore && toStore.getSupportedFeatures().isNamedRelationshipsSupported() && !this.isIdentityStoreReadOnly(fromStore)) {
                fromStore.setRelationshipProperties(this.resolveInvocationContext(fromStore, ctx), relationship, properties);
                return;
            }
            this.defaultIdentityStore.setRelationshipProperties(this.resolveInvocationContext(this.defaultIdentityStore, ctx), relationship, properties);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public void removeRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        try {
            IdentityStore fromStore = this.resolveFirstIdentityStoreWithIO(relationship.getFromIdentityObject(), ctx);
            IdentityStore toStore = this.resolveFirstIdentityStoreWithIO(relationship.getToIdentityObject(), ctx);
            if (fromStore != null && toStore != null && fromStore == toStore && toStore.getSupportedFeatures().isNamedRelationshipsSupported() && !this.isIdentityStoreReadOnly(fromStore)) {
                fromStore.removeRelationshipProperties(this.resolveInvocationContext(fromStore, ctx), relationship, properties);
                return;
            }
            this.defaultIdentityStore.removeRelationshipProperties(this.resolveInvocationContext(this.defaultIdentityStore, ctx), relationship, properties);
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public boolean validateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        try {
            IdentityStore toStore = this.resolveFirstIdentityStoreWithIO(identityObject, ctx);
            if (toStore != null) {
                IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, ctx);
                return toStore.validateCredential(targetCtx, identityObject, credential);
            }
            IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(this.defaultIdentityStore, ctx);
            if (toStore != this.defaultIdentityStore && this.hasIdentityObject(targetCtx, this.defaultIdentityStore, identityObject)) {
                return this.defaultIdentityStore.validateCredential(targetCtx, identityObject, credential);
            }
            return false;
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public void updateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        try {
            IdentityStore toStore = this.resolveFirstIdentityStoreWithIO(identityObject, ctx);
            if (toStore != null) {
                IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, ctx);
                toStore.updateCredential(targetCtx, identityObject, credential);
                return;
            }
            IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(this.defaultIdentityStore, ctx);
            if (toStore != this.defaultIdentityStore && this.hasIdentityObject(targetCtx, this.defaultIdentityStore, identityObject)) {
                this.defaultIdentityStore.updateCredential(targetCtx, identityObject, credential);
            }
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public Set<String> getSupportedAttributeNames(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityType) throws IdentityException {
        try {
            IdentityStore toStore = this.resolveIdentityStore(identityType);
            IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, invocationContext);
            Set results = toStore.getSupportedAttributeNames(targetCtx, identityType);
            if (toStore != this.defaultAttributeStore) {
                IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationContext);
                results.addAll(this.defaultAttributeStore.getSupportedAttributeNames(defaultCtx, identityType));
            }
            return results;
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public Map<String, IdentityObjectAttributeMetaData> getAttributesMetaData(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityObjectType) {
        try {
            IdentityStoreInvocationContext defaultCtx;
            Map defaultMDMap;
            IdentityStore targetStore = this.resolveIdentityStore(identityObjectType);
            IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(targetStore, invocationContext);
            HashMap<String, IdentityObjectAttributeMetaData> mdMap = new HashMap<String, IdentityObjectAttributeMetaData>();
            mdMap.putAll(targetStore.getAttributesMetaData(targetCtx, identityObjectType));
            if (targetStore != this.defaultAttributeStore && (defaultMDMap = this.defaultAttributeStore.getAttributesMetaData(defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationContext), identityObjectType)) != null) {
                for (Map.Entry entry : defaultMDMap.entrySet()) {
                    if (mdMap.containsKey(entry.getKey())) continue;
                    mdMap.put((String)entry.getKey(), (IdentityObjectAttributeMetaData)entry.getValue());
                }
            }
            return mdMap;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Exception occurred: ", e);
            return new HashMap<String, IdentityObjectAttributeMetaData>();
        }
    }

    public IdentityObjectAttribute getAttribute(IdentityStoreInvocationContext invocationContext, IdentityObject identity, String name) throws IdentityException {
        try {
            IdentityObjectAttribute result = null;
            IdentityStore toStore = this.resolveFirstIdentityStoreWithIO(identity, invocationContext);
            if (toStore != null) {
                IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, invocationContext);
                result = toStore.getAttribute(targetCtx, identity, name);
            }
            if (result == null && (toStore == null || toStore != this.defaultAttributeStore)) {
                IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationContext);
                result = this.defaultAttributeStore.getAttribute(defaultCtx, identity, name);
            }
            return result;
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public Map<String, IdentityObjectAttribute> getAttributes(IdentityStoreInvocationContext invocationContext, IdentityObject identity) throws IdentityException {
        try {
            Map<String, Object> results = new HashMap<String, IdentityObjectAttribute>();
            IdentityStore toStore = this.resolveFirstIdentityStoreWithIO(identity, invocationContext);
            if (toStore != null) {
                IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, invocationContext);
                results = toStore.getAttributes(targetCtx, identity);
            }
            if (toStore == null || toStore != this.defaultAttributeStore) {
                IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationContext);
                Map defaultAttrs = this.defaultAttributeStore.getAttributes(defaultCtx, identity);
                for (Map.Entry entry : defaultAttrs.entrySet()) {
                    if (results.keySet().contains(entry.getKey())) continue;
                    results.put((String)entry.getKey(), entry.getValue());
                }
            }
            return results;
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public void updateAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        try {
            Set supportedAttrs;
            ArrayList<IdentityObjectAttribute> filteredAttrs = new ArrayList<IdentityObjectAttribute>();
            ArrayList<IdentityObjectAttribute> leftAttrs = new ArrayList<IdentityObjectAttribute>();
            IdentityObjectAttribute[] attributesToAdd = null;
            IdentityStore toStore = this.resolveFirstIdentityStoreWithIO(identity, invocationCtx);
            if (toStore != null && toStore != this.defaultAttributeStore && !this.isIdentityStoreReadOnly(toStore)) {
                IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, invocationCtx);
                supportedAttrs = toStore.getSupportedAttributeNames(targetCtx, identity.getIdentityType());
                for (IdentityObjectAttribute entry : attributes) {
                    if (supportedAttrs.contains(entry.getName())) {
                        filteredAttrs.add(entry);
                        continue;
                    }
                    leftAttrs.add(entry);
                }
                toStore.updateAttributes(targetCtx, identity, filteredAttrs.toArray(new IdentityObjectAttribute[filteredAttrs.size()]));
                attributesToAdd = leftAttrs.toArray(new IdentityObjectAttribute[leftAttrs.size()]);
            } else {
                attributesToAdd = attributes;
            }
            IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationCtx);
            if (this.isAllowNotDefinedAttributes()) {
                if (!this.hasIdentityObject(defaultCtx, this.defaultIdentityStore, identity)) {
                    this.defaultIdentityStore.createIdentityObject(defaultCtx, identity.getName(), identity.getIdentityType());
                }
                this.defaultAttributeStore.updateAttributes(defaultCtx, identity, attributesToAdd);
            } else {
                supportedAttrs = this.defaultAttributeStore.getSupportedAttributeNames(defaultCtx, identity.getIdentityType());
                for (IdentityObjectAttribute entry : leftAttrs) {
                    if (supportedAttrs.contains(entry.getName())) continue;
                    throw new IdentityException("Cannot update not defined attribute. Use 'allowNotDefinedAttributes' option to pass such attributes to default IdentityStore anyway.Attribute name: " + entry.getName());
                }
                this.defaultAttributeStore.updateAttributes(defaultCtx, identity, attributesToAdd);
            }
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public void addAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        try {
            Set supportedAttrs;
            ArrayList<IdentityObjectAttribute> filteredAttrs = new ArrayList<IdentityObjectAttribute>();
            ArrayList<IdentityObjectAttribute> leftAttrs = new ArrayList<IdentityObjectAttribute>();
            IdentityObjectAttribute[] attributesToAdd = null;
            IdentityStore toStore = this.resolveFirstIdentityStoreWithIO(identity, invocationCtx);
            if (toStore != null && toStore != this.defaultAttributeStore && !this.isIdentityStoreReadOnly(toStore)) {
                IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, invocationCtx);
                supportedAttrs = toStore.getSupportedAttributeNames(targetCtx, identity.getIdentityType());
                for (IdentityObjectAttribute entry : attributes) {
                    if (supportedAttrs.contains(entry.getName())) {
                        filteredAttrs.add(entry);
                        continue;
                    }
                    leftAttrs.add(entry);
                }
                toStore.addAttributes(targetCtx, identity, filteredAttrs.toArray(new IdentityObjectAttribute[filteredAttrs.size()]));
                attributesToAdd = leftAttrs.toArray(new IdentityObjectAttribute[leftAttrs.size()]);
            } else {
                attributesToAdd = attributes;
            }
            IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationCtx);
            if (this.isAllowNotDefinedAttributes()) {
                if (!this.hasIdentityObject(defaultCtx, this.defaultIdentityStore, identity)) {
                    this.defaultIdentityStore.createIdentityObject(defaultCtx, identity.getName(), identity.getIdentityType());
                }
                this.defaultAttributeStore.addAttributes(defaultCtx, identity, attributesToAdd);
            } else {
                supportedAttrs = this.defaultAttributeStore.getSupportedAttributeNames(defaultCtx, identity.getIdentityType());
                for (IdentityObjectAttribute entry : attributesToAdd) {
                    if (supportedAttrs.contains(entry.getName())) continue;
                    throw new IdentityException("Cannot add not defined attribute. Use 'allowNotDefinedAttributes' option to pass such attributes to default IdentityStore anyway.Attribute name: " + entry.getName());
                }
                this.defaultAttributeStore.addAttributes(defaultCtx, identity, attributesToAdd);
            }
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public void removeAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, String[] attributes) throws IdentityException {
        try {
            Set supportedAttrs;
            LinkedList<String> filteredAttrs = new LinkedList<String>();
            List<Object> leftAttrs = new LinkedList();
            IdentityStore toStore = this.resolveFirstIdentityStoreWithIO(identity, invocationCtx);
            if (toStore != null && toStore != this.defaultAttributeStore && !this.isIdentityStoreReadOnly(toStore)) {
                IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, invocationCtx);
                supportedAttrs = toStore.getSupportedAttributeNames(targetCtx, identity.getIdentityType());
                for (String name : attributes) {
                    if (supportedAttrs.contains(name)) {
                        filteredAttrs.add(name);
                        continue;
                    }
                    leftAttrs.add(name);
                }
                toStore.removeAttributes(targetCtx, identity, filteredAttrs.toArray(new String[filteredAttrs.size()]));
            } else {
                leftAttrs = Arrays.asList(attributes);
            }
            IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationCtx);
            if (this.isAllowNotDefinedAttributes()) {
                if (!this.hasIdentityObject(defaultCtx, this.defaultIdentityStore, identity)) {
                    this.defaultIdentityStore.createIdentityObject(defaultCtx, identity.getName(), identity.getIdentityType());
                }
                this.defaultAttributeStore.removeAttributes(defaultCtx, identity, leftAttrs.toArray(new String[leftAttrs.size()]));
            } else {
                supportedAttrs = this.defaultAttributeStore.getSupportedAttributeNames(defaultCtx, identity.getIdentityType());
                for (String string : leftAttrs) {
                    if (supportedAttrs.contains(string)) continue;
                    throw new IdentityException("Cannot remove not defined attribute. Use 'allowNotDefinedAttributes' option to pass such attributes to default IdentityStore anyway.Attribute name: " + string);
                }
                this.defaultAttributeStore.removeAttributes(defaultCtx, identity, leftAttrs.toArray(new String[leftAttrs.size()]));
            }
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    public IdentityObject findIdentityObjectByUniqueAttribute(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityObjectType, IdentityObjectAttribute attribute) throws IdentityException {
        try {
            List<IdentityStore> mappedStores = this.resolveIdentityStores(identityObjectType);
            IdentityObject result = null;
            for (IdentityStore mappedStore : mappedStores) {
                if (mappedStore == this.defaultAttributeStore) continue;
                IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(mappedStore, invocationCtx);
                Set supportedAttrs = mappedStore.getSupportedAttributeNames(targetCtx, identityObjectType);
                if (supportedAttrs.contains(attribute.getName())) {
                    result = mappedStore.findIdentityObjectByUniqueAttribute(targetCtx, identityObjectType, attribute);
                }
                if (result == null) continue;
                return result;
            }
            IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationCtx);
            if (this.isAllowNotDefinedAttributes()) {
                return this.defaultAttributeStore.findIdentityObjectByUniqueAttribute(defaultCtx, identityObjectType, attribute);
            }
            Set supportedAttrs = this.defaultAttributeStore.getSupportedAttributeNames(defaultCtx, identityObjectType);
            if (supportedAttrs.contains(attribute.getName())) {
                return this.defaultAttributeStore.findIdentityObjectByUniqueAttribute(defaultCtx, identityObjectType, attribute);
            }
            return null;
        }
        catch (IdentityException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw e;
        }
    }

    private void sortByName(List<IdentityObject> objects, final boolean ascending) {
        Collections.sort(objects, new Comparator<IdentityObject>(){

            @Override
            public int compare(IdentityObject o1, IdentityObject o2) {
                if (ascending) {
                    return o1.getName().compareTo(o2.getName());
                }
                return o2.getName().compareTo(o1.getName());
            }
        });
    }

    private List<IdentityObject> cutPageFromResults(List<IdentityObject> objects, IdentityObjectSearchCriteria criteria) {
        LinkedList<IdentityObject> results = new LinkedList<IdentityObject>();
        if (criteria.getMaxResults() == 0) {
            for (int i = criteria.getFirstResult(); i < objects.size(); ++i) {
                if (i >= objects.size()) continue;
                results.add(objects.get(i));
            }
        } else {
            for (int i = criteria.getFirstResult(); i < criteria.getFirstResult() + criteria.getMaxResults(); ++i) {
                if (i >= objects.size()) continue;
                results.add(objects.get(i));
            }
        }
        return results;
    }

    public boolean isAllowNotDefinedAttributes() {
        return this.allowNotDefinedAttributes;
    }

    public boolean isIdentityStoreReadOnly(IdentityStore store) {
        List mappingMDs = this.configurationContext.getRepositoryConfigurationMetaData().getIdentityStoreToIdentityObjectTypeMappings();
        for (IdentityStoreMappingMetaData mappingMD : mappingMDs) {
            String value;
            if (!mappingMD.getIdentityStoreId().equals(store.getId()) || (value = mappingMD.getOptionSingleValue(OPTION_READ_ONLY)) == null || !value.equalsIgnoreCase("true")) continue;
            return true;
        }
        return false;
    }
}

