/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.upgrade;

import java.util.HashMap;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.query.QueryResult;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.mow.core.api.MOWService;
import org.exoplatform.wiki.mow.core.api.wiki.AttachmentImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PageImpl;

public class WikiPermissionRepairPlugin
extends UpgradeProductPlugin {
    private static final Log Log = ExoLogger.getLogger(WikiPermissionRepairPlugin.class);

    public WikiPermissionRepairPlugin(InitParams initParams) {
        super(initParams);
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        Log.info((Object)"\n\nStart check and fix null entry permission of attachments...\n");
        try {
            this.fixPermissionEntryNull();
        }
        catch (Exception e) {
            Log.warn((Object)"[WikiPermissionRepairPlugin] Exception when fix null entry permission of attachments for wiki:", (Throwable)e);
        }
        Log.info((Object)"\n\nFinish check and fix null entry permission of attachments...\n");
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isBefore((String)previousVersion, (String)newVersion);
    }

    public void fixPermissionEntryNull() {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        MOWService mowService = (MOWService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(MOWService.class);
        ChromatticSession session = mowService.getSession();
        QueryResult attachmentIterator = session.createQueryBuilder(AttachmentImpl.class).where("jcr:path LIKE '%/WikiHome/%' AND not(fn:name()='content')").get().objects();
        Log.info("\nTotal attachments found: {}\n", new Object[]{attachmentIterator.size()});
        int fixedAttachment = 0;
        while (attachmentIterator.hasNext()) {
            AttachmentImpl attachment = (AttachmentImpl)attachmentIterator.next();
            try {
                PageImpl parent = attachment.getParentPage();
                if (parent == null) continue;
                HashMap permissions = attachment.getParentPage().getPermission();
                if (attachment.getCreator() != null) {
                    permissions.put(attachment.getCreator(), PermissionType.ALL);
                }
                attachment.setPermission(permissions);
                Log.info("\nFixed attachment: {}/{}\n", new Object[]{++fixedAttachment, attachmentIterator.size()});
            }
            catch (Exception e) {
                Log.warn((Object)String.format("Can not repair the permission for attachment %s", attachment.getName()), (Throwable)e);
            }
        }
        RequestLifeCycle.end();
    }
}

