/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.plugins;

import java.util.List;
import javax.jcr.Session;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValue;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UpgradePublicationPublicationNodeTypePlugin
extends UpgradeProductPlugin {
    private static final String PUBLICATION_HISTORY = "publication:history";
    private static final String PUBLICATION_PUBLICATION = "publication:publication";
    private DMSConfiguration dmsConfiguration_;
    private RepositoryService repoService_;
    private static final Log LOG = ExoLogger.getLogger((String)UpgradePublicationPublicationNodeTypePlugin.class.getName());

    public UpgradePublicationPublicationNodeTypePlugin(RepositoryService repoService, DMSConfiguration dmsConfiguration, InitParams initParams) {
        super(initParams);
        this.repoService_ = repoService;
        this.dmsConfiguration_ = dmsConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            Session session = sessionProvider.getSession(this.dmsConfiguration_.getConfig().getSystemWorkspace(), this.repoService_.getCurrentRepository());
            ExtendedNodeTypeManager nodeTypeManager = (ExtendedNodeTypeManager)session.getWorkspace().getNodeTypeManager();
            NodeTypeValue mixVotableNodeTypeValue = nodeTypeManager.getNodeTypeValue(PUBLICATION_PUBLICATION);
            List propertyDefinitionList = mixVotableNodeTypeValue.getDeclaredPropertyDefinitionValues();
            boolean publicationHistoryIgnore = false;
            for (PropertyDefinitionValue propertyDefinition : propertyDefinitionList) {
                if (!propertyDefinition.getName().equals(PUBLICATION_HISTORY)) continue;
                if (propertyDefinition.getOnVersion() == 5) {
                    publicationHistoryIgnore = true;
                    break;
                }
                if (propertyDefinition.getOnVersion() != 1) continue;
                propertyDefinition.setOnVersion(5);
                break;
            }
            if (!publicationHistoryIgnore) {
                mixVotableNodeTypeValue.setDeclaredPropertyDefinitionValues(propertyDefinitionList);
                nodeTypeManager.registerNodeType(mixVotableNodeTypeValue, 4);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Change property 'publication:history' for node type 'publication:publication' successfully!");
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"An unexpected error occurs when change property 'publication:history' for node type 'publication:publication'!", (Throwable)e);
            }
        }
        finally {
            sessionProvider.close();
        }
    }

    public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
        return true;
    }
}

