/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.DecodingCharProducer;

final class UriDecoder
extends DecodingCharProducer.Decoder {
    UriDecoder() {
    }

    public void decode(char[] chars, int offset, int limit) {
        this.decodeOneChar(chars, offset, limit);
        int cp = this.codePoint;
        int e = this.end;
        if (Character.isHighSurrogate((char)this.codePoint) && e < limit) {
            this.decodeOneChar(chars, e, limit);
            if (Character.isLowSurrogate((char)this.codePoint)) {
                this.codePoint = Character.toCodePoint((char)cp, (char)this.codePoint);
            } else {
                this.codePoint = cp;
                this.end = e;
            }
        }
    }

    private void decodeOneChar(char[] chars, int offset, int limit) {
        int b;
        int end = offset + 1;
        int codepoint = chars[offset];
        if (codepoint == 37 && (b = UriDecoder.toByte(chars, offset, limit)) >= 0) {
            if ((b & 0x80) == 0) {
                codepoint = b;
                end += 2;
            } else {
                int result;
                if ((b & 0xE0) == 192) {
                    result = UriDecoder.fromUtf8(b & 0x1F, 1, chars, offset, limit);
                    if (result >= 0) {
                        end += 5;
                    }
                } else if ((b & 0xF0) == 224) {
                    result = UriDecoder.fromUtf8(b & 0xF, 2, chars, offset, limit);
                    if (result >= 0) {
                        end += 8;
                    }
                } else if ((b & 0xF8) == 240) {
                    result = UriDecoder.fromUtf8(b & 7, 3, chars, offset, limit);
                    if (result >= 0) {
                        end += 11;
                    }
                } else {
                    result = -1;
                }
                if (result >= 0) {
                    codepoint = result;
                } else {
                    codepoint = b;
                    end += 2;
                }
            }
        }
        this.codePoint = codepoint;
        this.end = end;
    }

    private static int toByte(char[] chars, int offset, int limit) {
        if (offset + 3 > limit) {
            return -1;
        }
        int a = UriDecoder.fromHex(chars[offset + 1]);
        if (a < 0) {
            return -1;
        }
        int b = UriDecoder.fromHex(chars[offset + 2]);
        if (b < 0) {
            return -1;
        }
        return a << 4 | b;
    }

    private static int fromHex(char ch) {
        if (ch > 'f' || ch < '0') {
            return -1;
        }
        if (ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a') {
            return ch - 87;
        }
        if (ch <= 'F' && ch >= 'A') {
            return ch - 55;
        }
        return -1;
    }

    private static int fromUtf8(int prefix, int nChunks, char[] chars, int offset, int limit) {
        int cur = offset + 2;
        int end = cur + 1 + 3 * nChunks;
        if (end > limit) {
            return -1;
        }
        int bits = prefix;
        for (int i = 0; i < nChunks; ++i) {
            int b;
            int a;
            if (chars[++cur] != '%') {
                return -1;
            }
            if ((a = UriDecoder.fromHex(chars[++cur])) < 0 || (a & 0xC) != 8) {
                return -1;
            }
            if ((b = UriDecoder.fromHex(chars[++cur])) < 0) {
                return -1;
            }
            bits = bits << 6 | ((a & 3) << 4 | b);
        }
        return bits;
    }
}

