/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wsqa.httpclient;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResponseHeader
extends LinkedHashMap<String, String> {
    public static final int NOT_MODIFIED_CODE_304 = 304;
    public static final int STATUS_STRING_MOVED_CODE_302 = 302;
    private String protocol_;
    private int statusCode_;
    private String statusString_;
    private ByteArrayOutputStream orginalData_ = new ByteArrayOutputStream();

    public HttpResponseHeader(InputStream is) throws Exception {
        int code;
        ByteArrayOutputStream line = new ByteArrayOutputStream();
        String firstline = null;
        boolean keepReading = true;
        while (keepReading && (code = is.read()) >= 0) {
            this.orginalData_.write(code);
            if (code == 13) continue;
            if (code == 10) {
                if (firstline == null) {
                    firstline = new String(line.toByteArray());
                    this.parseFirstLine(firstline);
                } else if (line.size() < 3) {
                    keepReading = false;
                } else {
                    this.parseHeaderLine(new String(line.toByteArray()));
                }
                line.reset();
                continue;
            }
            line.write(code);
        }
    }

    public String getProtocol() {
        return this.protocol_;
    }

    public int getStatusCode() {
        return this.statusCode_;
    }

    public String getStatusString() {
        return this.statusString_;
    }

    public byte[] getHeaderDataAsByte() {
        return this.orginalData_.toByteArray();
    }

    public byte[] getOriginalHeaderDataAsByte() {
        return this.orginalData_.toByteArray();
    }

    public String getSetCookie() {
        return (String)this.get("Set-Cookie");
    }

    public void setSetCookie(String s) {
        this.put("Set-Cookie", s);
    }

    public String getServer() {
        return (String)this.get("Server");
    }

    public void setServer(String s) {
        this.put("Server", s);
    }

    public String getContentType() {
        return (String)this.get("Content-Type");
    }

    public void setContentType(String s) {
        this.put("Content-Type", s);
    }

    public String getContentLength() {
        return (String)this.get("Content-Length");
    }

    public int getContentLengthAsInteger() {
        String contentLengthStr = (String)this.get("Content-Length");
        int contentLength = -1;
        if (contentLengthStr != null) {
            contentLength = Integer.parseInt(contentLengthStr);
        }
        return contentLength;
    }

    public void setContentLength(String s) {
        this.put("Content-Length", s);
    }

    public String getTransferEncoding() {
        return (String)this.get("Transfer-Encoding");
    }

    public void setTransferEncoding(String s) {
        this.put("Transfer-Encoding", s);
    }

    public String getDate() {
        return (String)this.get("Date");
    }

    public void setDate(String s) {
        this.put("Date", s);
    }

    public String getCacheControl() {
        return (String)this.get("Cache-Control");
    }

    public void setCacheControl(String s) {
        this.put("Cache-Control", s);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        for (Map.Entry entry : this.entrySet()) {
            b.append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append("\r\n");
        }
        return b.toString();
    }

    private void parseHeaderLine(String line) throws Exception {
        int colonIndex = line.indexOf(":");
        if (colonIndex < 1) {
            throw new Exception("Line \"" + line + "\" is not a header line");
        }
        String name = line.substring(0, colonIndex).trim();
        String value = line.substring(colonIndex + 1, line.length()).trim();
        this.put(name, value);
    }

    private void parseFirstLine(String line) {
        String[] tmp = line.split(" ");
        this.protocol_ = tmp[0];
        this.statusCode_ = Integer.parseInt(tmp[1]);
        this.statusString_ = tmp[2];
    }
}

