/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.records.impl;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cms.records.RecordsService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.BaseJob;
import org.exoplatform.services.scheduler.JobContext;

public class RecordsJob
extends BaseJob {
    private static final String QUERY = "SELECT * FROM rma:filePlan";
    private static final Log LOG = ExoLogger.getLogger((String)RecordsJob.class.getName());
    private RepositoryService repositoryService_;
    private RecordsService recordsService_;

    public void execute(JobContext context) throws Exception {
        block13: {
            Session session = null;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"File plan job started");
                }
                ExoContainer container = ExoContainerContext.getCurrentContainer();
                this.repositoryService_ = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
                this.recordsService_ = (RecordsService)container.getComponentInstanceOfType(RecordsService.class);
                ManageableRepository repository = this.repositoryService_.getCurrentRepository();
                if (repository.getState() != 0) {
                    String[] workspaces = repository.getWorkspaceNames();
                    for (int i = 0; i < workspaces.length; ++i) {
                        String workspaceName = workspaces[i];
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Search File plans in workspace : " + workspaceName));
                        }
                        session = repository.getSystemSession(workspaceName);
                        QueryManager queryManager = session.getWorkspace().getQueryManager();
                        Query query = queryManager.createQuery(QUERY, "sql");
                        QueryResult results = query.execute();
                        NodeIterator iter = results.getNodes();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("File plan nodes : " + iter.getSize()));
                        }
                        while (iter.hasNext()) {
                            Node filePlan = iter.nextNode();
                            try {
                                this.recordsService_.computeCutoffs(filePlan);
                                this.recordsService_.computeHolds(filePlan);
                                this.recordsService_.computeTransfers(filePlan);
                                this.recordsService_.computeAccessions(filePlan);
                                this.recordsService_.computeDestructions(filePlan);
                            }
                            catch (RepositoryException ex) {
                                if (!LOG.isErrorEnabled()) continue;
                                LOG.error((Object)ex.getMessage(), (Throwable)ex);
                            }
                        }
                        session.logout();
                    }
                } else if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Repository '" + repository.getConfiguration().getName() + "' is not started. Execution skipped."));
                }
            }
            catch (Exception e) {
                if (session == null) break block13;
                session.logout();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"File plan job done");
        }
    }
}

