/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.discovery;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.ide.discovery.EntryPoint;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;

@Path(value="/ide/discovery")
public class RepositoryDiscoveryService {
    private static final String WEBDAV_CONTEXT = "jcr";
    public static final String WEBDAV_SCHEME = "jcr-webdav";
    public static final String DEF_WS = "dev-monit";
    private String entryPoint;
    private boolean discoverable;
    private static final CacheControl noCache = new CacheControl();
    private RepositoryService repositoryService;

    public RepositoryDiscoveryService(RepositoryService repositoryService, String entryPoint, boolean discoverable) {
        this.repositoryService = repositoryService;
        this.entryPoint = entryPoint != null ? entryPoint : DEF_WS;
        this.discoverable = discoverable;
    }

    public static final String getWebDavConetxt() {
        return WEBDAV_CONTEXT;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/entrypoints/")
    public List<EntryPoint> getEntryPoints(@Context UriInfo uriInfo) throws RepositoryException {
        ArrayList<String> entryPoints = new ArrayList<String>();
        RepositoryEntry repositoryEntry = this.repositoryService.getCurrentRepository().getConfiguration();
        for (WorkspaceEntry workspaceEntry : repositoryEntry.getWorkspaceEntries()) {
            String workspaceName = workspaceEntry.getName();
            String href = uriInfo.getBaseUriBuilder().segment(new String[]{WEBDAV_CONTEXT, repositoryEntry.getName(), workspaceName, "/"}).build(new Object[0]).toString();
            entryPoints.add(href);
        }
        ArrayList<EntryPoint> entryPointList = new ArrayList<EntryPoint>();
        for (int i = 0; i < entryPoints.size(); ++i) {
            entryPointList.add(new EntryPoint(WEBDAV_SCHEME, (String)entryPoints.get(i)));
        }
        return entryPointList;
    }

    @GET
    @Path(value="/defaultEntrypoint/")
    public String getDefaultEntryPoint(@Context UriInfo uriInfo) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository repository = this.repositoryService.getCurrentRepository();
        if (repository == null) {
            repository = this.repositoryService.getDefaultRepository();
        }
        String href = uriInfo.getBaseUriBuilder().segment(new String[]{WEBDAV_CONTEXT, repository.getConfiguration().getName(), this.entryPoint, "/"}).build(new Object[0]).toString();
        return href;
    }

    @GET
    @Path(value="/isdiscoverable/")
    public String isDiscoverable() {
        return "" + this.discoverable;
    }

    static {
        noCache.setNoCache(true);
        noCache.setNoStore(true);
    }
}

