/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.samples.website.extention.webui;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.platform.samples.website.extention.webui.UINavigationSelector;
import org.exoplatform.wcm.webui.core.UIPopupWindow;
import org.exoplatform.wcm.webui.selector.page.UIPageSelector;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.ext.UIFormInputSetWithAction;
import org.exoplatform.webui.form.validator.NumberFormatValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/webui/component/explorer/extention/UINavigationForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectListTargetPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectDetailTargetPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectNavigationNodeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveListTargetPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveDetailTargetPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveNavigationNodeActionListener.class}, phase=Event.Phase.DECODE)})
public class UINavigationForm
extends UIForm
implements UIPopupComponent,
UISelectable {
    public static final String NODE = "Node";
    public static final String IS_VISIBLE = "Visible";
    public static final String NAVIGATION_NODE_STRING_INPUT = "NavigationNode";
    public static final String NAVIGATION_NODE_INPUT_SET = "NavigationNodeInputSet";
    public static final String NAVIGATION_SELECTOR_POPUP_WINDOW = "NavigationSelectorPopupWindow";
    public static final String INDEX = "Index";
    public static final String NAVIGATION_CONTROLS = "NavigationControls";
    public static final String IS_CLICKABLE = "Clickable";
    public static final String LIST_TARGET_PAGE_STRING_INPUT = "ListTargetPageFormStringInput";
    public static final String LIST_TARGET_PAGE_INPUT_SET = "ListTargetPageFormInputSet";
    public static final String LIST_TARGET_PAGE_SELECTOR_POPUP_WINDOW = "ListTargetPageSelectorPopupWindow";
    public static final String DETAIL_TARGET_PAGE_STRING_INPUT = "DetailTargetPageStringInput";
    public static final String DETAIL_TARGET_PAGE_INPUT_SET = "DetailTargetPageInputSet";
    public static final String DETAIL_TARGET_PAGE_SELECTOR_POPUP_WINDOW = "DetailTargetPageSelectorPopupWindow";
    public static final String LIST = "List";
    public static final String DETAIL = "Detail";
    private String popupId;
    private String nameValue_;
    private boolean isVisible = false;
    private long index_ = 1000L;
    private String navigationNode_ = "";
    private boolean isClickable = false;
    private String listTargetPage_ = "";
    private String listShowClvBy_ = "";
    private String detailTargetPage_ = "";
    private String detailShowClvBy_ = "";
    private Node currentNode;
    private boolean renderIndexField;

    public void initParams() throws Exception {
        boolean hasNavigableMixinType;
        Node content;
        if (this.currentNode.hasProperty("exo:title")) {
            this.nameValue_ = this.currentNode.getProperty("exo:title").getValue().getString();
        }
        if (this.currentNode.hasNode("jcr:content") && (content = this.currentNode.getNode("jcr:content")).hasProperty("dc:title")) {
            try {
                this.nameValue_ = content.getProperty("dc:title").getValues()[0].getString();
            }
            catch (Exception e) {
                this.nameValue_ = null;
            }
        }
        if (this.nameValue_ == null) {
            this.nameValue_ = this.currentNode.getName();
        }
        if (hasNavigableMixinType = this.currentNode.isNodeType("exo:navigable")) {
            this.isVisible = true;
            if (this.currentNode.getParent().isNodeType("exo:navigable")) {
                if (this.currentNode.hasProperty("exo:index")) {
                    this.index_ = this.currentNode.getProperty("exo:index").getLong();
                }
                this.renderIndexField = true;
            }
            if (this.currentNode.hasProperty("exo:navigationNode")) {
                this.navigationNode_ = this.currentNode.getProperty("exo:navigationNode").getString();
            }
            if (this.currentNode.hasProperty("exo:clickable")) {
                this.isClickable = this.currentNode.getProperty("exo:clickable").getBoolean();
            }
            if (this.currentNode.hasProperty("exo:page")) {
                this.listTargetPage_ = this.currentNode.getProperty("exo:page").getString();
            }
            if (this.currentNode.hasProperty("exo:pageParamId")) {
                this.listShowClvBy_ = this.currentNode.getProperty("exo:pageParamId").getString();
            }
            if (this.currentNode.hasProperty("exo:childrenPage")) {
                this.detailTargetPage_ = this.currentNode.getProperty("exo:childrenPage").getString();
            }
            if (this.currentNode.hasProperty("exo:childrenPageParamId")) {
                this.detailShowClvBy_ = this.currentNode.getProperty("exo:childrenPageParamId").getString();
            }
        }
    }

    public void activate() throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        this.currentNode = uiExplorer.getCurrentNode();
        this.initParams();
        UIFormStringInput uiFormNameValueStringInput = new UIFormStringInput(NODE, NODE, this.nameValue_);
        uiFormNameValueStringInput.setEditable(false);
        UIFormCheckBoxInput uiFormVisibleValueCheckBoxInput = new UIFormCheckBoxInput(IS_VISIBLE, IS_VISIBLE, (Object)false);
        uiFormVisibleValueCheckBoxInput.setChecked(this.isVisible);
        UIFormStringInput uiFormNavigationNodeValueStringInput = new UIFormStringInput(NAVIGATION_NODE_STRING_INPUT, NAVIGATION_NODE_STRING_INPUT, this.navigationNode_);
        uiFormNavigationNodeValueStringInput.setEditable(false);
        UIFormInputSetWithAction navigationNodeInputSet = new UIFormInputSetWithAction(NAVIGATION_NODE_INPUT_SET);
        navigationNodeInputSet.setActionInfo(NAVIGATION_NODE_STRING_INPUT, new String[]{"SelectNavigationNode", "RemoveNavigationNode"});
        navigationNodeInputSet.addUIFormInput((UIFormInput)uiFormNavigationNodeValueStringInput);
        UIFormStringInput uiFormIndexValueStringInput = new UIFormStringInput(INDEX, INDEX, String.valueOf(this.index_));
        uiFormIndexValueStringInput.addValidator(NumberFormatValidator.class, new Object[0]);
        UIFormCheckBoxInput uiFormClickableValueCheckBoxInput = new UIFormCheckBoxInput(IS_CLICKABLE, IS_CLICKABLE, (Object)false);
        uiFormClickableValueCheckBoxInput.setChecked(this.isClickable);
        UIFormStringInput uiFormTargetPageValueStringInput = new UIFormStringInput(LIST_TARGET_PAGE_STRING_INPUT, LIST_TARGET_PAGE_STRING_INPUT, this.listTargetPage_);
        uiFormTargetPageValueStringInput.setEditable(false);
        UIFormInputSetWithAction targetPageInputSet = new UIFormInputSetWithAction(LIST_TARGET_PAGE_INPUT_SET);
        targetPageInputSet.setActionInfo(LIST_TARGET_PAGE_STRING_INPUT, new String[]{"SelectListTargetPage", "RemoveListTargetPage"});
        targetPageInputSet.addUIFormInput((UIFormInput)uiFormTargetPageValueStringInput);
        UIFormStringInput uiFormDetailTargetPageValueStringInput = new UIFormStringInput(DETAIL_TARGET_PAGE_STRING_INPUT, DETAIL_TARGET_PAGE_STRING_INPUT, this.detailTargetPage_);
        uiFormDetailTargetPageValueStringInput.setEditable(false);
        UIFormInputSetWithAction detailTargetPageInputSet = new UIFormInputSetWithAction(DETAIL_TARGET_PAGE_INPUT_SET);
        detailTargetPageInputSet.setActionInfo(DETAIL_TARGET_PAGE_STRING_INPUT, new String[]{"SelectDetailTargetPage", "RemoveDetailTargetPage"});
        detailTargetPageInputSet.addUIFormInput((UIFormInput)uiFormDetailTargetPageValueStringInput);
        this.addChild((UIComponent)uiFormNameValueStringInput);
        this.addChild((UIComponent)uiFormVisibleValueCheckBoxInput);
        this.addChild((UIComponent)navigationNodeInputSet);
        if (this.renderIndexField) {
            this.addChild((UIComponent)uiFormIndexValueStringInput);
        }
        this.addChild((UIComponent)uiFormClickableValueCheckBoxInput);
        this.addChild((UIComponent)targetPageInputSet);
        this.addChild((UIComponent)detailTargetPageInputSet);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void deActivate() throws Exception {
    }

    public void setPopupId(String popupId) {
        this.popupId = popupId;
    }

    public void doSelect(String selectField, Object value) throws Exception {
        if (selectField != null && value != null) {
            String sValue = (String)value;
            this.getUIStringInput(selectField).setValue((Object)sValue);
        }
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        UIPopupContainer popupContainer = (UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class);
        popupContainer.removeChildById(this.popupId);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveListTargetPageActionListener
    extends EventListener<UINavigationForm> {
        public void execute(Event<UINavigationForm> event) throws Exception {
            UINavigationForm uiNavigationForm = (UINavigationForm)((Object)event.getSource());
            uiNavigationForm.getUIStringInput(UINavigationForm.LIST_TARGET_PAGE_STRING_INPUT).setValue((Object)"");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiNavigationForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveDetailTargetPageActionListener
    extends EventListener<UINavigationForm> {
        public void execute(Event<UINavigationForm> event) throws Exception {
            UINavigationForm uiNavigationForm = (UINavigationForm)((Object)event.getSource());
            uiNavigationForm.getUIStringInput(UINavigationForm.DETAIL_TARGET_PAGE_STRING_INPUT).setValue((Object)"");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiNavigationForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveNavigationNodeActionListener
    extends EventListener<UINavigationForm> {
        public void execute(Event<UINavigationForm> event) throws Exception {
            UINavigationForm uiNavigationForm = (UINavigationForm)((Object)event.getSource());
            uiNavigationForm.getUIStringInput(UINavigationForm.NAVIGATION_NODE_STRING_INPUT).setValue((Object)"");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiNavigationForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectDetailTargetPageActionListener
    extends EventListener<UINavigationForm> {
        public void execute(Event<UINavigationForm> event) throws Exception {
            UINavigationForm uiNavigationForm = (UINavigationForm)((Object)event.getSource());
            UIPageSelector pageSelector = (UIPageSelector)uiNavigationForm.createUIComponent(UIPageSelector.class, null, null);
            pageSelector.setSourceComponent((UIComponent)uiNavigationForm, new String[]{UINavigationForm.DETAIL_TARGET_PAGE_STRING_INPUT});
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UINavigationForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            UIPopupContainer popupContainer = (UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class);
            popupContainer.removeChildById(UINavigationForm.DETAIL_TARGET_PAGE_SELECTOR_POPUP_WINDOW);
            UIPopupWindow popupWindow = (UIPopupWindow)popupContainer.addChild(UIPopupWindow.class, null, UINavigationForm.DETAIL_TARGET_PAGE_SELECTOR_POPUP_WINDOW);
            popupWindow.setUIComponent((UIComponent)pageSelector);
            popupWindow.setWindowSize(800, 0);
            popupWindow.setShow(true);
            popupWindow.setRendered(true);
            popupWindow.setResizable(true);
            WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            requestContext.addUIComponentToUpdateByAjax((UIComponent)popupContainer);
            uiNavigationForm.setPopupId(UINavigationForm.DETAIL_TARGET_PAGE_SELECTOR_POPUP_WINDOW);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectListTargetPageActionListener
    extends EventListener<UINavigationForm> {
        public void execute(Event<UINavigationForm> event) throws Exception {
            UINavigationForm uiNavigationForm = (UINavigationForm)((Object)event.getSource());
            UIPageSelector pageSelector = (UIPageSelector)uiNavigationForm.createUIComponent(UIPageSelector.class, null, null);
            pageSelector.setSourceComponent((UIComponent)uiNavigationForm, new String[]{UINavigationForm.LIST_TARGET_PAGE_STRING_INPUT});
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UINavigationForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            UIPopupContainer popupContainer = (UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class);
            popupContainer.removeChildById(UINavigationForm.LIST_TARGET_PAGE_SELECTOR_POPUP_WINDOW);
            UIPopupWindow popupWindow = (UIPopupWindow)popupContainer.addChild(UIPopupWindow.class, null, UINavigationForm.LIST_TARGET_PAGE_SELECTOR_POPUP_WINDOW);
            popupWindow.setUIComponent((UIComponent)pageSelector);
            popupWindow.setWindowSize(800, 0);
            popupWindow.setShow(true);
            popupWindow.setRendered(true);
            popupWindow.setResizable(true);
            WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            requestContext.addUIComponentToUpdateByAjax((UIComponent)popupContainer);
            uiNavigationForm.setPopupId(UINavigationForm.LIST_TARGET_PAGE_SELECTOR_POPUP_WINDOW);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectNavigationNodeActionListener
    extends EventListener<UINavigationForm> {
        public void execute(Event<UINavigationForm> event) throws Exception {
            UINavigationForm uiNavigationForm = (UINavigationForm)((Object)event.getSource());
            UINavigationSelector uiNavigationSelector = (UINavigationSelector)uiNavigationForm.createUIComponent(UINavigationSelector.class, null, null);
            uiNavigationSelector.setSourceComponent((UIComponent)uiNavigationForm, new String[]{UINavigationForm.NAVIGATION_NODE_STRING_INPUT});
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UINavigationForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            UIPopupContainer popupContainer = (UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class);
            uiNavigationSelector.init();
            popupContainer.removeChildById(UINavigationForm.NAVIGATION_SELECTOR_POPUP_WINDOW);
            UIPopupWindow popupWindow = (UIPopupWindow)popupContainer.addChild(UIPopupWindow.class, null, UINavigationForm.NAVIGATION_SELECTOR_POPUP_WINDOW);
            popupWindow.setUIComponent((UIComponent)uiNavigationSelector);
            popupWindow.setWindowSize(800, 0);
            popupWindow.setShow(true);
            popupWindow.setRendered(true);
            popupWindow.setResizable(true);
            WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            requestContext.addUIComponentToUpdateByAjax((UIComponent)popupContainer);
            uiNavigationForm.setPopupId(UINavigationForm.NAVIGATION_SELECTOR_POPUP_WINDOW);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UINavigationForm> {
        public void execute(Event<UINavigationForm> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UINavigationForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UINavigationForm> {
        public void execute(Event<UINavigationForm> event) throws Exception {
            UINavigationForm uiNavigationForm = (UINavigationForm)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiNavigationForm.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiNavigationForm.getAncestorOfType(UIApplication.class);
            Node node = uiExplorer.getCurrentNode();
            if (uiExplorer.nodeIsLocked(node)) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            boolean isVisible = (Boolean)((UIFormCheckBoxInput)uiNavigationForm.getUIInput(UINavigationForm.IS_VISIBLE)).getValue();
            boolean hasNavigableMixinType = node.isNodeType("exo:navigable");
            if (isVisible) {
                if (!hasNavigableMixinType) {
                    if (node.canAddMixin("exo:navigable")) {
                        node.addMixin("exo:navigable");
                    } else {
                        uiApp.addMessage(new ApplicationMessage("UISingleExternalMetadataForm.msg.can-not-add", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                }
                String navigationNode = (String)uiNavigationForm.getUIStringInput(UINavigationForm.NAVIGATION_NODE_STRING_INPUT).getValue();
                node.setProperty("exo:navigationNode", navigationNode);
                long index = 1000L;
                boolean isClickable = false;
                String listTargetPage = (String)uiNavigationForm.getUIStringInput(UINavigationForm.LIST_TARGET_PAGE_STRING_INPUT).getValue();
                if (navigationNode.equals("")) {
                    if (uiNavigationForm.getUIStringInput(UINavigationForm.INDEX) != null) {
                        index = Long.parseLong((String)uiNavigationForm.getUIStringInput(UINavigationForm.INDEX).getValue());
                    }
                    isClickable = (Boolean)((UIFormCheckBoxInput)uiNavigationForm.getUIInput(UINavigationForm.IS_CLICKABLE)).getValue();
                }
                node.setProperty("exo:index", index);
                node.setProperty("exo:clickable", isClickable);
                node.setProperty("exo:page", listTargetPage);
                node.setProperty("exo:pageParamId", "folder-id");
                String detailTargetPage = (String)uiNavigationForm.getUIStringInput(UINavigationForm.DETAIL_TARGET_PAGE_STRING_INPUT).getValue();
                node.setProperty("exo:childrenPage", detailTargetPage);
                node.setProperty("exo:childrenPageParamId", "content-id");
            } else if (hasNavigableMixinType) {
                node.removeMixin("exo:navigable");
            }
            node.save();
            this.propagateVisibility(node, isVisible);
            node.getSession().save();
            uiExplorer.cancelAction();
        }

        private void propagateVisibility(Node node, boolean visible) throws RepositoryException {
            if (node.hasNodes()) {
                NodeIterator itChildNodes = node.getNodes();
                while (itChildNodes.hasNext()) {
                    Node childNode = itChildNodes.nextNode();
                    boolean hasNavigableMixinType = childNode.isNodeType("exo:navigable");
                    if (visible) {
                        boolean navigableType;
                        boolean folderType = childNode.isNodeType("nt:folder") || childNode.isNodeType("exo:taxonomy");
                        boolean bl = navigableType = folderType || childNode.isNodeType("exo:webContent") || childNode.isNodeType("exo:product") || childNode.isNodeType("exo:taxonomyLink");
                        if (hasNavigableMixinType || !navigableType) continue;
                        if (!childNode.canAddMixin("exo:navigable")) {
                            return;
                        }
                        childNode.addMixin("exo:navigable");
                        childNode.setProperty("exo:navigationNode", "");
                        childNode.setProperty("exo:index", 1000L);
                        childNode.setProperty("exo:clickable", true);
                        childNode.setProperty("exo:page", "");
                        childNode.setProperty("exo:pageParamId", "");
                        childNode.setProperty("exo:childrenPage", "");
                        childNode.setProperty("exo:childrenPageParamId", "");
                        childNode.save();
                        if (!folderType) continue;
                        this.propagateVisibility(childNode, visible);
                        continue;
                    }
                    if (hasNavigableMixinType) {
                        childNode.removeMixin("exo:navigable");
                        childNode.save();
                    }
                    this.propagateVisibility(childNode, visible);
                }
            }
        }
    }
}

