/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine.resolver;

import java.lang.annotation.ElementType;
import java.security.AccessController;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import org.hibernate.validator.util.LoadClass;
import org.hibernate.validator.util.LoggerFactory;
import org.hibernate.validator.util.NewInstance;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTraversableResolver
implements TraversableResolver {
    private static final Logger log = LoggerFactory.make();
    private static final String PERSISTENCE_UTIL_CLASS_NAME = "javax.persistence.PersistenceUtil";
    private static final String JPA_AWARE_TRAVERSABLE_RESOLVER_CLASS_NAME = "org.hibernate.validator.engine.resolver.JPATraversableResolver";
    private TraversableResolver jpaTraversableResolver;

    public DefaultTraversableResolver() {
        this.detectJPA();
    }

    private void detectJPA() {
        try {
            this.loadClass(PERSISTENCE_UTIL_CLASS_NAME, this.getClass());
            log.debug("Found {} on classpath.", (Object)PERSISTENCE_UTIL_CLASS_NAME);
        }
        catch (ValidationException e) {
            log.debug("Cannot find {} on classpath. All properties will per default be traversable.", (Object)PERSISTENCE_UTIL_CLASS_NAME);
            return;
        }
        try {
            Class<?> jpaAwareResolverClass = this.loadClass(JPA_AWARE_TRAVERSABLE_RESOLVER_CLASS_NAME, this.getClass());
            NewInstance<?> newInstance = NewInstance.action(jpaAwareResolverClass, "");
            this.jpaTraversableResolver = System.getSecurityManager() != null ? (TraversableResolver)AccessController.doPrivileged(newInstance) : (TraversableResolver)newInstance.run();
            log.info("Instantiated an instance of {}.", (Object)JPA_AWARE_TRAVERSABLE_RESOLVER_CLASS_NAME);
        }
        catch (ValidationException e) {
            log.info("Unable to load or instanciate JPA aware resolver {}. All properties will per default be traversable.", (Object)JPA_AWARE_TRAVERSABLE_RESOLVER_CLASS_NAME);
        }
    }

    private Class<?> loadClass(String className, Class<?> caller) {
        LoadClass action = LoadClass.action(className, caller);
        if (System.getSecurityManager() != null) {
            return (Class)AccessController.doPrivileged(action);
        }
        return action.run();
    }

    public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return this.jpaTraversableResolver == null || this.jpaTraversableResolver.isReachable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
    }

    public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return this.jpaTraversableResolver == null || this.jpaTraversableResolver.isCascadable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
    }
}

