/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.search.UIViewSearchResult;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/search/UIShowAllHiddenResult.gtmpl", events={@EventConfig(listeners={ViewActionListener.class}), @EventConfig(listeners={RemoveHiddenAttributeActionListener.class}), @EventConfig(listeners={SortASCActionListener.class}), @EventConfig(listeners={SortDESCActionListener.class})})
public class UIShowAllHiddenResult
extends UIComponentDecorator {
    private static final Log LOG = ExoLogger.getLogger((String)UIShowAllHiddenResult.class.getName());
    private static final int FILE_PER_PAGE = 10;
    private static String iconType = "BlueDownArrow";
    private static String iconName = "";
    private long searchTime_ = 0L;
    private List<Node> hiddenNodes_ = new ArrayList<Node>();
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIShowAllHiddenIterator");
    private boolean nodeListChange = false;

    public UIShowAllHiddenResult() throws Exception {
        this.setUIComponent((UIComponent)this.uiPageIterator_);
    }

    public DateFormat getSimpleDateFormat() {
        Locale locale = ((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale();
        return SimpleDateFormat.getDateTimeInstance(3, 3, locale);
    }

    public long getSearchTime() {
        return this.searchTime_;
    }

    public void setSearchTime(long time) {
        this.searchTime_ = time;
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public Date getDateCreated(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            return node.getProperty("exo:dateCreated").getDate().getTime();
        }
        return new GregorianCalendar().getTime();
    }

    public List<Node> getAllHiddenNodes() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    protected List<Node> getNewHiddenNodeList() throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        boolean byUser = uiExplorer.getPreference().isShowItemsByUser();
        StringBuilder queryString = new StringBuilder("SELECT * FROM ").append("exo:hiddenable");
        if (byUser) {
            queryString.append(" WHERE CONTAINS(").append("exo:owner").append(",'").append(uiExplorer.getSession().getUserID()).append("')");
        }
        Session session = uiExplorer.getSession();
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(queryString.toString(), "sql");
        QueryResult queryResult = query.execute();
        NodeIterator iter = queryResult.getNodes();
        while (iter.hasNext()) {
            ret.add(iter.nextNode());
        }
        return ret;
    }

    public void updateList() throws Exception {
        List<Node> nodeList = this.getNewHiddenNodeList();
        ListAccessImpl hiddenNodeList = new ListAccessImpl(Node.class, nodeList);
        LazyPageList pageList = new LazyPageList((ListAccess)hiddenNodeList, 10);
        this.uiPageIterator_.setPageList((PageList)pageList);
        this.hiddenNodes_ = nodeList;
    }

    private void updateTable(Event<UIShowAllHiddenResult> event) throws Exception {
        int currentPage = this.uiPageIterator_.getCurrentPage();
        if (this.nodeListChange) {
            this.updateList();
            this.nodeListChange = false;
        }
        Collections.sort(this.hiddenNodes_, new SearchComparator());
        ListAccessImpl hiddenNodeList = new ListAccessImpl(Node.class, this.hiddenNodes_);
        LazyPageList pageList = new LazyPageList((ListAccess)hiddenNodeList, 10);
        UIPageIterator uiPageIterator = this.uiPageIterator_;
        uiPageIterator.setPageList((PageList)pageList);
        uiPageIterator.setPageList((PageList)pageList);
        if (uiPageIterator.getAvailablePage() >= currentPage) {
            uiPageIterator.setCurrentPage(currentPage);
        } else {
            uiPageIterator.setCurrentPage(uiPageIterator.getAvailablePage());
        }
        event.getRequestContext().addUIComponentToUpdateByAjax(this.getParent());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SearchComparator
    implements Comparator<Node> {
        private SearchComparator() {
        }

        @Override
        public int compare(Node node1, Node node2) {
            block6: {
                try {
                    if (iconType.equals("BlueUpArrow") || iconType.equals("BlueDownArrow")) {
                        String s1 = node1.getProperty("jcr:primaryType").getString();
                        String s2 = node2.getProperty("jcr:primaryType").getString();
                        if (iconType.trim().equals("BlueUpArrow")) {
                            return s2.compareTo(s1);
                        }
                        return s1.compareTo(s2);
                    }
                    if (iconName.equals("BlueUpArrow") || iconName.equals("BlueDownArrow")) {
                        String name1 = node1.getName();
                        String name2 = node2.getName();
                        if (iconName.trim().equals("BlueUpArrow")) {
                            return name2.compareTo(name1);
                        }
                        return name1.compareTo(name2);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block6;
                    LOG.error((Object)"Cannot compare nodes", (Throwable)e);
                }
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewActionListener
    extends EventListener<UIShowAllHiddenResult> {
        public void execute(Event<UIShowAllHiddenResult> event) throws Exception {
            Node node;
            UIShowAllHiddenResult uiShowAllHiddenResult = (UIShowAllHiddenResult)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiShowAllHiddenResult.getAncestorOfType(UIJCRExplorer.class);
            String path = event.getRequestContext().getRequestParameter("objectId");
            UIApplication uiApp = (UIApplication)uiShowAllHiddenResult.getAncestorOfType(UIApplication.class);
            try {
                node = uiExplorer.getNodeByPath(path, uiExplorer.getTargetSession());
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UIShowAllHiddenResult.msg.access-denied", null, 1));
                return;
            }
            TemplateService templateService = (TemplateService)uiShowAllHiddenResult.getApplicationComponent(TemplateService.class);
            if (!templateService.isManagedNodeType(node.getPrimaryNodeType().getName())) {
                uiApp.addMessage(new ApplicationMessage("UIShowAllHiddenResult.msg.not-support", null, 1));
                return;
            }
            UIPopupWindow uiPopup = (UIPopupWindow)uiExplorer.getChildById("ViewSearch");
            if (uiPopup == null) {
                uiPopup = (UIPopupWindow)uiExplorer.addChild(UIPopupWindow.class, null, "ViewSearch");
            }
            uiPopup.setResizable(true);
            uiPopup.setShowMask(true);
            UIViewSearchResult uiViewSearch = (UIViewSearchResult)uiPopup.createUIComponent(UIViewSearchResult.class, null, null);
            uiViewSearch.setNode(node);
            uiPopup.setWindowSize(600, 750);
            uiPopup.setUIComponent((UIComponent)uiViewSearch);
            uiPopup.setRendered(true);
            uiPopup.setShow(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveHiddenAttributeActionListener
    extends EventListener<UIShowAllHiddenResult> {
        public void execute(Event<UIShowAllHiddenResult> event) throws Exception {
            String srcPath = event.getRequestContext().getRequestParameter("objectId");
            UIShowAllHiddenResult uiShowAllHiddenResult = (UIShowAllHiddenResult)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiShowAllHiddenResult.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiShowAllHiddenResult.getAncestorOfType(UIApplication.class);
            Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(srcPath);
            String wsName = null;
            Node node = null;
            if (!matcher.find()) {
                throw new IllegalArgumentException("The ObjectId is invalid '" + srcPath + "'");
            }
            wsName = matcher.group(1);
            srcPath = matcher.group(2);
            Session session = uiExplorer.getSessionByWorkspace(wsName);
            try {
                node = uiExplorer.getNodeByPath(srcPath, session, false);
                session = node.getSession();
            }
            catch (PathNotFoundException path) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
                return;
            }
            try {
                uiExplorer.addLockToken(node);
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
            try {
                if (!PermissionUtil.canRemoveNode((Node)node)) {
                    throw new AccessDeniedException();
                }
                uiShowAllHiddenResult.nodeListChange = true;
                node.removeMixin("exo:hiddenable");
                node.save();
                uiShowAllHiddenResult.updateTable((Event<UIShowAllHiddenResult>)event);
            }
            catch (LockException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("node is locked, can't remove hidden property of node :" + node.getPath()));
                }
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
                uiExplorer.updateAjax(event);
            }
            catch (AccessDeniedException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Access denied! No permission for modifying property exo:hiddenable of node: " + node.getPath()));
                }
                uiApp.addMessage(new ApplicationMessage("UIShowAllHiddenResult.msg.accessDenied", null, 1));
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"an unexpected error occurs while removing the node", (Throwable)e);
                }
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SortDESCActionListener
    extends EventListener<UIShowAllHiddenResult> {
        public void execute(Event<UIShowAllHiddenResult> event) throws Exception {
            UIShowAllHiddenResult uiShowAllHiddenResult = (UIShowAllHiddenResult)((Object)event.getSource());
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            if (objectId.equals("type")) {
                iconType = "BlueUpArrow";
                iconName = "";
            } else if (objectId.equals("name")) {
                iconType = "";
                iconName = "BlueUpArrow";
            }
            uiShowAllHiddenResult.updateTable((Event<UIShowAllHiddenResult>)event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SortASCActionListener
    extends EventListener<UIShowAllHiddenResult> {
        public void execute(Event<UIShowAllHiddenResult> event) throws Exception {
            UIShowAllHiddenResult uiShowAllHiddenResult = (UIShowAllHiddenResult)((Object)event.getSource());
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            if (objectId.equals("type")) {
                iconType = "BlueDownArrow";
                iconName = "";
            } else if (objectId.equals("name")) {
                iconType = "";
                iconName = "BlueDownArrow";
            }
            uiShowAllHiddenResult.updateTable((Event<UIShowAllHiddenResult>)event);
        }
    }
}

