/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.ObjectReference;

public class ObjectPropertyReference
extends EntityReference {
    public ObjectPropertyReference(EntityReference reference) {
        super(reference);
    }

    protected ObjectPropertyReference(EntityReference reference, EntityReference oldReference, EntityReference newReference) {
        super(reference, oldReference, newReference);
    }

    public ObjectPropertyReference(String propertyName, ObjectReference objectReference) {
        super(propertyName, EntityType.OBJECT_PROPERTY, (EntityReference)objectReference);
    }

    @Deprecated
    public ObjectPropertyReference(String wiki, String space, String page, String objectName, String propertyName) {
        this(propertyName, new ObjectReference(wiki, space, page, objectName));
    }

    @Override
    protected void setType(EntityType type) {
        if (type != EntityType.OBJECT_PROPERTY) {
            throw new IllegalArgumentException("Invalid type [" + (Object)((Object)type) + "] for an object property reference");
        }
        super.setType(EntityType.OBJECT_PROPERTY);
    }

    @Override
    protected void setParent(EntityReference parent) {
        if (parent instanceof ObjectReference) {
            super.setParent(parent);
            return;
        }
        if (parent == null || parent.getType() != EntityType.OBJECT) {
            throw new IllegalArgumentException("Invalid parent reference [" + parent + "] in an object property reference");
        }
        super.setParent(new ObjectReference(parent));
    }

    @Override
    public ObjectPropertyReference replaceParent(EntityReference oldParent, EntityReference newParent) {
        return new ObjectPropertyReference(this, oldParent, newParent);
    }
}

