/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.service.rest.Util;

@Path(value="{portalName}/social/identity/{username}/id")
public class IdentityRestService
implements ResourceContainer {
    private IdentityManager _identityManager;

    @GET
    @Path(value="show.json")
    @Produces(value={"application/json"})
    public UserId getId(@Context UriInfo uriInfo, @PathParam(value="username") String username, @PathParam(value="portalName") String portalName) throws Exception {
        Identity identity;
        this._identityManager = this.getIdentityManager(portalName);
        String id = null;
        String viewerId = Util.getViewerId(uriInfo);
        if (viewerId != null && (identity = this.getIdentityManager(portalName).getOrCreateIdentity("organization", viewerId, true)) == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        try {
            id = this._identityManager.getOrCreateIdentity("organization", username).getId();
        }
        catch (Exception ex) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        UserId userId = new UserId(id);
        return userId;
    }

    private IdentityManager getIdentityManager(String portalName) {
        if (this._identityManager == null) {
            PortalContainer portalContainer = (PortalContainer)ExoContainerContext.getContainerByName((String)portalName);
            this._identityManager = (IdentityManager)portalContainer.getComponentInstanceOfType(IdentityManager.class);
        }
        return this._identityManager;
    }

    public class UserId {
        private String _id;

        public UserId() {
        }

        public UserId(String id) {
            this._id = id;
        }

        public void setId(String id) {
            this._id = id;
        }

        public String getId() {
            return this._id;
        }

        public String toString() {
            return this._id;
        }
    }
}

