/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xml;

import javax.inject.Inject;
import org.xml.sax.ContentHandler;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.internal.renderer.xml.ContentHandlerPrintRenderer;
import org.xwiki.rendering.renderer.PrintRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.renderer.xml.ContentHandlerStreamRenderer;
import org.xwiki.rendering.renderer.xml.ContentHandlerStreamRendererFactory;

public abstract class AbstractStreamRendererFactory
implements PrintRendererFactory,
ContentHandlerStreamRendererFactory {
    @Inject
    protected ComponentManager componentManager;

    protected ContentHandlerStreamRenderer createContentHandlerStreamRenderer() {
        ContentHandlerStreamRenderer renderer;
        try {
            renderer = (ContentHandlerStreamRenderer)this.componentManager.getInstance(ContentHandlerStreamRenderer.class, this.getSyntax().toIdString());
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Failed to create [" + this.getSyntax().toString() + "] renderer", e);
        }
        return renderer;
    }

    @Override
    public ContentHandlerStreamRenderer createRenderer(ContentHandler contentHandler) {
        ContentHandlerStreamRenderer renderer = this.createContentHandlerStreamRenderer();
        renderer.setContentHandler(contentHandler);
        return renderer;
    }

    @Override
    public PrintRenderer createRenderer(WikiPrinter printer) {
        return new ContentHandlerPrintRenderer(this.createContentHandlerStreamRenderer(), printer);
    }
}

