/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.Serializable;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RspCollector;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class MessageDispatcherTestAsync
implements RequestHandler {
    Channel channel;
    MessageDispatcher disp;
    RspList rsp_list;
    MyCollector coll = new MyCollector();
    boolean done_submitted = true;
    static final int NUM = 10;
    String props = "UDP(loopback=true;mcast_addr=224.0.0.35;mcast_port=45566;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=10000;max_interval=20000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=5000):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=8096;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;shun=false;print_local_addr=true)";

    public void start() throws Exception {
        this.channel = new JChannel(this.props);
        this.disp = new MessageDispatcher(this.channel, null, null, this);
        this.channel.connect("MessageDispatcherTestAsyncGroup");
    }

    public void mcast(int num) throws IOException {
        if (!this.done_submitted) {
            System.err.println("Must submit 'done' (press 'd') before mcasting new message");
            return;
        }
        for (int i = 0; i < num; ++i) {
            Util.sleep(100L);
            System.out.println("Casting message #" + i);
            this.disp.castMessage(null, i, new Message(null, null, (Serializable)((Object)("Number #" + i))), this.coll);
        }
        this.done_submitted = false;
    }

    public void disconnect() {
        System.out.println("** Disconnecting channel");
        this.channel.disconnect();
        System.out.println("** Disconnecting channel -- done");
        System.out.println("** Closing channel");
        this.channel.close();
        System.out.println("** Closing channel -- done");
        System.out.println("** disp.stop()");
        this.disp.stop();
        System.out.println("** disp.stop() -- done");
    }

    public void done() {
        for (int i = 0; i < 10; ++i) {
            this.disp.done(i);
        }
        this.done_submitted = true;
    }

    @Override
    public Object handle(Message msg) {
        Object tmp = msg.getObject();
        System.out.println("** handle(" + tmp + ')');
        return tmp + ": success";
    }

    public static void main(String[] args) {
        MessageDispatcherTestAsync test = null;
        for (int i = 0; i < args.length; ++i) {
            if (!"-help".equals(args[i])) continue;
            MessageDispatcherTestAsync.help();
            return;
        }
        try {
            test = new MessageDispatcherTestAsync();
            test.start();
            block8: while (true) {
                System.out.println("[m=mcast 10 msgs x=exit]");
                int c = System.in.read();
                switch (c) {
                    case 120: {
                        test.disconnect();
                        System.exit(0);
                        return;
                    }
                    case 109: {
                        test.mcast(10);
                        continue block8;
                    }
                    case 100: {
                        test.done();
                        continue block8;
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println(e);
            return;
        }
    }

    static void help() {
        System.out.println("MessageDispatcherTestAsync");
    }

    static class MyCollector
    implements RspCollector {
        MyCollector() {
        }

        @Override
        public void receiveResponse(Object retval, Address sender) {
            System.out.println("** received response " + retval + " [sender=" + sender + ']');
        }

        @Override
        public void suspect(Address mbr) {
            System.out.println("** suspected member " + mbr);
        }

        @Override
        public void viewChange(View new_view) {
            System.out.println("** received new view " + new_view);
        }
    }
}

