/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.shindig.oauth;

import java.io.File;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.apache.shindig.auth.BlobCrypterSecurityToken;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.apache.shindig.common.util.TimeSource;
import org.exoplatform.ide.shindig.KeyCreator;
import org.exoplatform.ide.shindig.oauth.TokenRequest;
import org.exoplatform.ide.shindig.oauth.TokenResponse;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/services/shindig/securitytoken")
public class RestSecurityTokenGenerator
implements ResourceContainer {
    private final TimeSource timeSource = new TimeSource();

    @POST
    @Path(value="/createToken")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public TokenResponse createToken(TokenRequest tokenRequest, @Context SecurityContext context) {
        String securityToken = this.createToken(tokenRequest.getGadgetURL(), tokenRequest.getOwner(), tokenRequest.getViewer(), tokenRequest.getModuleId(), tokenRequest.getContainer());
        TokenResponse tokenResponse = new TokenResponse(securityToken, tokenRequest.getGadgetURL(), tokenRequest.getModuleId());
        return tokenResponse;
    }

    protected String createToken(String gadgetURL, String owner, String viewer, Long moduleId, String container) {
        try {
            BlobCrypter blobCrypter = this.getBlobCrypter();
            BlobCrypterSecurityToken t = new BlobCrypterSecurityToken(blobCrypter, container, null);
            t.setAppUrl(gadgetURL);
            t.setModuleId(moduleId.longValue());
            t.setOwnerId(owner);
            t.setViewerId(viewer);
            t.setTrustedJson("trusted");
            return t.encrypt();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BlobCrypterException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected BlobCrypter getBlobCrypter() throws IOException {
        String fileName = KeyCreator.getKeyFilePath();
        BasicBlobCrypter c = new BasicBlobCrypter(new File(fileName));
        c.timeSource = this.timeSource;
        return c;
    }
}

