/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts;

import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.fonts.AFM;
import org.icepdf.core.pobjects.fonts.FontFactory;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.util.Library;

public class FontDescriptor
extends Dictionary {
    private static final Logger logger = Logger.getLogger(FontDescriptor.class.toString());
    private FontFile font;
    public static final String FONT_NAME = "FontName";
    public static final String FONT_FAMILY = "FontFamily";
    public static final String MISSING_Stretch = "FontStretch";
    public static final String FONT_WEIGHT = "FontWeight";
    public static final String FLAGS = "Flags";
    public static final String FONT_BBOX = "FontBBox";
    public static final String ITALIC_ANGLE = "ItalicAngle";
    public static final String ASCENT = "Ascent";
    public static final String DESCENT = "Descent";
    public static final String LEADING = "Leading";
    public static final String CAP_HEIGHT = "CapHeight";
    public static final String X_HEIGHT = "XHeight";
    public static final String STEM_V = "StemV";
    public static final String STEM_H = "StemH";
    public static final String AVG_WIDTH = "AvgWidth";
    public static final String MAX_WIDTH = "MaxWidth";
    public static final String MISSING_WIDTH = "MissingWidth";
    private static final String FONT_FILE = "FontFile";
    private static final String FONT_FILE_2 = "FontFile2";
    private static final String FONT_FILE_3 = "FontFile3";
    private static final String FONT_FILE_3_TYPE_1C = "Type1C";
    private static final String FONT_FILE_3_CID_FONT_TYPE_0 = "CIDFontType0";
    private static final String FONT_FILE_3_CID_FONT_TYPE_2 = "CIDFontType2";
    private static final String FONT_FILE_3_CID_FONT_TYPE_0C = "CIDFontType0C";
    private static final String FONT_FILE_3_OPEN_TYPE = "OpenType";

    public FontDescriptor(Library l, Hashtable h) {
        super(l, h);
    }

    public static FontDescriptor createDescriptor(Library library, AFM afm) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>(5);
        properties.put(FONT_NAME, afm.getFontName());
        properties.put(FONT_FAMILY, afm.getFamilyName());
        properties.put(FONT_BBOX, afm.getFontBBox());
        properties.put(ITALIC_ANGLE, Float.valueOf(afm.getItalicAngle()));
        properties.put(MAX_WIDTH, Float.valueOf(afm.getMaxWidth()));
        properties.put(AVG_WIDTH, afm.getAvgWidth());
        properties.put(FLAGS, afm.getFlags());
        return new FontDescriptor(library, properties);
    }

    public String getFontName() {
        Object value = this.library.getObject(this.entries, FONT_NAME);
        if (value instanceof Name) {
            return ((Name)value).getName();
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public String getFontFamily() {
        Object value = this.library.getObject(this.entries, FONT_FAMILY);
        if (value instanceof StringObject) {
            StringObject familyName = (StringObject)value;
            return familyName.getDecryptedLiteralString(this.library.getSecurityManager());
        }
        return FONT_NAME;
    }

    public float getFontWeight() {
        Object value = this.library.getObject(this.entries, FONT_WEIGHT);
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        return 0.0f;
    }

    public float getMissingWidth() {
        Object value = this.library.getObject(this.entries, MISSING_WIDTH);
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        return 0.0f;
    }

    public float getAverageWidth() {
        Object value = this.library.getObject(this.entries, AVG_WIDTH);
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        return 0.0f;
    }

    public float getMaxWidth() {
        Object value = this.library.getObject(this.entries, MAX_WIDTH);
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        return 0.0f;
    }

    public float getAscent() {
        Object value = this.library.getObject(this.entries, ASCENT);
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        return 0.0f;
    }

    public float getDescent() {
        Object value = this.library.getObject(this.entries, DESCENT);
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        return 0.0f;
    }

    public FontFile getEmbeddedFont() {
        return this.font;
    }

    public PRectangle getFontBBox() {
        Object value = this.library.getObject(this.entries, FONT_BBOX);
        if (value instanceof Vector) {
            Vector rectangle = (Vector)value;
            return new PRectangle(rectangle);
        }
        return null;
    }

    public int getFlags() {
        Object value = this.library.getObject(this.entries, FLAGS);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return 0;
    }

    public void init() {
        try {
            Stream fontStream;
            FontFactory fontFactory = FontFactory.getInstance();
            if (this.entries.containsKey(FONT_FILE) && (fontStream = (Stream)this.library.getObject(this.entries, FONT_FILE)) != null) {
                this.font = fontFactory.createFontFile(fontStream, 1);
            }
            if (this.entries.containsKey(FONT_FILE_2) && (fontStream = (Stream)this.library.getObject(this.entries, FONT_FILE_2)) != null) {
                this.font = fontFactory.createFontFile(fontStream, 0);
            }
            if (this.entries.containsKey(FONT_FILE_3)) {
                fontStream = (Stream)this.library.getObject(this.entries, FONT_FILE_3);
                String subType = fontStream.getObject("Subtype").toString();
                if (subType != null && (subType.equals(FONT_FILE_3_TYPE_1C) || subType.equals(FONT_FILE_3_CID_FONT_TYPE_0) || subType.equals(FONT_FILE_3_CID_FONT_TYPE_0C))) {
                    this.font = fontFactory.createFontFile(fontStream, 1);
                }
                if (subType != null && subType.equals(FONT_FILE_3_OPEN_TYPE)) {
                    this.font = fontFactory.createFontFile(fontStream, 5);
                }
            }
        }
        catch (Throwable e) {
            logger.log(Level.FINE, "Error Reading Embedded Font ", e);
        }
    }

    public String toString() {
        String name = null;
        if (this.font != null) {
            name = this.font.getName();
        }
        return super.getPObjectReference() + " FONTDESCRIPTOR= " + this.entries.toString() + " - " + name;
    }
}

