/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.groovy;

import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ide.groovy.GroovyTemplateService;
import org.exoplatform.ide.groovy.codeassistant.ClassInfoStorage;
import org.exoplatform.ide.groovy.codeassistant.CodeAssistant;
import org.exoplatform.ide.groovy.codeassistant.DocStorage;
import org.exoplatform.ide.groovy.codeassistant.bean.GroovyAutocompletionConfig;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;

public class GroovyScriptServiceApplication
extends Application {
    private final Set<Object> objects = new HashSet<Object>();
    private final Set<Class<?>> classes = new HashSet();

    public GroovyScriptServiceApplication(ThreadLocalSessionProviderService sessionProvider, RepositoryService repositoryService, InitParams initParams) {
        if (initParams != null) {
            GroovyAutocompletionConfig config = (GroovyAutocompletionConfig)initParams.getObjectParam("autocompletion.configuration").getObject();
            if (config.getJarEntries() != null) {
                this.objects.add(new ClassInfoStorage(sessionProvider, repositoryService, config.getWsName(), config.getJarEntries(), config.isRunInThread()));
            }
            if (config.getJarsDocs() != null) {
                this.objects.add(new DocStorage(config.getWsName(), repositoryService, sessionProvider, config.getJarsDocs(), config.isRunInThread()));
            }
            this.objects.add(new CodeAssistant(config.getWsName(), repositoryService, sessionProvider));
        }
        this.classes.add(GroovyTemplateService.class);
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Object> getSingletons() {
        return this.objects;
    }
}

