/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.parser.html.Dom;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.parser.html.Nodes;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.PluginMessageType;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.ContentType;
import com.google.caja.util.Lists;
import com.google.caja.util.Pipeline;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyNamespaceFixupStage
implements Pipeline.Stage<Jobs> {
    @Override
    public boolean apply(Jobs jobs) {
        Fixer f = new Fixer(jobs.getMessageQueue());
        for (Job job : jobs.getJobsByType(ContentType.HTML, new ContentType[0])) {
            f.fix(job);
        }
        return jobs.hasNoFatalErrors();
    }

    private static class Fixer {
        final MessageQueue mq;

        Fixer(MessageQueue mq) {
            this.mq = mq;
        }

        void fix(Job job) {
            this.fix(((Dom)job.getRoot()).getValue());
        }

        private void fix(Node node) {
            Node c = node.getFirstChild();
            while (c != null) {
                Node next = c.getNextSibling();
                this.fix(c);
                c = next;
            }
            if (!(node instanceof Element)) {
                return;
            }
            Element e = (Element)node;
            if (e.getNamespaceURI() == null) {
                e = this.fixElement(e);
            }
            List<Attr> toFix = null;
            for (Attr attr : Nodes.attributesOf(e)) {
                if (attr.getNamespaceURI() != null) continue;
                if (toFix == null) {
                    toFix = Lists.newArrayList();
                }
                toFix.add(attr);
            }
            if (toFix != null) {
                String elNsUri = e.getNamespaceURI();
                for (Attr a : toFix) {
                    this.fixAttr(elNsUri, a);
                }
            }
        }

        private Element fixElement(Element e) {
            Node c;
            String ns = this.guessNamespaceAndWarn("http://www.w3.org/1999/xhtml", e);
            Element newE = e.getOwnerDocument().createElementNS(ns, e.getTagName());
            Nodes.setFilePositionFor(newE, Nodes.getFilePositionFor(e));
            while ((c = e.getFirstChild()) != null) {
                newE.appendChild(c);
            }
            List<Attr> attrs = Lists.newArrayList();
            for (Attr attr : Nodes.attributesOf(e)) {
                attrs.add(attr);
            }
            for (Attr attr : attrs) {
                e.removeAttributeNode(attr);
                newE.setAttributeNode(attr);
            }
            e.getParentNode().replaceChild(newE, e);
            return newE;
        }

        private void fixAttr(String elNsUri, Attr a) {
            Element e = a.getOwnerElement();
            String ns = this.guessNamespaceAndWarn(elNsUri, a);
            Attr newA = a.getOwnerDocument().createAttributeNS(ns, a.getName());
            newA.setNodeValue(a.getValue());
            Nodes.setFilePositionFor(newA, Nodes.getFilePositionFor(a));
            Nodes.setFilePositionForValue(newA, Nodes.getFilePositionForValue(a));
            Nodes.setRawValue(newA, Nodes.getRawValue(a));
            e.removeAttributeNode(a);
            e.setAttributeNodeNS(newA);
        }

        private String guessNamespaceAndWarn(String defaultNsUri, Node n) {
            String nsUri;
            MessageLevel level;
            String xmlIdent = n.getNodeName();
            int colon = xmlIdent.indexOf(58);
            if (colon < 0) {
                return defaultNsUri;
            }
            String prefix = xmlIdent.substring(0, colon);
            Namespaces ns = Namespaces.HTML_DEFAULT.forPrefix(prefix);
            if (ns == null) {
                level = PluginMessageType.MISSING_XML_NAMESPACE.getLevel();
                nsUri = "http://example.net/unknown-xml-namespace/";
            } else {
                level = MessageLevel.LINT;
                nsUri = ns.uri;
            }
            this.mq.addMessage((MessageTypeInt)PluginMessageType.MISSING_XML_NAMESPACE, level, Nodes.getFilePositionFor(n), MessagePart.Factory.valueOf(xmlIdent));
            return nsUri;
        }
    }
}

