/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.resolving.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.xml.resolving.XMLResolvingService;
import org.exoplatform.services.xml.resolving.impl.AddXMLResolvingContextPlugin;
import org.exoplatform.services.xml.resolving.impl.XMLResolver;
import org.xml.sax.EntityResolver;

public class XMLResolvingServiceImpl
implements XMLResolvingService {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.xml-processing.XMLResolvingServiceImpl");
    private Map<String, String> publicIDs_ = new HashMap<String, String>();
    private Map<String, String> systemIDs_ = new HashMap<String, String>();

    public EntityResolver getEntityResolver() {
        return new XMLResolver(this.publicIDs_, this.systemIDs_);
    }

    private void addEntityPublicID(String publicId, String uri) {
        if (this.publicIDs_.get(publicId) != null) {
            throw new IllegalArgumentException("Entity whith publicId " + publicId + " already exists.");
        }
        this.publicIDs_.put(publicId, uri);
        LOG.info((Object)("New entries to ResolvingService added (public) : " + publicId + " : " + uri));
    }

    private void addEntitySystemID(String systemId, String uri) {
        if (this.systemIDs_.get(systemId) != null) {
            throw new IllegalArgumentException("Entity whith systemId " + systemId + " already exists.");
        }
        this.systemIDs_.put(systemId, uri);
        LOG.info((Object)("New entries to ResolvingService added (system) : " + systemId + " : " + uri));
    }

    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof AddXMLResolvingContextPlugin) {
            AddXMLResolvingContextPlugin resolvingContextPlugin = (AddXMLResolvingContextPlugin)plugin;
            Map<String, String> t = resolvingContextPlugin.getPublicIDsResolvingtable();
            Set<String> keys = t.keySet();
            for (String key : keys) {
                this.addEntityPublicID(key, t.get(key));
            }
            t = resolvingContextPlugin.getSystemIDsResolvingtable();
            keys = t.keySet();
            for (String key : keys) {
                this.addEntitySystemID(key, t.get(key));
            }
        }
    }
}

